import * as lambda from "../../aws-lambda";
import * as sns from "../../aws-sns";
import * as core from "../../core";
import { Construct } from "../../core";
/**
 * Collection of arbitrary properties
 *
 * @deprecated this type has been deprecated in favor of using a key-value type directly
 */
export declare type Properties = {
    [key: string]: any;
};
/**
 * (deprecated) Configuration options for custom resource providers.
 *
 * @deprecated used in {@link ICustomResourceProvider} which is now deprecated
 */
export interface CustomResourceProviderConfig {
    /**
     * (deprecated) The ARN of the SNS topic or the AWS Lambda function which implements this provider.
     *
     * @deprecated
     */
    readonly serviceToken: string;
}
/**
 * (deprecated) Represents a provider for an AWS CloudFormation custom resources.
 *
 * @deprecated use `core.ICustomResourceProvider`
 */
export interface ICustomResourceProvider {
    /**
     * (deprecated) Called when this provider is used by a `CustomResource`.
     *
     * @param scope The resource that uses this provider.
     * @returns provider configuration
     * @deprecated
     */
    bind(scope: Construct): CustomResourceProviderConfig;
}
/**
 * (deprecated) Represents a provider for an AWS CloudFormation custom resources.
 *
 * @deprecated use core.CustomResource instead
 */
export declare class CustomResourceProvider implements ICustomResourceProvider {
    readonly serviceToken: string;
    /**
     * (deprecated) The Lambda provider that implements this custom resource.
     *
     * We recommend using a lambda.SingletonFunction for this.
     *
     * @deprecated
     */
    static fromLambda(handler: lambda.IFunction): CustomResourceProvider;
    /**
     * (deprecated) The SNS Topic for the provider that implements this custom resource.
     *
     * @deprecated
     */
    static fromTopic(topic: sns.ITopic): CustomResourceProvider;
    /**
     * (deprecated) Use AWS Lambda as a provider.
     *
     * @deprecated use `fromLambda`
     */
    static lambda(handler: lambda.IFunction): CustomResourceProvider;
    /**
     * (deprecated) Use an SNS topic as the provider.
     *
     * @deprecated use `fromTopic`
     */
    static topic(topic: sns.ITopic): CustomResourceProvider;
    /**
     * @param serviceToken the ServiceToken which contains the ARN for this provider.
     */
    private constructor();
    /**
     * (deprecated) Called when this provider is used by a `CustomResource`.
     *
     * @deprecated
     */
    bind(_: Construct): CustomResourceProviderConfig;
}
/**
 * (deprecated) Properties to provide a Lambda-backed custom resource.
 *
 * @deprecated use `core.CustomResourceProps`
 */
export interface CustomResourceProps {
    /**
     * (deprecated) The provider which implements the custom resource.
     *
     * You can implement a provider by listening to raw AWS CloudFormation events
     * through an SNS topic or an AWS Lambda function or use the CDK's custom
     * [resource provider framework] which makes it easier to implement robust
     * providers.
     *
     * [resource provider framework]: https://docs.aws.amazon.com/cdk/api/latest/docs/custom-resources-readme.html
     *
     * ```ts
     * // use the provider framework from aws-cdk/custom-resources:
     * provider: new custom_resources.Provider({
     *    onEventHandler: myOnEventLambda,
     *    isCompleteHandler: myIsCompleteLambda, // optional
     * });
     * ```
     *
     * ```ts
     * // invoke an AWS Lambda function when a lifecycle event occurs:
     * provider: CustomResourceProvider.fromLambda(myFunction)
     * ```
     *
     * ```ts
     * // publish lifecycle events to an SNS topic:
     * provider: CustomResourceProvider.fromTopic(myTopic)
     * ```
     *
     * @deprecated
     */
    readonly provider: ICustomResourceProvider;
    /**
     * (deprecated) Properties to pass to the Lambda.
     *
     * @default - No properties.
     * @deprecated
     */
    readonly properties?: Properties;
    /**
     * (deprecated) For custom resources, you can specify AWS::CloudFormation::CustomResource (the default) as the resource type, or you can specify your own resource type name.
     *
     * For example, you can use "Custom::MyCustomResourceTypeName".
     *
     * Custom resource type names must begin with "Custom::" and can include
     * alphanumeric characters and the following characters: _@-. You can specify
     * a custom resource type name up to a maximum length of 60 characters. You
     * cannot change the type during an update.
     *
     * Using your own resource type names helps you quickly differentiate the
     * types of custom resources in your stack. For example, if you had two custom
     * resources that conduct two different ping tests, you could name their type
     * as Custom::PingTester to make them easily identifiable as ping testers
     * (instead of using AWS::CloudFormation::CustomResource).
     *
     * @default - AWS::CloudFormation::CustomResource
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cfn-customresource.html#aws-cfn-resource-type-name
     * @deprecated
     */
    readonly resourceType?: string;
    /**
     * (deprecated) The policy to apply when this resource is removed from the application.
     *
     * @default cdk.RemovalPolicy.Destroy
     * @deprecated
     */
    readonly removalPolicy?: core.RemovalPolicy;
}
/**
 * (deprecated) Deprecated.
 *
 * @deprecated use `core.CustomResource`
 */
export declare class CustomResource extends core.CustomResource {
    /**
     * @deprecated
     */
    constructor(scope: Construct, id: string, props: CustomResourceProps);
}
