import * as route53 from "../../aws-route53";
import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) Represents a certificate in AWS Certificate Manager.
 *
 * @experimental
 */
export interface ICertificate extends IResource {
    /**
     * (experimental) The certificate's ARN.
     *
     * @experimental
     * @attribute true
     */
    readonly certificateArn: string;
}
/**
 * (experimental) Properties for your certificate.
 *
 * @experimental
 */
export interface CertificateProps {
    /**
     * (experimental) Fully-qualified domain name to request a certificate for.
     *
     * May contain wildcards, such as ``*.domain.com``.
     *
     * @experimental
     */
    readonly domainName: string;
    /**
     * (experimental) Alternative domain names on your certificate.
     *
     * Use this to register alternative domain names that represent the same site.
     *
     * @default - No additional FQDNs will be included as alternative domain names.
     * @experimental
     */
    readonly subjectAlternativeNames?: string[];
    /**
     * (deprecated) What validation domain to use for every requested domain.
     *
     * Has to be a superdomain of the requested domain.
     *
     * @default - Apex domain is used for every domain that's not overridden.
     * @deprecated use `validation` instead.
     */
    readonly validationDomains?: {
        [domainName: string]: string;
    };
    /**
     * (deprecated) Validation method used to assert domain ownership.
     *
     * @default ValidationMethod.EMAIL
     * @deprecated use `validation` instead.
     */
    readonly validationMethod?: ValidationMethod;
    /**
     * (experimental) How to validate this certificate.
     *
     * @default CertificateValidation.fromEmail()
     * @experimental
     */
    readonly validation?: CertificateValidation;
}
/**
 * (experimental) Properties for certificate validation.
 *
 * @experimental
 */
export interface CertificationValidationProps {
    /**
     * (experimental) Validation method.
     *
     * @default ValidationMethod.EMAIL
     * @experimental
     */
    readonly method?: ValidationMethod;
    /**
     * (experimental) Hosted zone to use for DNS validation.
     *
     * @default - use email validation
     * @experimental
     */
    readonly hostedZone?: route53.IHostedZone;
    /**
     * (experimental) A map of hosted zones to use for DNS validation.
     *
     * @default - use `hostedZone`
     * @experimental
     */
    readonly hostedZones?: {
        [domainName: string]: route53.IHostedZone;
    };
    /**
     * (experimental) Validation domains to use for email validation.
     *
     * @default - Apex domain
     * @experimental
     */
    readonly validationDomains?: {
        [domainName: string]: string;
    };
}
/**
 * (experimental) How to validate a certificate.
 *
 * @experimental
 */
export declare class CertificateValidation {
    readonly props: CertificationValidationProps;
    /**
     * (experimental) Validate the certificate with DNS.
     *
     * IMPORTANT: If `hostedZone` is not specified, DNS records must be added
     * manually and the stack will not complete creating until the records are
     * added.
     *
     * @param hostedZone the hosted zone where DNS records must be created.
     * @experimental
     */
    static fromDns(hostedZone?: route53.IHostedZone): CertificateValidation;
    /**
     * (experimental) Validate the certificate with automatically created DNS records in multiple Amazon Route 53 hosted zones.
     *
     * @param hostedZones a map of hosted zones where DNS records must be created for the domains in the certificate.
     * @experimental
     */
    static fromDnsMultiZone(hostedZones: {
        [domainName: string]: route53.IHostedZone;
    }): CertificateValidation;
    /**
     * (experimental) Validate the certificate with Email.
     *
     * IMPORTANT: if you are creating a certificate as part of your stack, the stack
     * will not complete creating until you read and follow the instructions in the
     * email that you will receive.
     *
     * ACM will send validation emails to the following addresses:
     *
     *   admin@domain.com
     *   administrator@domain.com
     *   hostmaster@domain.com
     *   postmaster@domain.com
     *   webmaster@domain.com
     *
     * For every domain that you register.
     *
     * @param validationDomains a map of validation domains to use for domains in the certificate.
     * @experimental
     */
    static fromEmail(validationDomains?: {
        [domainName: string]: string;
    }): CertificateValidation;
    /**
     * (experimental) The validation method.
     *
     * @experimental
     */
    readonly method: ValidationMethod;
    /** @param props Certification validation properties */
    private constructor();
}
/**
 * (experimental) A certificate managed by AWS Certificate Manager.
 *
 * @experimental
 */
export declare class Certificate extends Resource implements ICertificate {
    /**
     * (experimental) Import a certificate.
     *
     * @experimental
     */
    static fromCertificateArn(scope: Construct, id: string, certificateArn: string): ICertificate;
    /**
     * (experimental) The certificate's ARN.
     *
     * @experimental
     */
    readonly certificateArn: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CertificateProps);
}
/**
 * (experimental) Method used to assert ownership of the domain.
 *
 * @experimental
 */
export declare enum ValidationMethod {
    /**
     * (experimental) Send email to a number of email addresses associated with the domain.
     *
     * @see https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-email.html
     * @experimental
     */
    EMAIL = "EMAIL",
    /**
     * (experimental) Validate ownership by adding appropriate DNS records.
     *
     * @see https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html
     * @experimental
     */
    DNS = "DNS"
}
