"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobDefinitionImageConfig = void 0;
const ecs = require("../../aws-ecs"); // Automatically re-written from '@aws-cdk/aws-ecs'
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
/**
 * Batch Job Task Definition
 *
 * Defines a Batch Job Task Definition. The properties of this task definition mirrors
 * those of an {@link ecs.ContainerDefinition}. This class is a wrapper on that structure.
 */
class TaskDefinition {
    constructor(props) {
        this.executionRole = props.executionRole;
    }
    /**
     * Internal function to allow the Batch Job task definition
     * to match the CDK requirements of an EC2 task definition.
     *
     * @internal
     */
    _linkContainer() { }
    /**
     * Retrieves the execution role for this task definition
     */
    obtainExecutionRole() {
        return this.executionRole;
    }
}
/**
 * The configuration for creating a batch container image.
 */
class JobDefinitionImageConfig {
    constructor(scope, container) {
        const config = this.bindImageConfig(scope, container);
        this.imageName = config.imageName;
    }
    bindImageConfig(scope, container) {
        return container.image.bind(scope, new ecs.ContainerDefinition(scope, 'Resource-Batch-Job-Container-Definition', {
            command: container.command,
            cpu: container.vcpus,
            image: container.image,
            environment: container.environment,
            linuxParameters: container.linuxParams,
            memoryLimitMiB: container.memoryLimitMiB,
            privileged: container.privileged,
            readonlyRootFilesystem: container.readOnly,
            gpuCount: container.gpuCount,
            user: container.user,
            taskDefinition: new TaskDefinition({
                executionRole: container.jobRole || new iam.LazyRole(scope, 'Resource-Batch-Task-Definition-Role', {
                    assumedBy: new iam.ServicePrincipal('batch.amazonaws.com'),
                }),
            }),
        }));
    }
}
exports.JobDefinitionImageConfig = JobDefinitionImageConfig;
//# sourceMappingURL=data:application/json;base64,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