import * as secretsmanager from "../../aws-secretsmanager";
import * as ssm from "../../aws-ssm";
/**
 * (experimental) Exposed secret for log configuration.
 *
 * @experimental
 */
export declare class ExposedSecret {
    /**
     * (experimental) Use Secrets Manager Secret.
     *
     * @param optionName - The name of the option.
     * @param secret - A secret from secrets manager.
     * @experimental
     */
    static fromSecretsManager(optionName: string, secret: secretsmanager.ISecret): ExposedSecret;
    /**
     * (experimental) User Parameters Store Parameter.
     *
     * @param optionName - The name of the option.
     * @param parameter - A parameter from parameters store.
     * @experimental
     */
    static fromParametersStore(optionName: string, parameter: ssm.IParameter): ExposedSecret;
    /**
     * (experimental) Name of the option.
     *
     * @experimental
     */
    optionName: string;
    /**
     * (experimental) ARN of the secret option.
     *
     * @experimental
     */
    secretArn: string;
    /**
     * @experimental
     */
    constructor(optionName: string, secretArn: string);
}
