"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupVault = exports.BackupVaultEvents = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const backup_generated_1 = require("./backup.generated");
/**
 * (experimental) Backup vault events.
 *
 * @experimental
 */
var BackupVaultEvents;
(function (BackupVaultEvents) {
    BackupVaultEvents["BACKUP_JOB_STARTED"] = "BACKUP_JOB_STARTED";
    BackupVaultEvents["BACKUP_JOB_COMPLETED"] = "BACKUP_JOB_COMPLETED";
    BackupVaultEvents["BACKUP_JOB_SUCCESSFUL"] = "BACKUP_JOB_SUCCESSFUL";
    BackupVaultEvents["BACKUP_JOB_FAILED"] = "BACKUP_JOB_FAILED";
    BackupVaultEvents["BACKUP_JOB_EXPIRED"] = "BACKUP_JOB_EXPIRED";
    BackupVaultEvents["RESTORE_JOB_STARTED"] = "RESTORE_JOB_STARTED";
    BackupVaultEvents["RESTORE_JOB_COMPLETED"] = "RESTORE_JOB_COMPLETED";
    BackupVaultEvents["RESTORE_JOB_SUCCESSFUL"] = "RESTORE_JOB_SUCCESSFUL";
    BackupVaultEvents["RESTORE_JOB_FAILED"] = "RESTORE_JOB_FAILED";
    BackupVaultEvents["COPY_JOB_STARTED"] = "COPY_JOB_STARTED";
    BackupVaultEvents["COPY_JOB_SUCCESSFUL"] = "COPY_JOB_SUCCESSFUL";
    BackupVaultEvents["COPY_JOB_FAILED"] = "COPY_JOB_FAILED";
    BackupVaultEvents["RECOVERY_POINT_MODIFIED"] = "RECOVERY_POINT_MODIFIED";
    BackupVaultEvents["BACKUP_PLAN_CREATED"] = "BACKUP_PLAN_CREATED";
    BackupVaultEvents["BACKUP_PLAN_MODIFIED"] = "BACKUP_PLAN_MODIFIED";
})(BackupVaultEvents = exports.BackupVaultEvents || (exports.BackupVaultEvents = {}));
/**
 * (experimental) A backup vault.
 *
 * @experimental
 */
class BackupVault extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        super(scope, id);
        if (props.backupVaultName && !/^[a-zA-Z0-9\-_]{2,50}$/.test(props.backupVaultName)) {
            throw new Error('Expected vault name to match pattern `^[a-zA-Z0-9\-_]{2,50}$`');
        }
        let notifications;
        if (props.notificationTopic) {
            notifications = {
                backupVaultEvents: props.notificationEvents || Object.values(BackupVaultEvents),
                snsTopicArn: props.notificationTopic.topicArn,
            };
            props.notificationTopic.grantPublish(new iam.ServicePrincipal('backup.amazonaws.com'));
        }
        const vault = new backup_generated_1.CfnBackupVault(this, 'Resource', {
            backupVaultName: props.backupVaultName || this.uniqueVaultName(),
            accessPolicy: props.accessPolicy && props.accessPolicy.toJSON(),
            encryptionKeyArn: props.encryptionKey && props.encryptionKey.keyArn,
            notifications,
        });
        vault.applyRemovalPolicy(props.removalPolicy);
        this.backupVaultName = vault.attrBackupVaultName;
        this.backupVaultArn = vault.attrBackupVaultArn;
    }
    /**
     * (experimental) Import an existing backup vault.
     *
     * @experimental
     */
    static fromBackupVaultName(scope, id, backupVaultName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.backupVaultName = backupVaultName;
            }
        }
        return new Import(scope, id);
    }
    uniqueVaultName() {
        // Max length of 50 chars, get the last 50 chars
        const id = core_1.Names.uniqueId(this);
        return id.substring(Math.max(id.length - 50, 0), id.length);
    }
}
exports.BackupVault = BackupVault;
_a = JSII_RTTI_SYMBOL_1;
BackupVault[_a] = { fqn: "monocdk.aws_backup.BackupVault", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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