"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupSelection = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const backup_generated_1 = require("./backup.generated");
const backupable_resources_collector_1 = require("./backupable-resources-collector");
const resource_1 = require("./resource");
/**
 * (experimental) A backup selection.
 *
 * @experimental
 */
class BackupSelection extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.listOfTags = [];
        this.resources = [];
        this.backupableResourcesCollector = new backupable_resources_collector_1.BackupableResourcesCollector();
        const role = props.role || new iam.Role(this, 'Role', {
            assumedBy: new iam.ServicePrincipal('backup.amazonaws.com'),
        });
        role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSBackupServiceRolePolicyForBackup'));
        if (props.allowRestores) {
            role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSBackupServiceRolePolicyForRestores'));
        }
        this.grantPrincipal = role;
        const selection = new backup_generated_1.CfnBackupSelection(this, 'Resource', {
            backupPlanId: props.backupPlan.backupPlanId,
            backupSelection: {
                iamRoleArn: role.roleArn,
                selectionName: props.backupSelectionName || this.node.id,
                listOfTags: core_1.Lazy.any({
                    produce: () => this.listOfTags,
                }, { omitEmptyArray: true }),
                resources: core_1.Lazy.list({
                    produce: () => [...this.resources, ...this.backupableResourcesCollector.resources],
                }, { omitEmpty: true }),
            },
        });
        this.backupPlanId = selection.attrBackupPlanId;
        this.selectionId = selection.attrSelectionId;
        for (const resource of props.resources) {
            this.addResource(resource);
        }
    }
    addResource(resource) {
        if (resource.tagCondition) {
            this.listOfTags.push({
                conditionKey: resource.tagCondition.key,
                conditionType: resource.tagCondition.operation || resource_1.TagOperation.STRING_EQUALS,
                conditionValue: resource.tagCondition.value,
            });
        }
        if (resource.resource) {
            this.resources.push(resource.resource);
        }
        if (resource.construct) {
            core_1.Aspects.of(resource.construct).add(this.backupableResourcesCollector);
            // Cannot push `this.backupableResourcesCollector.resources` to
            // `this.resources` here because it has not been evaluated yet.
            // Will be concatenated to `this.resources` in a `Lazy.list`
            // in the constructor instead.
        }
    }
}
exports.BackupSelection = BackupSelection;
_a = JSII_RTTI_SYMBOL_1;
BackupSelection[_a] = { fqn: "monocdk.aws_backup.BackupSelection", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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