import * as iam from "../../aws-iam";
import { Resource } from "../../core";
import { Construct } from 'constructs';
import { IBackupPlan } from './plan';
import { BackupResource } from './resource';
/**
 * (experimental) Options for a BackupSelection.
 *
 * @experimental
 */
export interface BackupSelectionOptions {
    /**
     * (experimental) The resources to backup.
     *
     * Use the helper static methods defined on `BackupResource`.
     *
     * @experimental
     */
    readonly resources: BackupResource[];
    /**
     * (experimental) The name for this selection.
     *
     * @default - a CDK generated name
     * @experimental
     */
    readonly backupSelectionName?: string;
    /**
     * (experimental) The role that AWS Backup uses to authenticate when backuping or restoring the resources.
     *
     * The `AWSBackupServiceRolePolicyForBackup` managed policy
     * will be attached to this role.
     *
     * @default - a new role will be created
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) Whether to automatically give restores permissions to the role that AWS Backup uses.
     *
     * If `true`, the `AWSBackupServiceRolePolicyForRestores` managed
     * policy will be attached to the role.
     *
     * @default false
     * @experimental
     */
    readonly allowRestores?: boolean;
}
/**
 * (experimental) Properties for a BackupSelection.
 *
 * @experimental
 */
export interface BackupSelectionProps extends BackupSelectionOptions {
    /**
     * (experimental) The backup plan for this selection.
     *
     * @experimental
     */
    readonly backupPlan: IBackupPlan;
}
/**
 * (experimental) A backup selection.
 *
 * @experimental
 */
export declare class BackupSelection extends Resource implements iam.IGrantable {
    /**
     * (experimental) The identifier of the backup plan.
     *
     * @experimental
     * @attribute true
     */
    readonly backupPlanId: string;
    /**
     * (experimental) The identifier of the backup selection.
     *
     * @experimental
     * @attribute true
     */
    readonly selectionId: string;
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    readonly grantPrincipal: iam.IPrincipal;
    private listOfTags;
    private resources;
    private readonly backupableResourcesCollector;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: BackupSelectionProps);
    private addResource;
}
