"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupResource = exports.TagOperation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) An operation that is applied to a key-value pair.
 *
 * @experimental
 */
var TagOperation;
(function (TagOperation) {
    TagOperation["STRING_EQUALS"] = "STRINGEQUALS";
    TagOperation["DUMMY"] = "dummy";
})(TagOperation = exports.TagOperation || (exports.TagOperation = {}));
/**
 * (experimental) A resource to backup.
 *
 * @experimental
 */
class BackupResource {
    /**
     * @experimental
     */
    constructor(resource, tagCondition, construct) {
        this.resource = resource;
        this.tagCondition = tagCondition;
        this.construct = construct;
    }
    /**
     * (experimental) Adds all supported resources in a construct.
     *
     * @param construct The construct containing resources to backup.
     * @experimental
     */
    static fromConstruct(construct) {
        return new BackupResource(undefined, undefined, construct);
    }
    /**
     * (experimental) A DynamoDB table.
     *
     * @experimental
     */
    static fromDynamoDbTable(table) {
        return BackupResource.fromArn(table.tableArn);
    }
    /**
     * (experimental) An EC2 instance.
     *
     * @experimental
     */
    static fromEc2Instance(instance) {
        return BackupResource.fromArn(core_1.Stack.of(instance).formatArn({
            service: 'ec2',
            resource: 'instance',
            resourceName: instance.instanceId,
        }));
    }
    /**
     * (experimental) An EFS file system.
     *
     * @experimental
     */
    static fromEfsFileSystem(fileSystem) {
        return BackupResource.fromArn(core_1.Stack.of(fileSystem).formatArn({
            service: 'elasticfilesystem',
            resource: 'file-system',
            resourceName: fileSystem.fileSystemId,
        }));
    }
    /**
     * (experimental) A RDS database instance.
     *
     * @experimental
     */
    static fromRdsDatabaseInstance(instance) {
        return BackupResource.fromArn(instance.instanceArn);
    }
    /**
     * (experimental) A list of ARNs or match patterns such as `arn:aws:ec2:us-east-1:123456789012:volume/*`.
     *
     * @experimental
     */
    static fromArn(arn) {
        return new BackupResource(arn);
    }
    /**
     * (experimental) A tag condition.
     *
     * @experimental
     */
    static fromTag(key, value, operation) {
        return new BackupResource(undefined, {
            key,
            value,
            operation,
        });
    }
}
exports.BackupResource = BackupResource;
_a = JSII_RTTI_SYMBOL_1;
BackupResource[_a] = { fqn: "monocdk.aws_backup.BackupResource", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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