"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupPlan = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const backup_generated_1 = require("./backup.generated");
const rule_1 = require("./rule");
const selection_1 = require("./selection");
const vault_1 = require("./vault");
/**
 * (experimental) A backup plan.
 *
 * @experimental
 */
class BackupPlan extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.rules = [];
        const plan = new backup_generated_1.CfnBackupPlan(this, 'Resource', {
            backupPlan: {
                backupPlanName: props.backupPlanName || id,
                backupPlanRule: core_1.Lazy.any({ produce: () => this.rules }, { omitEmptyArray: true }),
            },
        });
        this.backupPlanId = plan.attrBackupPlanId;
        this.backupPlanArn = plan.attrBackupPlanArn;
        this.versionId = plan.attrVersionId;
        this._backupVault = props.backupVault;
        for (const rule of props.backupPlanRules || []) {
            this.addRule(rule);
        }
    }
    /**
     * (experimental) Import an existing backup plan.
     *
     * @experimental
     */
    static fromBackupPlanId(scope, id, backupPlanId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.backupPlanId = backupPlanId;
            }
        }
        return new Import(scope, id);
    }
    /**
     * (experimental) Daily with 35 day retention.
     *
     * @experimental
     */
    static daily35DayRetention(scope, id, backupVault) {
        const plan = new BackupPlan(scope, id, { backupVault });
        plan.addRule(rule_1.BackupPlanRule.daily());
        return plan;
    }
    /**
     * (experimental) Daily and monthly with 1 year retention.
     *
     * @experimental
     */
    static dailyMonthly1YearRetention(scope, id, backupVault) {
        const plan = new BackupPlan(scope, id, { backupVault });
        plan.addRule(rule_1.BackupPlanRule.daily());
        plan.addRule(rule_1.BackupPlanRule.monthly1Year());
        return plan;
    }
    /**
     * (experimental) Daily, weekly and monthly with 5 year retention.
     *
     * @experimental
     */
    static dailyWeeklyMonthly5YearRetention(scope, id, backupVault) {
        const plan = new BackupPlan(scope, id, { backupVault });
        plan.addRule(rule_1.BackupPlanRule.daily());
        plan.addRule(rule_1.BackupPlanRule.weekly());
        plan.addRule(rule_1.BackupPlanRule.monthly5Year());
        return plan;
    }
    /**
     * (experimental) Daily, weekly and monthly with 7 year retention.
     *
     * @experimental
     */
    static dailyWeeklyMonthly7YearRetention(scope, id, backupVault) {
        const plan = new BackupPlan(scope, id, { backupVault });
        plan.addRule(rule_1.BackupPlanRule.daily());
        plan.addRule(rule_1.BackupPlanRule.weekly());
        plan.addRule(rule_1.BackupPlanRule.monthly7Year());
        return plan;
    }
    /**
     * (experimental) Adds a rule to a plan.
     *
     * @param rule the rule to add.
     * @experimental
     */
    addRule(rule) {
        var _b, _c, _d, _e, _f, _g;
        let vault;
        if (rule.props.backupVault) {
            vault = rule.props.backupVault;
        }
        else if (this._backupVault) {
            vault = this._backupVault;
        }
        else {
            this._backupVault = new vault_1.BackupVault(this, 'Vault');
            vault = this._backupVault;
        }
        this.rules.push({
            completionWindowMinutes: (_b = rule.props.completionWindow) === null || _b === void 0 ? void 0 : _b.toMinutes(),
            lifecycle: (rule.props.deleteAfter || rule.props.moveToColdStorageAfter) && {
                deleteAfterDays: (_c = rule.props.deleteAfter) === null || _c === void 0 ? void 0 : _c.toDays(),
                moveToColdStorageAfterDays: (_d = rule.props.moveToColdStorageAfter) === null || _d === void 0 ? void 0 : _d.toDays(),
            },
            ruleName: (_e = rule.props.ruleName) !== null && _e !== void 0 ? _e : `${this.node.id}Rule${this.rules.length}`,
            scheduleExpression: (_f = rule.props.scheduleExpression) === null || _f === void 0 ? void 0 : _f.expressionString,
            startWindowMinutes: (_g = rule.props.startWindow) === null || _g === void 0 ? void 0 : _g.toMinutes(),
            targetBackupVault: vault.backupVaultName,
        });
    }
    /**
     * (experimental) The backup vault where backups are stored if not defined at the rule level.
     *
     * @experimental
     */
    get backupVault() {
        if (!this._backupVault) {
            // This cannot happen but is here to make TypeScript happy
            throw new Error('No backup vault!');
        }
        return this._backupVault;
    }
    /**
     * (experimental) Adds a selection to this plan.
     *
     * @experimental
     */
    addSelection(id, options) {
        return new selection_1.BackupSelection(this, id, {
            backupPlan: this,
            ...options,
        });
    }
    /**
     * (experimental) Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     *
     * @experimental
     */
    validate() {
        if (this.rules.length === 0) {
            return ['A backup plan must have at least 1 rule.'];
        }
        return [];
    }
}
exports.BackupPlan = BackupPlan;
_a = JSII_RTTI_SYMBOL_1;
BackupPlan[_a] = { fqn: "monocdk.aws_backup.BackupPlan", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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