import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::Backup::BackupPlan`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html
 */
export interface CfnBackupPlanProps {
    /**
     * `AWS::Backup::BackupPlan.BackupPlan`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html#cfn-backup-backupplan-backupplan
     */
    readonly backupPlan: CfnBackupPlan.BackupPlanResourceTypeProperty | cdk.IResolvable;
    /**
     * `AWS::Backup::BackupPlan.BackupPlanTags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html#cfn-backup-backupplan-backupplantags
     */
    readonly backupPlanTags?: {
        [key: string]: (string);
    } | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Backup::BackupPlan`.
 *
 * @external
 * @cloudformationResource AWS::Backup::BackupPlan
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html
 */
export declare class CfnBackupPlan extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Backup::BackupPlan";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnBackupPlan;
    /**
     * @external
     * @cloudformationAttribute BackupPlanArn
     */
    readonly attrBackupPlanArn: string;
    /**
     * @external
     * @cloudformationAttribute BackupPlanId
     */
    readonly attrBackupPlanId: string;
    /**
     * @external
     * @cloudformationAttribute VersionId
     */
    readonly attrVersionId: string;
    /**
     * `AWS::Backup::BackupPlan.BackupPlan`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html#cfn-backup-backupplan-backupplan
     */
    backupPlan: CfnBackupPlan.BackupPlanResourceTypeProperty | cdk.IResolvable;
    /**
     * `AWS::Backup::BackupPlan.BackupPlanTags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html#cfn-backup-backupplan-backupplantags
     */
    backupPlanTags: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Backup::BackupPlan`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBackupPlanProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Backup::BackupPlan`.
 *
 * @external
 * @cloudformationResource AWS::Backup::BackupPlan
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html
 */
export declare namespace CfnBackupPlan {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-advancedbackupsettingresourcetype.html
     */
    interface AdvancedBackupSettingResourceTypeProperty {
        /**
         * `CfnBackupPlan.AdvancedBackupSettingResourceTypeProperty.BackupOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-advancedbackupsettingresourcetype.html#cfn-backup-backupplan-advancedbackupsettingresourcetype-backupoptions
         */
        readonly backupOptions: any | cdk.IResolvable;
        /**
         * `CfnBackupPlan.AdvancedBackupSettingResourceTypeProperty.ResourceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-advancedbackupsettingresourcetype.html#cfn-backup-backupplan-advancedbackupsettingresourcetype-resourcetype
         */
        readonly resourceType: string;
    }
}
/**
 * A CloudFormation `AWS::Backup::BackupPlan`.
 *
 * @external
 * @cloudformationResource AWS::Backup::BackupPlan
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html
 */
export declare namespace CfnBackupPlan {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupplanresourcetype.html
     */
    interface BackupPlanResourceTypeProperty {
        /**
         * `CfnBackupPlan.BackupPlanResourceTypeProperty.AdvancedBackupSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupplanresourcetype.html#cfn-backup-backupplan-backupplanresourcetype-advancedbackupsettings
         */
        readonly advancedBackupSettings?: Array<CfnBackupPlan.AdvancedBackupSettingResourceTypeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnBackupPlan.BackupPlanResourceTypeProperty.BackupPlanName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupplanresourcetype.html#cfn-backup-backupplan-backupplanresourcetype-backupplanname
         */
        readonly backupPlanName: string;
        /**
         * `CfnBackupPlan.BackupPlanResourceTypeProperty.BackupPlanRule`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupplanresourcetype.html#cfn-backup-backupplan-backupplanresourcetype-backupplanrule
         */
        readonly backupPlanRule: Array<CfnBackupPlan.BackupRuleResourceTypeProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Backup::BackupPlan`.
 *
 * @external
 * @cloudformationResource AWS::Backup::BackupPlan
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html
 */
export declare namespace CfnBackupPlan {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html
     */
    interface BackupRuleResourceTypeProperty {
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.CompletionWindowMinutes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-completionwindowminutes
         */
        readonly completionWindowMinutes?: number;
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.CopyActions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-copyactions
         */
        readonly copyActions?: Array<CfnBackupPlan.CopyActionResourceTypeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.EnableContinuousBackup`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-enablecontinuousbackup
         */
        readonly enableContinuousBackup?: boolean | cdk.IResolvable;
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.Lifecycle`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-lifecycle
         */
        readonly lifecycle?: CfnBackupPlan.LifecycleResourceTypeProperty | cdk.IResolvable;
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.RecoveryPointTags`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-recoverypointtags
         */
        readonly recoveryPointTags?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.RuleName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-rulename
         */
        readonly ruleName: string;
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.ScheduleExpression`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-scheduleexpression
         */
        readonly scheduleExpression?: string;
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.StartWindowMinutes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-startwindowminutes
         */
        readonly startWindowMinutes?: number;
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.TargetBackupVault`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-targetbackupvault
         */
        readonly targetBackupVault: string;
    }
}
/**
 * A CloudFormation `AWS::Backup::BackupPlan`.
 *
 * @external
 * @cloudformationResource AWS::Backup::BackupPlan
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html
 */
export declare namespace CfnBackupPlan {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-copyactionresourcetype.html
     */
    interface CopyActionResourceTypeProperty {
        /**
         * `CfnBackupPlan.CopyActionResourceTypeProperty.DestinationBackupVaultArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-copyactionresourcetype.html#cfn-backup-backupplan-copyactionresourcetype-destinationbackupvaultarn
         */
        readonly destinationBackupVaultArn: string;
        /**
         * `CfnBackupPlan.CopyActionResourceTypeProperty.Lifecycle`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-copyactionresourcetype.html#cfn-backup-backupplan-copyactionresourcetype-lifecycle
         */
        readonly lifecycle?: CfnBackupPlan.LifecycleResourceTypeProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Backup::BackupPlan`.
 *
 * @external
 * @cloudformationResource AWS::Backup::BackupPlan
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html
 */
export declare namespace CfnBackupPlan {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-lifecycleresourcetype.html
     */
    interface LifecycleResourceTypeProperty {
        /**
         * `CfnBackupPlan.LifecycleResourceTypeProperty.DeleteAfterDays`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-lifecycleresourcetype.html#cfn-backup-backupplan-lifecycleresourcetype-deleteafterdays
         */
        readonly deleteAfterDays?: number;
        /**
         * `CfnBackupPlan.LifecycleResourceTypeProperty.MoveToColdStorageAfterDays`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-lifecycleresourcetype.html#cfn-backup-backupplan-lifecycleresourcetype-movetocoldstorageafterdays
         */
        readonly moveToColdStorageAfterDays?: number;
    }
}
/**
 * Properties for defining a `AWS::Backup::BackupSelection`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html
 */
export interface CfnBackupSelectionProps {
    /**
     * `AWS::Backup::BackupSelection.BackupPlanId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html#cfn-backup-backupselection-backupplanid
     */
    readonly backupPlanId: string;
    /**
     * `AWS::Backup::BackupSelection.BackupSelection`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html#cfn-backup-backupselection-backupselection
     */
    readonly backupSelection: CfnBackupSelection.BackupSelectionResourceTypeProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Backup::BackupSelection`.
 *
 * @external
 * @cloudformationResource AWS::Backup::BackupSelection
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html
 */
export declare class CfnBackupSelection extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Backup::BackupSelection";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnBackupSelection;
    /**
     * @external
     * @cloudformationAttribute BackupPlanId
     */
    readonly attrBackupPlanId: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute SelectionId
     */
    readonly attrSelectionId: string;
    /**
     * `AWS::Backup::BackupSelection.BackupPlanId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html#cfn-backup-backupselection-backupplanid
     */
    backupPlanId: string;
    /**
     * `AWS::Backup::BackupSelection.BackupSelection`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html#cfn-backup-backupselection-backupselection
     */
    backupSelection: CfnBackupSelection.BackupSelectionResourceTypeProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::Backup::BackupSelection`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBackupSelectionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Backup::BackupSelection`.
 *
 * @external
 * @cloudformationResource AWS::Backup::BackupSelection
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html
 */
export declare namespace CfnBackupSelection {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-backupselectionresourcetype.html
     */
    interface BackupSelectionResourceTypeProperty {
        /**
         * `CfnBackupSelection.BackupSelectionResourceTypeProperty.IamRoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-backupselectionresourcetype.html#cfn-backup-backupselection-backupselectionresourcetype-iamrolearn
         */
        readonly iamRoleArn: string;
        /**
         * `CfnBackupSelection.BackupSelectionResourceTypeProperty.ListOfTags`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-backupselectionresourcetype.html#cfn-backup-backupselection-backupselectionresourcetype-listoftags
         */
        readonly listOfTags?: Array<CfnBackupSelection.ConditionResourceTypeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnBackupSelection.BackupSelectionResourceTypeProperty.Resources`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-backupselectionresourcetype.html#cfn-backup-backupselection-backupselectionresourcetype-resources
         */
        readonly resources?: string[];
        /**
         * `CfnBackupSelection.BackupSelectionResourceTypeProperty.SelectionName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-backupselectionresourcetype.html#cfn-backup-backupselection-backupselectionresourcetype-selectionname
         */
        readonly selectionName: string;
    }
}
/**
 * A CloudFormation `AWS::Backup::BackupSelection`.
 *
 * @external
 * @cloudformationResource AWS::Backup::BackupSelection
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html
 */
export declare namespace CfnBackupSelection {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-conditionresourcetype.html
     */
    interface ConditionResourceTypeProperty {
        /**
         * `CfnBackupSelection.ConditionResourceTypeProperty.ConditionKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-conditionresourcetype.html#cfn-backup-backupselection-conditionresourcetype-conditionkey
         */
        readonly conditionKey: string;
        /**
         * `CfnBackupSelection.ConditionResourceTypeProperty.ConditionType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-conditionresourcetype.html#cfn-backup-backupselection-conditionresourcetype-conditiontype
         */
        readonly conditionType: string;
        /**
         * `CfnBackupSelection.ConditionResourceTypeProperty.ConditionValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-conditionresourcetype.html#cfn-backup-backupselection-conditionresourcetype-conditionvalue
         */
        readonly conditionValue: string;
    }
}
/**
 * Properties for defining a `AWS::Backup::BackupVault`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html
 */
export interface CfnBackupVaultProps {
    /**
     * `AWS::Backup::BackupVault.BackupVaultName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-backupvaultname
     */
    readonly backupVaultName: string;
    /**
     * `AWS::Backup::BackupVault.AccessPolicy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-accesspolicy
     */
    readonly accessPolicy?: any | cdk.IResolvable;
    /**
     * `AWS::Backup::BackupVault.BackupVaultTags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-backupvaulttags
     */
    readonly backupVaultTags?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::Backup::BackupVault.EncryptionKeyArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-encryptionkeyarn
     */
    readonly encryptionKeyArn?: string;
    /**
     * `AWS::Backup::BackupVault.Notifications`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-notifications
     */
    readonly notifications?: CfnBackupVault.NotificationObjectTypeProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Backup::BackupVault`.
 *
 * @external
 * @cloudformationResource AWS::Backup::BackupVault
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html
 */
export declare class CfnBackupVault extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Backup::BackupVault";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnBackupVault;
    /**
     * @external
     * @cloudformationAttribute BackupVaultArn
     */
    readonly attrBackupVaultArn: string;
    /**
     * @external
     * @cloudformationAttribute BackupVaultName
     */
    readonly attrBackupVaultName: string;
    /**
     * `AWS::Backup::BackupVault.BackupVaultName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-backupvaultname
     */
    backupVaultName: string;
    /**
     * `AWS::Backup::BackupVault.AccessPolicy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-accesspolicy
     */
    accessPolicy: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Backup::BackupVault.BackupVaultTags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-backupvaulttags
     */
    backupVaultTags: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::Backup::BackupVault.EncryptionKeyArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-encryptionkeyarn
     */
    encryptionKeyArn: string | undefined;
    /**
     * `AWS::Backup::BackupVault.Notifications`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-notifications
     */
    notifications: CfnBackupVault.NotificationObjectTypeProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Backup::BackupVault`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBackupVaultProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Backup::BackupVault`.
 *
 * @external
 * @cloudformationResource AWS::Backup::BackupVault
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html
 */
export declare namespace CfnBackupVault {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-notificationobjecttype.html
     */
    interface NotificationObjectTypeProperty {
        /**
         * `CfnBackupVault.NotificationObjectTypeProperty.BackupVaultEvents`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-notificationobjecttype.html#cfn-backup-backupvault-notificationobjecttype-backupvaultevents
         */
        readonly backupVaultEvents: string[];
        /**
         * `CfnBackupVault.NotificationObjectTypeProperty.SNSTopicArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-notificationobjecttype.html#cfn-backup-backupvault-notificationobjecttype-snstopicarn
         */
        readonly snsTopicArn: string;
    }
}
