/**
 * (experimental) Block device.
 *
 * @experimental
 */
export interface BlockDevice {
    /**
     * (experimental) The device name exposed to the EC2 instance.
     *
     * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/device_naming.html
     * @experimental
     * @example
     *
     * '/dev/sdh', 'xvdh'
     */
    readonly deviceName: string;
    /**
     * (experimental) Defines the block device volume, to be either an Amazon EBS volume or an ephemeral instance store volume.
     *
     * @experimental
     * @example
     *
     * BlockDeviceVolume.ebs(15), BlockDeviceVolume.ephemeral(0)
     */
    readonly volume: BlockDeviceVolume;
    /**
     * (deprecated) If false, the device mapping will be suppressed.
     *
     * If set to false for the root device, the instance might fail the Amazon EC2 health check.
     * Amazon EC2 Auto Scaling launches a replacement instance if the instance fails the health check.
     *
     * @default true - device mapping is left untouched
     * @deprecated use `BlockDeviceVolume.noDevice()` as the volume to supress a mapping.
     */
    readonly mappingEnabled?: boolean;
}
/**
 * (experimental) Base block device options for an EBS volume.
 *
 * @experimental
 */
export interface EbsDeviceOptionsBase {
    /**
     * (experimental) Indicates whether to delete the volume when the instance is terminated.
     *
     * @default - true for Amazon EC2 Auto Scaling, false otherwise (e.g. EBS)
     * @experimental
     */
    readonly deleteOnTermination?: boolean;
    /**
     * (experimental) The number of I/O operations per second (IOPS) to provision for the volume.
     *
     * Must only be set for {@link volumeType}: {@link EbsDeviceVolumeType.IO1}
     *
     * The maximum ratio of IOPS to volume size (in GiB) is 50:1, so for 5,000 provisioned IOPS,
     * you need at least 100 GiB storage on the volume.
     *
     * @default - none, required for {@link EbsDeviceVolumeType.IO1}
     * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html
     * @experimental
     */
    readonly iops?: number;
    /**
     * (experimental) The EBS volume type.
     *
     * @default {@link EbsDeviceVolumeType.GP2}
     * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html
     * @experimental
     */
    readonly volumeType?: EbsDeviceVolumeType;
}
/**
 * (experimental) Block device options for an EBS volume.
 *
 * @experimental
 */
export interface EbsDeviceOptions extends EbsDeviceOptionsBase {
    /**
     * (experimental) Specifies whether the EBS volume is encrypted.
     *
     * Encrypted EBS volumes can only be attached to instances that support Amazon EBS encryption
     *
     * @default false
     * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances
     * @experimental
     */
    readonly encrypted?: boolean;
}
/**
 * (experimental) Block device options for an EBS volume created from a snapshot.
 *
 * @experimental
 */
export interface EbsDeviceSnapshotOptions extends EbsDeviceOptionsBase {
    /**
     * (experimental) The volume size, in Gibibytes (GiB).
     *
     * If you specify volumeSize, it must be equal or greater than the size of the snapshot.
     *
     * @default - The snapshot size
     * @experimental
     */
    readonly volumeSize?: number;
}
/**
 * (experimental) Properties of an EBS block device.
 *
 * @experimental
 */
export interface EbsDeviceProps extends EbsDeviceSnapshotOptions {
    /**
     * (experimental) The snapshot ID of the volume to use.
     *
     * @default - No snapshot will be used
     * @experimental
     */
    readonly snapshotId?: string;
}
/**
 * (experimental) Describes a block device mapping for an EC2 instance or Auto Scaling group.
 *
 * @experimental
 */
export declare class BlockDeviceVolume {
    readonly ebsDevice?: EbsDeviceProps | undefined;
    readonly virtualName?: string | undefined;
    /**
     * @internal
     */
    static _NO_DEVICE: BlockDeviceVolume;
    /**
     * (experimental) Creates a new Elastic Block Storage device.
     *
     * @param volumeSize The volume size, in Gibibytes (GiB).
     * @param options additional device options.
     * @experimental
     */
    static ebs(volumeSize: number, options?: EbsDeviceOptions): BlockDeviceVolume;
    /**
     * (experimental) Creates a new Elastic Block Storage device from an existing snapshot.
     *
     * @param snapshotId The snapshot ID of the volume to use.
     * @param options additional device options.
     * @experimental
     */
    static ebsFromSnapshot(snapshotId: string, options?: EbsDeviceSnapshotOptions): BlockDeviceVolume;
    /**
     * (experimental) Creates a virtual, ephemeral device.
     *
     * The name will be in the form ephemeral{volumeIndex}.
     *
     * @param volumeIndex the volume index.
     * @experimental
     */
    static ephemeral(volumeIndex: number): BlockDeviceVolume;
    /**
     * (experimental) Supresses a volume mapping.
     *
     * @experimental
     */
    static noDevice(): BlockDeviceVolume;
    /**
     * @param ebsDevice EBS device info.
     * @param virtualName Virtual device name.
     * @experimental
     */
    protected constructor(ebsDevice?: EbsDeviceProps | undefined, virtualName?: string | undefined);
}
/**
 * (experimental) Supported EBS volume types for blockDevices.
 *
 * @experimental
 */
export declare enum EbsDeviceVolumeType {
    /**
     * (experimental) Magnetic.
     *
     * @experimental
     */
    STANDARD = "standard",
    /**
     * (experimental) Provisioned IOPS SSD - IO1.
     *
     * @experimental
     */
    IO1 = "io1",
    /**
     * (experimental) Provisioned IOPS SSD - IO2.
     *
     * @experimental
     */
    IO2 = "io2",
    /**
     * (experimental) General Purpose SSD - GP2.
     *
     * @experimental
     */
    GP2 = "gp2",
    /**
     * (experimental) General Purpose SSD - GP3.
     *
     * @experimental
     */
    GP3 = "gp3",
    /**
     * (experimental) Throughput Optimized HDD.
     *
     * @experimental
     */
    ST1 = "st1",
    /**
     * (experimental) Cold HDD.
     *
     * @experimental
     */
    SC1 = "sc1"
}
