import * as cloudwatch from "../../aws-cloudwatch";
import { Duration } from "../../core";
import { Construct } from 'constructs';
import { IAutoScalingGroup } from './auto-scaling-group';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) Base interface for target tracking props.
 *
 * Contains the attributes that are common to target tracking policies,
 * except the ones relating to the metric and to the scalable target.
 *
 * This interface is reused by more specific target tracking props objects.
 *
 * @experimental
 */
export interface BaseTargetTrackingProps {
    /**
     * (experimental) Indicates whether scale in by the target tracking policy is disabled.
     *
     * If the value is true, scale in is disabled and the target tracking policy
     * won't remove capacity from the autoscaling group. Otherwise, scale in is
     * enabled and the target tracking policy can remove capacity from the
     * group.
     *
     * @default false
     * @experimental
     */
    readonly disableScaleIn?: boolean;
    /**
     * (experimental) Period after a scaling completes before another scaling activity can start.
     *
     * @default - The default cooldown configured on the AutoScalingGroup.
     * @experimental
     */
    readonly cooldown?: Duration;
    /**
     * (experimental) Estimated time until a newly launched instance can send metrics to CloudWatch.
     *
     * @default - Same as the cooldown.
     * @experimental
     */
    readonly estimatedInstanceWarmup?: Duration;
}
/**
 * (experimental) Properties for a Target Tracking policy that include the metric but exclude the target.
 *
 * @experimental
 */
export interface BasicTargetTrackingScalingPolicyProps extends BaseTargetTrackingProps {
    /**
     * (experimental) The target value for the metric.
     *
     * @experimental
     */
    readonly targetValue: number;
    /**
     * (experimental) A predefined metric for application autoscaling.
     *
     * The metric must track utilization. Scaling out will happen if the metric is higher than
     * the target value, scaling in will happen in the metric is lower than the target value.
     *
     * Exactly one of customMetric or predefinedMetric must be specified.
     *
     * @default - No predefined metric.
     * @experimental
     */
    readonly predefinedMetric?: PredefinedMetric;
    /**
     * (experimental) A custom metric for application autoscaling.
     *
     * The metric must track utilization. Scaling out will happen if the metric is higher than
     * the target value, scaling in will happen in the metric is lower than the target value.
     *
     * Exactly one of customMetric or predefinedMetric must be specified.
     *
     * @default - No custom metric.
     * @experimental
     */
    readonly customMetric?: cloudwatch.IMetric;
    /**
     * (experimental) The resource label associated with the predefined metric.
     *
     * Should be supplied if the predefined metric is ALBRequestCountPerTarget, and the
     * format should be:
     *
     * app/<load-balancer-name>/<load-balancer-id>/targetgroup/<target-group-name>/<target-group-id>
     *
     * @default - No resource label.
     * @experimental
     */
    readonly resourceLabel?: string;
}
/**
 * (experimental) Properties for a concrete TargetTrackingPolicy.
 *
 * Adds the scalingTarget.
 *
 * @experimental
 */
export interface TargetTrackingScalingPolicyProps extends BasicTargetTrackingScalingPolicyProps {
    /**
     * @experimental
     */
    readonly autoScalingGroup: IAutoScalingGroup;
}
/**
 * @experimental
 */
export declare class TargetTrackingScalingPolicy extends CoreConstruct {
    /**
     * (experimental) ARN of the scaling policy.
     *
     * @experimental
     */
    readonly scalingPolicyArn: string;
    /**
     * The resource object
     */
    private resource;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: TargetTrackingScalingPolicyProps);
}
/**
 * (experimental) One of the predefined autoscaling metrics.
 *
 * @experimental
 */
export declare enum PredefinedMetric {
    /**
     * (experimental) Average CPU utilization of the Auto Scaling group.
     *
     * @experimental
     */
    ASG_AVERAGE_CPU_UTILIZATION = "ASGAverageCPUUtilization",
    /**
     * (experimental) Average number of bytes received on all network interfaces by the Auto Scaling group.
     *
     * @experimental
     */
    ASG_AVERAGE_NETWORK_IN = "ASGAverageNetworkIn",
    /**
     * (experimental) Average number of bytes sent out on all network interfaces by the Auto Scaling group.
     *
     * @experimental
     */
    ASG_AVERAGE_NETWORK_OUT = "ASGAverageNetworkOut",
    /**
     * (experimental) Number of requests completed per target in an Application Load Balancer target group.
     *
     * Specify the ALB to look at in the `resourceLabel` field.
     *
     * @experimental
     */
    ALB_REQUEST_COUNT_PER_TARGET = "ALBRequestCountPerTarget"
}
