import * as cloudwatch from "../../aws-cloudwatch";
import { Duration } from "../../core";
import { Construct } from 'constructs';
import { IAutoScalingGroup } from './auto-scaling-group';
import { AdjustmentType, MetricAggregationType, StepScalingAction } from './step-scaling-action';
import { Construct as CoreConstruct } from "../../core";
/**
 * @experimental
 */
export interface BasicStepScalingPolicyProps {
    /**
     * (experimental) Metric to scale on.
     *
     * @experimental
     */
    readonly metric: cloudwatch.IMetric;
    /**
     * (experimental) The intervals for scaling.
     *
     * Maps a range of metric values to a particular scaling behavior.
     *
     * @experimental
     */
    readonly scalingSteps: ScalingInterval[];
    /**
     * (experimental) How the adjustment numbers inside 'intervals' are interpreted.
     *
     * @default ChangeInCapacity
     * @experimental
     */
    readonly adjustmentType?: AdjustmentType;
    /**
     * (experimental) Grace period after scaling activity.
     *
     * @default Default cooldown period on your AutoScalingGroup
     * @experimental
     */
    readonly cooldown?: Duration;
    /**
     * (experimental) Estimated time until a newly launched instance can send metrics to CloudWatch.
     *
     * @default Same as the cooldown
     * @experimental
     */
    readonly estimatedInstanceWarmup?: Duration;
    /**
     * (experimental) Minimum absolute number to adjust capacity with as result of percentage scaling.
     *
     * Only when using AdjustmentType = PercentChangeInCapacity, this number controls
     * the minimum absolute effect size.
     *
     * @default No minimum scaling effect
     * @experimental
     */
    readonly minAdjustmentMagnitude?: number;
    /**
     * (experimental) How many evaluation periods of the metric to wait before triggering a scaling action.
     *
     * Raising this value can be used to smooth out the metric, at the expense
     * of slower response times.
     *
     * @default 1
     * @experimental
     */
    readonly evaluationPeriods?: number;
    /**
     * (experimental) Aggregation to apply to all data points over the evaluation periods.
     *
     * Only has meaning if `evaluationPeriods != 1`.
     *
     * @default - The statistic from the metric if applicable (MIN, MAX, AVERAGE), otherwise AVERAGE.
     * @experimental
     */
    readonly metricAggregationType?: MetricAggregationType;
}
/**
 * @experimental
 */
export interface StepScalingPolicyProps extends BasicStepScalingPolicyProps {
    /**
     * (experimental) The auto scaling group.
     *
     * @experimental
     */
    readonly autoScalingGroup: IAutoScalingGroup;
}
/**
 * (experimental) Define a acaling strategy which scales depending on absolute values of some metric.
 *
 * You can specify the scaling behavior for various values of the metric.
 *
 * Implemented using one or more CloudWatch alarms and Step Scaling Policies.
 *
 * @experimental
 */
export declare class StepScalingPolicy extends CoreConstruct {
    /**
     * @experimental
     */
    readonly lowerAlarm?: cloudwatch.Alarm;
    /**
     * @experimental
     */
    readonly lowerAction?: StepScalingAction;
    /**
     * @experimental
     */
    readonly upperAlarm?: cloudwatch.Alarm;
    /**
     * @experimental
     */
    readonly upperAction?: StepScalingAction;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: StepScalingPolicyProps);
}
/**
 * (experimental) A range of metric values in which to apply a certain scaling operation.
 *
 * @experimental
 */
export interface ScalingInterval {
    /**
     * (experimental) The lower bound of the interval.
     *
     * The scaling adjustment will be applied if the metric is higher than this value.
     *
     * @default Threshold automatically derived from neighbouring intervals
     * @experimental
     */
    readonly lower?: number;
    /**
     * (experimental) The upper bound of the interval.
     *
     * The scaling adjustment will be applied if the metric is lower than this value.
     *
     * @default Threshold automatically derived from neighbouring intervals
     * @experimental
     */
    readonly upper?: number;
    /**
     * (experimental) The capacity adjustment to apply in this interval.
     *
     * The number is interpreted differently based on AdjustmentType:
     *
     * - ChangeInCapacity: add the adjustment to the current capacity.
     *   The number can be positive or negative.
     * - PercentChangeInCapacity: add or remove the given percentage of the current
     *    capacity to itself. The number can be in the range [-100..100].
     * - ExactCapacity: set the capacity to this number. The number must
     *    be positive.
     *
     * @experimental
     */
    readonly change: number;
}
