import { Duration } from "../../core";
import { Construct } from 'constructs';
import { IAutoScalingGroup } from './auto-scaling-group';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) Properties for a scaling policy.
 *
 * @experimental
 */
export interface StepScalingActionProps {
    /**
     * (experimental) The auto scaling group.
     *
     * @experimental
     */
    readonly autoScalingGroup: IAutoScalingGroup;
    /**
     * (experimental) Period after a scaling completes before another scaling activity can start.
     *
     * @default The default cooldown configured on the AutoScalingGroup
     * @experimental
     */
    readonly cooldown?: Duration;
    /**
     * (experimental) Estimated time until a newly launched instance can send metrics to CloudWatch.
     *
     * @default Same as the cooldown
     * @experimental
     */
    readonly estimatedInstanceWarmup?: Duration;
    /**
     * (experimental) How the adjustment numbers are interpreted.
     *
     * @default ChangeInCapacity
     * @experimental
     */
    readonly adjustmentType?: AdjustmentType;
    /**
     * (experimental) Minimum absolute number to adjust capacity with as result of percentage scaling.
     *
     * Only when using AdjustmentType = PercentChangeInCapacity, this number controls
     * the minimum absolute effect size.
     *
     * @default No minimum scaling effect
     * @experimental
     */
    readonly minAdjustmentMagnitude?: number;
    /**
     * (experimental) The aggregation type for the CloudWatch metrics.
     *
     * @default Average
     * @experimental
     */
    readonly metricAggregationType?: MetricAggregationType;
}
/**
 * (experimental) Define a step scaling action.
 *
 * This kind of scaling policy adjusts the target capacity in configurable
 * steps. The size of the step is configurable based on the metric's distance
 * to its alarm threshold.
 *
 * This Action must be used as the target of a CloudWatch alarm to take effect.
 *
 * @experimental
 */
export declare class StepScalingAction extends CoreConstruct {
    /**
     * (experimental) ARN of the scaling policy.
     *
     * @experimental
     */
    readonly scalingPolicyArn: string;
    private readonly adjustments;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: StepScalingActionProps);
    /**
     * (experimental) Add an adjusment interval to the ScalingAction.
     *
     * @experimental
     */
    addAdjustment(adjustment: AdjustmentTier): void;
}
/**
 * (experimental) How adjustment numbers are interpreted.
 *
 * @experimental
 */
export declare enum AdjustmentType {
    /**
     * (experimental) Add the adjustment number to the current capacity.
     *
     * A positive number increases capacity, a negative number decreases capacity.
     *
     * @experimental
     */
    CHANGE_IN_CAPACITY = "ChangeInCapacity",
    /**
     * (experimental) Add this percentage of the current capacity to itself.
     *
     * The number must be between -100 and 100; a positive number increases
     * capacity and a negative number decreases it.
     *
     * @experimental
     */
    PERCENT_CHANGE_IN_CAPACITY = "PercentChangeInCapacity",
    /**
     * (experimental) Make the capacity equal to the exact number given.
     *
     * @experimental
     */
    EXACT_CAPACITY = "ExactCapacity"
}
/**
 * (experimental) How the scaling metric is going to be aggregated.
 *
 * @experimental
 */
export declare enum MetricAggregationType {
    /**
     * (experimental) Average.
     *
     * @experimental
     */
    AVERAGE = "Average",
    /**
     * (experimental) Minimum.
     *
     * @experimental
     */
    MINIMUM = "Minimum",
    /**
     * (experimental) Maximum.
     *
     * @experimental
     */
    MAXIMUM = "Maximum"
}
/**
 * (experimental) An adjustment.
 *
 * @experimental
 */
export interface AdjustmentTier {
    /**
     * (experimental) What number to adjust the capacity with.
     *
     * The number is interpeted as an added capacity, a new fixed capacity or an
     * added percentage depending on the AdjustmentType value of the
     * StepScalingPolicy.
     *
     * Can be positive or negative.
     *
     * @experimental
     */
    readonly adjustment: number;
    /**
     * (experimental) Lower bound where this scaling tier applies.
     *
     * The scaling tier applies if the difference between the metric
     * value and its alarm threshold is higher than this value.
     *
     * @default -Infinity if this is the first tier, otherwise the upperBound of the previous tier
     * @experimental
     */
    readonly lowerBound?: number;
    /**
     * (experimental) Upper bound where this scaling tier applies.
     *
     * The scaling tier applies if the difference between the metric
     * value and its alarm threshold is lower than this value.
     *
     * @default +Infinity
     * @experimental
     */
    readonly upperBound?: number;
}
