import * as iam from "../../aws-iam";
import { Duration, IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { IAutoScalingGroup } from './auto-scaling-group';
import { ILifecycleHookTarget } from './lifecycle-hook-target';
/**
 * (experimental) Basic properties for a lifecycle hook.
 *
 * @experimental
 */
export interface BasicLifecycleHookProps {
    /**
     * (experimental) Name of the lifecycle hook.
     *
     * @default - Automatically generated name.
     * @experimental
     */
    readonly lifecycleHookName?: string;
    /**
     * (experimental) The action the Auto Scaling group takes when the lifecycle hook timeout elapses or if an unexpected failure occurs.
     *
     * @default Continue
     * @experimental
     */
    readonly defaultResult?: DefaultResult;
    /**
     * (experimental) Maximum time between calls to RecordLifecycleActionHeartbeat for the hook.
     *
     * If the lifecycle hook times out, perform the action in DefaultResult.
     *
     * @default - No heartbeat timeout.
     * @experimental
     */
    readonly heartbeatTimeout?: Duration;
    /**
     * (experimental) The state of the Amazon EC2 instance to which you want to attach the lifecycle hook.
     *
     * @experimental
     */
    readonly lifecycleTransition: LifecycleTransition;
    /**
     * (experimental) Additional data to pass to the lifecycle hook target.
     *
     * @default - No metadata.
     * @experimental
     */
    readonly notificationMetadata?: string;
    /**
     * (experimental) The target of the lifecycle hook.
     *
     * @experimental
     */
    readonly notificationTarget: ILifecycleHookTarget;
    /**
     * (experimental) The role that allows publishing to the notification target.
     *
     * @default - A role is automatically created.
     * @experimental
     */
    readonly role?: iam.IRole;
}
/**
 * (experimental) Properties for a Lifecycle hook.
 *
 * @experimental
 */
export interface LifecycleHookProps extends BasicLifecycleHookProps {
    /**
     * (experimental) The AutoScalingGroup to add the lifecycle hook to.
     *
     * @experimental
     */
    readonly autoScalingGroup: IAutoScalingGroup;
}
/**
 * (experimental) A basic lifecycle hook object.
 *
 * @experimental
 */
export interface ILifecycleHook extends IResource {
    /**
     * (experimental) The role for the lifecycle hook to execute.
     *
     * @experimental
     */
    readonly role: iam.IRole;
}
/**
 * (experimental) Define a life cycle hook.
 *
 * @experimental
 */
export declare class LifecycleHook extends Resource implements ILifecycleHook {
    /**
     * (experimental) The role that allows the ASG to publish to the notification target.
     *
     * @experimental
     */
    readonly role: iam.IRole;
    /**
     * (experimental) The name of this lifecycle hook.
     *
     * @experimental
     * @attribute true
     */
    readonly lifecycleHookName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: LifecycleHookProps);
}
/**
 * @experimental
 */
export declare enum DefaultResult {
    /**
     * @experimental
     */
    CONTINUE = "CONTINUE",
    /**
     * @experimental
     */
    ABANDON = "ABANDON"
}
/**
 * (experimental) What instance transition to attach the hook to.
 *
 * @experimental
 */
export declare enum LifecycleTransition {
    /**
     * (experimental) Execute the hook when an instance is about to be added.
     *
     * @experimental
     */
    INSTANCE_LAUNCHING = "autoscaling:EC2_INSTANCE_LAUNCHING",
    /**
     * (experimental) Execute the hook when an instance is about to be terminated.
     *
     * @experimental
     */
    INSTANCE_TERMINATING = "autoscaling:EC2_INSTANCE_TERMINATING"
}
