import * as cloudwatch from "../../aws-cloudwatch";
import * as ec2 from "../../aws-ec2";
import * as elb from "../../aws-elasticloadbalancing";
import * as elbv2 from "../../aws-elasticloadbalancingv2";
import * as iam from "../../aws-iam";
import * as sns from "../../aws-sns";
import { CfnCreationPolicy, CfnUpdatePolicy, Duration, IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { BasicLifecycleHookProps, LifecycleHook } from './lifecycle-hook';
import { BasicScheduledActionProps, ScheduledAction } from './scheduled-action';
import { BasicStepScalingPolicyProps, StepScalingPolicy } from './step-scaling-policy';
import { BaseTargetTrackingProps, TargetTrackingScalingPolicy } from './target-tracking-scaling-policy';
import { BlockDevice } from './volume';
/**
 * (experimental) The monitoring mode for instances launched in an autoscaling group.
 *
 * @experimental
 */
export declare enum Monitoring {
    /**
     * (experimental) Generates metrics every 5 minutes.
     *
     * @experimental
     */
    BASIC = 0,
    /**
     * (experimental) Generates metrics every minute.
     *
     * @experimental
     */
    DETAILED = 1
}
/**
 * (experimental) Basic properties of an AutoScalingGroup, except the exact machines to run and where they should run.
 *
 * Constructs that want to create AutoScalingGroups can inherit
 * this interface and specialize the essential parts in various ways.
 *
 * @experimental
 */
export interface CommonAutoScalingGroupProps {
    /**
     * (experimental) Minimum number of instances in the fleet.
     *
     * @default 1
     * @experimental
     */
    readonly minCapacity?: number;
    /**
     * (experimental) Maximum number of instances in the fleet.
     *
     * @default desiredCapacity
     * @experimental
     */
    readonly maxCapacity?: number;
    /**
     * (experimental) Initial amount of instances in the fleet.
     *
     * If this is set to a number, every deployment will reset the amount of
     * instances to this number. It is recommended to leave this value blank.
     *
     * @default minCapacity, and leave unchanged during deployment
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-desiredcapacity
     * @experimental
     */
    readonly desiredCapacity?: number;
    /**
     * (experimental) Name of SSH keypair to grant access to instances.
     *
     * @default - No SSH access will be possible.
     * @experimental
     */
    readonly keyName?: string;
    /**
     * (experimental) Where to place instances within the VPC.
     *
     * @default - All Private subnets.
     * @experimental
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * (deprecated) SNS topic to send notifications about fleet changes.
     *
     * @default - No fleet change notifications will be sent.
     * @deprecated use `notifications`
     */
    readonly notificationsTopic?: sns.ITopic;
    /**
     * (experimental) Configure autoscaling group to send notifications about fleet changes to an SNS topic(s).
     *
     * @default - No fleet change notifications will be sent.
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-notificationconfigurations
     * @experimental
     */
    readonly notifications?: NotificationConfiguration[];
    /**
     * (experimental) Whether the instances can initiate connections to anywhere by default.
     *
     * @default true
     * @experimental
     */
    readonly allowAllOutbound?: boolean;
    /**
     * (deprecated) What to do when an AutoScalingGroup's instance configuration is changed.
     *
     * This is applied when any of the settings on the ASG are changed that
     * affect how the instances should be created (VPC, instance type, startup
     * scripts, etc.). It indicates how the existing instances should be
     * replaced with new instances matching the new config. By default, nothing
     * is done and only new instances are launched with the new config.
     *
     * @default UpdateType.None
     * @deprecated Use `updatePolicy` instead
     */
    readonly updateType?: UpdateType;
    /**
     * (deprecated) Configuration for rolling updates.
     *
     * Only used if updateType == UpdateType.RollingUpdate.
     *
     * @default - RollingUpdateConfiguration with defaults.
     * @deprecated Use `updatePolicy` instead
     */
    readonly rollingUpdateConfiguration?: RollingUpdateConfiguration;
    /**
     * (deprecated) Configuration for replacing updates.
     *
     * Only used if updateType == UpdateType.ReplacingUpdate. Specifies how
     * many instances must signal success for the update to succeed.
     *
     * @default minSuccessfulInstancesPercent
     * @deprecated Use `signals` instead
     */
    readonly replacingUpdateMinSuccessfulInstancesPercent?: number;
    /**
     * (experimental) If the ASG has scheduled actions, don't reset unchanged group sizes.
     *
     * Only used if the ASG has scheduled actions (which may scale your ASG up
     * or down regardless of cdk deployments). If true, the size of the group
     * will only be reset if it has been changed in the CDK app. If false, the
     * sizes will always be changed back to what they were in the CDK app
     * on deployment.
     *
     * @default true
     * @experimental
     */
    readonly ignoreUnmodifiedSizeProperties?: boolean;
    /**
     * (deprecated) How many ResourceSignal calls CloudFormation expects before the resource is considered created.
     *
     * @default 1 if resourceSignalTimeout is set, 0 otherwise
     * @deprecated Use `signals` instead.
     */
    readonly resourceSignalCount?: number;
    /**
     * (deprecated) The length of time to wait for the resourceSignalCount.
     *
     * The maximum value is 43200 (12 hours).
     *
     * @default Duration.minutes(5) if resourceSignalCount is set, N/A otherwise
     * @deprecated Use `signals` instead.
     */
    readonly resourceSignalTimeout?: Duration;
    /**
     * (experimental) Default scaling cooldown for this AutoScalingGroup.
     *
     * @default Duration.minutes(5)
     * @experimental
     */
    readonly cooldown?: Duration;
    /**
     * (experimental) Whether instances in the Auto Scaling Group should have public IP addresses associated with them.
     *
     * @default - Use subnet setting.
     * @experimental
     */
    readonly associatePublicIpAddress?: boolean;
    /**
     * (experimental) The maximum hourly price (in USD) to be paid for any Spot Instance launched to fulfill the request.
     *
     * Spot Instances are
     * launched when the price you specify exceeds the current Spot market price.
     *
     * @default none
     * @experimental
     */
    readonly spotPrice?: string;
    /**
     * (experimental) Configuration for health checks.
     *
     * @default - HealthCheck.ec2 with no grace period
     * @experimental
     */
    readonly healthCheck?: HealthCheck;
    /**
     * (experimental) Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
     *
     * Each instance that is launched has an associated root device volume,
     * either an Amazon EBS volume or an instance store volume.
     * You can use block device mappings to specify additional EBS volumes or
     * instance store volumes to attach to an instance when it is launched.
     *
     * @default - Uses the block device mapping of the AMI
     * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html
     * @experimental
     */
    readonly blockDevices?: BlockDevice[];
    /**
     * (experimental) The maximum amount of time that an instance can be in service.
     *
     * The maximum duration applies
     * to all current and future instances in the group. As an instance approaches its maximum duration,
     * it is terminated and replaced, and cannot be used again.
     *
     * You must specify a value of at least 604,800 seconds (7 days). To clear a previously set value,
     * leave this property undefined.
     *
     * @default none
     * @see https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html
     * @experimental
     */
    readonly maxInstanceLifetime?: Duration;
    /**
     * (experimental) Controls whether instances in this group are launched with detailed or basic monitoring.
     *
     * When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account
     * is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes.
     *
     * @default - Monitoring.DETAILED
     * @see https://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-monitoring.html#enable-as-instance-metrics
     * @experimental
     */
    readonly instanceMonitoring?: Monitoring;
    /**
     * (experimental) Enable monitoring for group metrics, these metrics describe the group rather than any of its instances.
     *
     * To report all group metrics use `GroupMetrics.all()`
     * Group metrics are reported in a granularity of 1 minute at no additional charge.
     *
     * @default - no group metrics will be reported
     * @experimental
     */
    readonly groupMetrics?: GroupMetrics[];
    /**
     * (experimental) Configure waiting for signals during deployment.
     *
     * Use this to pause the CloudFormation deployment to wait for the instances
     * in the AutoScalingGroup to report successful startup during
     * creation and updates. The UserData script needs to invoke `cfn-signal`
     * with a success or failure code after it is done setting up the instance.
     *
     * Without waiting for signals, the CloudFormation deployment will proceed as
     * soon as the AutoScalingGroup has been created or updated but before the
     * instances in the group have been started.
     *
     * For example, to have instances wait for an Elastic Load Balancing health check before
     * they signal success, add a health-check verification by using the
     * cfn-init helper script. For an example, see the verify_instance_health
     * command in the Auto Scaling rolling updates sample template:
     *
     * https://github.com/awslabs/aws-cloudformation-templates/blob/master/aws/services/AutoScaling/AutoScalingRollingUpdates.yaml
     *
     * @default - Do not wait for signals
     * @experimental
     */
    readonly signals?: Signals;
    /**
     * (experimental) What to do when an AutoScalingGroup's instance configuration is changed.
     *
     * This is applied when any of the settings on the ASG are changed that
     * affect how the instances should be created (VPC, instance type, startup
     * scripts, etc.). It indicates how the existing instances should be
     * replaced with new instances matching the new config. By default, nothing
     * is done and only new instances are launched with the new config.
     *
     * @default - `UpdatePolicy.rollingUpdate()` if using `init`, `UpdatePolicy.none()` otherwise
     * @experimental
     */
    readonly updatePolicy?: UpdatePolicy;
    /**
     * (experimental) Whether newly-launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in.
     *
     * By default, Auto Scaling can terminate an instance at any time after launch
     * when scaling in an Auto Scaling Group, subject to the group's termination
     * policy. However, you may wish to protect newly-launched instances from
     * being scaled in if they are going to run critical applications that should
     * not be prematurely terminated.
     *
     * This flag must be enabled if the Auto Scaling Group will be associated with
     * an ECS Capacity Provider with managed termination protection.
     *
     * @default false
     * @experimental
     */
    readonly newInstancesProtectedFromScaleIn?: boolean;
    /**
     * (experimental) The name of the Auto Scaling group.
     *
     * This name must be unique per Region per account.
     *
     * @default - Auto generated by CloudFormation
     * @experimental
     */
    readonly autoScalingGroupName?: string;
}
/**
 * (experimental) Properties of a Fleet.
 *
 * @experimental
 */
export interface AutoScalingGroupProps extends CommonAutoScalingGroupProps {
    /**
     * (experimental) VPC to launch these instances in.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) Type of instance to launch.
     *
     * @experimental
     */
    readonly instanceType: ec2.InstanceType;
    /**
     * (experimental) AMI to launch.
     *
     * @experimental
     */
    readonly machineImage: ec2.IMachineImage;
    /**
     * (experimental) Security group to launch the instances in.
     *
     * @default - A SecurityGroup will be created if none is specified.
     * @experimental
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * (experimental) Specific UserData to use.
     *
     * The UserData may still be mutated after creation.
     *
     * @default - A UserData object appropriate for the MachineImage's
     * Operating System is created.
     * @experimental
     */
    readonly userData?: ec2.UserData;
    /**
     * (experimental) An IAM role to associate with the instance profile assigned to this Auto Scaling Group.
     *
     * The role must be assumable by the service principal `ec2.amazonaws.com`:
     *
     * @default A role will automatically be created, it can be accessed via the `role` property
     * @experimental
     * @example
     *
     *    const role = new iam.Role(this, 'MyRole', {
     *      assumedBy: new iam.ServicePrincipal('ec2.amazonaws.com')
     *    });
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) Apply the given CloudFormation Init configuration to the instances in the AutoScalingGroup at startup.
     *
     * If you specify `init`, you must also specify `signals` to configure
     * the number of instances to wait for and the timeout for waiting for the
     * init process.
     *
     * @default - no CloudFormation init
     * @experimental
     */
    readonly init?: ec2.CloudFormationInit;
    /**
     * (experimental) Use the given options for applying CloudFormation Init.
     *
     * Describes the configsets to use and the timeout to wait
     *
     * @default - default options
     * @experimental
     */
    readonly initOptions?: ApplyCloudFormationInitOptions;
}
/**
 * (experimental) Configure whether the AutoScalingGroup waits for signals.
 *
 * If you do configure waiting for signals, you should make sure the instances
 * invoke `cfn-signal` somewhere in their UserData to signal that they have
 * started up (either successfully or unsuccessfully).
 *
 * Signals are used both during intial creation and subsequent updates.
 *
 * @experimental
 */
export declare abstract class Signals {
    /**
     * (experimental) Wait for the desiredCapacity of the AutoScalingGroup amount of signals to have been received.
     *
     * If no desiredCapacity has been configured, wait for minCapacity signals intead.
     *
     * This number is used during initial creation and during replacing updates.
     * During rolling updates, all updated instances must send a signal.
     *
     * @experimental
     */
    static waitForAll(options?: SignalsOptions): Signals;
    /**
     * (experimental) Wait for the minCapacity of the AutoScalingGroup amount of signals to have been received.
     *
     * This number is used during initial creation and during replacing updates.
     * During rolling updates, all updated instances must send a signal.
     *
     * @experimental
     */
    static waitForMinCapacity(options?: SignalsOptions): Signals;
    /**
     * (experimental) Wait for a specific amount of signals to have been received.
     *
     * You should send one signal per instance, so this represents the number of
     * instances to wait for.
     *
     * This number is used during initial creation and during replacing updates.
     * During rolling updates, all updated instances must send a signal.
     *
     * @experimental
     */
    static waitForCount(count: number, options?: SignalsOptions): Signals;
    /**
     * (experimental) Render the ASG's CreationPolicy.
     *
     * @experimental
     */
    abstract renderCreationPolicy(renderOptions: RenderSignalsOptions): CfnCreationPolicy;
    /**
     * (experimental) Helper to render the actual creation policy, as the logic between them is quite similar.
     *
     * @experimental
     */
    protected doRender(options: SignalsOptions, count?: number): CfnCreationPolicy;
}
/**
 * (experimental) Input for Signals.renderCreationPolicy.
 *
 * @experimental
 */
export interface RenderSignalsOptions {
    /**
     * (experimental) The desiredCapacity of the ASG.
     *
     * @default - desired capacity not configured
     * @experimental
     */
    readonly desiredCapacity?: number;
    /**
     * (experimental) The minSize of the ASG.
     *
     * @default - minCapacity not configured
     * @experimental
     */
    readonly minCapacity?: number;
}
/**
 * (experimental) Customization options for Signal handling.
 *
 * @experimental
 */
export interface SignalsOptions {
    /**
     * (experimental) The percentage of signals that need to be successful.
     *
     * If this number is less than 100, a percentage of signals may be failure
     * signals while still succeeding the creation or update in CloudFormation.
     *
     * @default 100
     * @experimental
     */
    readonly minSuccessPercentage?: number;
    /**
     * (experimental) How long to wait for the signals to be sent.
     *
     * This should reflect how long it takes your instances to start up
     * (including instance start time and instance initialization time).
     *
     * @default Duration.minutes(5)
     * @experimental
     */
    readonly timeout?: Duration;
}
/**
 * (experimental) How existing instances should be updated.
 *
 * @experimental
 */
export declare abstract class UpdatePolicy {
    /**
     * (experimental) Create a new AutoScalingGroup and switch over to it.
     *
     * @experimental
     */
    static replacingUpdate(): UpdatePolicy;
    /**
     * (experimental) Replace the instances in the AutoScalingGroup one by one, or in batches.
     *
     * @experimental
     */
    static rollingUpdate(options?: RollingUpdateOptions): UpdatePolicy;
    /**
     * Render the ASG's CreationPolicy
     * @internal
     */
    abstract _renderUpdatePolicy(renderOptions: RenderUpdateOptions): CfnUpdatePolicy;
}
/**
 * Options for rendering UpdatePolicy
 */
interface RenderUpdateOptions {
    /**
     * The Creation Policy already created
     *
     * @default - no CreationPolicy configured
     */
    readonly creationPolicy?: CfnCreationPolicy;
}
/**
 * (experimental) Options for customizing the rolling update.
 *
 * @experimental
 */
export interface RollingUpdateOptions {
    /**
     * (experimental) The maximum number of instances that AWS CloudFormation updates at once.
     *
     * This number affects the speed of the replacement.
     *
     * @default 1
     * @experimental
     */
    readonly maxBatchSize?: number;
    /**
     * (experimental) The minimum number of instances that must be in service before more instances are replaced.
     *
     * This number affects the speed of the replacement.
     *
     * @default 0
     * @experimental
     */
    readonly minInstancesInService?: number;
    /**
     * (experimental) Specifies the Auto Scaling processes to suspend during a stack update.
     *
     * Suspending processes prevents Auto Scaling from interfering with a stack
     * update.
     *
     * @default HealthCheck, ReplaceUnhealthy, AZRebalance, AlarmNotification, ScheduledActions.
     * @experimental
     */
    readonly suspendProcesses?: ScalingProcess[];
    /**
     * (experimental) Specifies whether the Auto Scaling group waits on signals from new instances during an update.
     *
     * @default true if you configured `signals` on the AutoScalingGroup, false otherwise
     * @experimental
     */
    readonly waitOnResourceSignals?: boolean;
    /**
     * (experimental) The pause time after making a change to a batch of instances.
     *
     * @default - The `timeout` configured for `signals` on the AutoScalingGroup
     * @experimental
     */
    readonly pauseTime?: Duration;
    /**
     * (experimental) The percentage of instances that must signal success for the update to succeed.
     *
     * @default - The `minSuccessPercentage` configured for `signals` on the AutoScalingGroup
     * @experimental
     */
    readonly minSuccessPercentage?: number;
}
/**
 * (experimental) A set of group metrics.
 *
 * @experimental
 */
export declare class GroupMetrics {
    /**
     * (experimental) Report all group metrics.
     *
     * @experimental
     */
    static all(): GroupMetrics;
    /**
     * @internal
     */
    _metrics: Set<GroupMetric>;
    /**
     * @experimental
     */
    constructor(...metrics: GroupMetric[]);
}
/**
 * (experimental) Group metrics that an Auto Scaling group sends to Amazon CloudWatch.
 *
 * @experimental
 */
export declare class GroupMetric {
    /**
     * (experimental) The minimum size of the Auto Scaling group.
     *
     * @experimental
     */
    static readonly MIN_SIZE: GroupMetric;
    /**
     * (experimental) The maximum size of the Auto Scaling group.
     *
     * @experimental
     */
    static readonly MAX_SIZE: GroupMetric;
    /**
     * (experimental) The number of instances that the Auto Scaling group attempts to maintain.
     *
     * @experimental
     */
    static readonly DESIRED_CAPACITY: GroupMetric;
    /**
     * (experimental) The number of instances that are running as part of the Auto Scaling group This metric does not include instances that are pending or terminating.
     *
     * @experimental
     */
    static readonly IN_SERVICE_INSTANCES: GroupMetric;
    /**
     * (experimental) The number of instances that are pending A pending instance is not yet in service, this metric does not include instances that are in service or terminating.
     *
     * @experimental
     */
    static readonly PENDING_INSTANCES: GroupMetric;
    /**
     * (experimental) The number of instances that are in a Standby state Instances in this state are still running but are not actively in service.
     *
     * @experimental
     */
    static readonly STANDBY_INSTANCES: GroupMetric;
    /**
     * (experimental) The number of instances that are in the process of terminating This metric does not include instances that are in service or pending.
     *
     * @experimental
     */
    static readonly TERMINATING_INSTANCES: GroupMetric;
    /**
     * (experimental) The total number of instances in the Auto Scaling group This metric identifies the number of instances that are in service, pending, and terminating.
     *
     * @experimental
     */
    static readonly TOTAL_INSTANCES: GroupMetric;
    /**
     * (experimental) The name of the group metric.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * @experimental
     */
    constructor(name: string);
}
declare abstract class AutoScalingGroupBase extends Resource implements IAutoScalingGroup {
    abstract autoScalingGroupName: string;
    abstract autoScalingGroupArn: string;
    abstract readonly osType: ec2.OperatingSystemType;
    /**
     * @experimental
     */
    protected albTargetGroup?: elbv2.ApplicationTargetGroup;
    readonly grantPrincipal: iam.IPrincipal;
    /**
     * (experimental) Send a message to either an SQS queue or SNS topic when instances launch or terminate.
     *
     * @experimental
     */
    addLifecycleHook(id: string, props: BasicLifecycleHookProps): LifecycleHook;
    /**
     * (experimental) Scale out or in based on time.
     *
     * @experimental
     */
    scaleOnSchedule(id: string, props: BasicScheduledActionProps): ScheduledAction;
    /**
     * (experimental) Scale out or in to achieve a target CPU utilization.
     *
     * @experimental
     */
    scaleOnCpuUtilization(id: string, props: CpuUtilizationScalingProps): TargetTrackingScalingPolicy;
    /**
     * (experimental) Scale out or in to achieve a target network ingress rate.
     *
     * @experimental
     */
    scaleOnIncomingBytes(id: string, props: NetworkUtilizationScalingProps): TargetTrackingScalingPolicy;
    /**
     * (experimental) Scale out or in to achieve a target network egress rate.
     *
     * @experimental
     */
    scaleOnOutgoingBytes(id: string, props: NetworkUtilizationScalingProps): TargetTrackingScalingPolicy;
    /**
     * (experimental) Scale out or in to achieve a target request handling rate.
     *
     * The AutoScalingGroup must have been attached to an Application Load Balancer
     * in order to be able to call this.
     *
     * @experimental
     */
    scaleOnRequestCount(id: string, props: RequestCountScalingProps): TargetTrackingScalingPolicy;
    /**
     * (experimental) Scale out or in in order to keep a metric around a target value.
     *
     * @experimental
     */
    scaleToTrackMetric(id: string, props: MetricTargetTrackingProps): TargetTrackingScalingPolicy;
    /**
     * (experimental) Scale out or in, in response to a metric.
     *
     * @experimental
     */
    scaleOnMetric(id: string, props: BasicStepScalingPolicyProps): StepScalingPolicy;
    addUserData(..._commands: string[]): void;
}
/**
 * (experimental) A Fleet represents a managed set of EC2 instances.
 *
 * The Fleet models a number of AutoScalingGroups, a launch configuration, a
 * security group and an instance role.
 *
 * It allows adding arbitrary commands to the startup scripts of the instances
 * in the fleet.
 *
 * The ASG spans the availability zones specified by vpcSubnets, falling back to
 * the Vpc default strategy if not specified.
 *
 * @experimental
 */
export declare class AutoScalingGroup extends AutoScalingGroupBase implements elb.ILoadBalancerTarget, ec2.IConnectable, elbv2.IApplicationLoadBalancerTarget, elbv2.INetworkLoadBalancerTarget {
    /**
     * @experimental
     */
    static fromAutoScalingGroupName(scope: Construct, id: string, autoScalingGroupName: string): IAutoScalingGroup;
    /**
     * (experimental) The type of OS instances of this fleet are running.
     *
     * @experimental
     */
    readonly osType: ec2.OperatingSystemType;
    /**
     * (experimental) Allows specify security group connections for instances of this fleet.
     *
     * @experimental
     */
    readonly connections: ec2.Connections;
    /**
     * (experimental) The IAM role assumed by instances of this fleet.
     *
     * @experimental
     */
    readonly role: iam.IRole;
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    readonly grantPrincipal: iam.IPrincipal;
    /**
     * (experimental) Name of the AutoScalingGroup.
     *
     * @experimental
     */
    readonly autoScalingGroupName: string;
    /**
     * (experimental) Arn of the AutoScalingGroup.
     *
     * @experimental
     */
    readonly autoScalingGroupArn: string;
    /**
     * (experimental) UserData for the instances.
     *
     * @experimental
     */
    readonly userData: ec2.UserData;
    /**
     * (experimental) The maximum spot price configured for the autoscaling group.
     *
     * `undefined`
     * indicates that this group uses on-demand capacity.
     *
     * @experimental
     */
    readonly spotPrice?: string;
    /**
     * (experimental) The maximum amount of time that an instance can be in service.
     *
     * @experimental
     */
    readonly maxInstanceLifetime?: Duration;
    private readonly autoScalingGroup;
    private readonly securityGroup;
    private readonly securityGroups;
    private readonly loadBalancerNames;
    private readonly targetGroupArns;
    private readonly groupMetrics;
    private readonly notifications;
    /**
     * @experimental
     */
    protected newInstancesProtectedFromScaleIn?: boolean;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: AutoScalingGroupProps);
    /**
     * (experimental) Add the security group to all instances via the launch configuration security groups array.
     *
     * @param securityGroup : The security group to add.
     * @experimental
     */
    addSecurityGroup(securityGroup: ec2.ISecurityGroup): void;
    /**
     * (experimental) Attach to a classic load balancer.
     *
     * @experimental
     */
    attachToClassicLB(loadBalancer: elb.LoadBalancer): void;
    /**
     * (experimental) Attach to ELBv2 Application Target Group.
     *
     * @experimental
     */
    attachToApplicationTargetGroup(targetGroup: elbv2.IApplicationTargetGroup): elbv2.LoadBalancerTargetProps;
    /**
     * (experimental) Attach to ELBv2 Application Target Group.
     *
     * @experimental
     */
    attachToNetworkTargetGroup(targetGroup: elbv2.INetworkTargetGroup): elbv2.LoadBalancerTargetProps;
    /**
     * (experimental) Add command to the startup script of fleet instances.
     *
     * The command must be in the scripting language supported by the fleet's OS (i.e. Linux/Windows).
     * Does nothing for imported ASGs.
     *
     * @experimental
     */
    addUserData(...commands: string[]): void;
    /**
     * (experimental) Adds a statement to the IAM role assumed by instances of this fleet.
     *
     * @experimental
     */
    addToRolePolicy(statement: iam.PolicyStatement): void;
    /**
     * (experimental) Use a CloudFormation Init configuration at instance startup.
     *
     * This does the following:
     *
     * - Attaches the CloudFormation Init metadata to the AutoScalingGroup resource.
     * - Add commands to the UserData to run `cfn-init` and `cfn-signal`.
     * - Update the instance's CreationPolicy to wait for `cfn-init` to finish
     *    before reporting success.
     *
     * @experimental
     */
    applyCloudFormationInit(init: ec2.CloudFormationInit, options?: ApplyCloudFormationInitOptions): void;
    /**
     * (experimental) Ensures newly-launched instances are protected from scale-in.
     *
     * @experimental
     */
    protectNewInstancesFromScaleIn(): void;
    /**
     * (experimental) Returns `true` if newly-launched instances are protected from scale-in.
     *
     * @experimental
     */
    areNewInstancesProtectedFromScaleIn(): boolean;
    /**
     * Apply CloudFormation update policies for the AutoScalingGroup
     */
    private applyUpdatePolicies;
    /**
     * Use 'signals' and 'updatePolicy' to determine the creation and update policies
     */
    private applyNewSignalUpdatePolicies;
    private applyLegacySignalUpdatePolicies;
    private renderNotificationConfiguration;
    private renderMetricsCollection;
}
/**
 * (deprecated) The type of update to perform on instances in this AutoScalingGroup.
 *
 * @deprecated Use UpdatePolicy instead
 */
export declare enum UpdateType {
    /**
     * (deprecated) Don't do anything.
     *
     * @deprecated
     */
    NONE = "None",
    /**
     * (deprecated) Replace the entire AutoScalingGroup.
     *
     * Builds a new AutoScalingGroup first, then delete the old one.
     *
     * @deprecated
     */
    REPLACING_UPDATE = "Replace",
    /**
     * (deprecated) Replace the instances in the AutoScalingGroup.
     *
     * @deprecated
     */
    ROLLING_UPDATE = "RollingUpdate"
}
/**
 * (experimental) AutoScalingGroup fleet change notifications configurations.
 *
 * You can configure AutoScaling to send an SNS notification whenever your Auto Scaling group scales.
 *
 * @experimental
 */
export interface NotificationConfiguration {
    /**
     * (experimental) SNS topic to send notifications about fleet scaling events.
     *
     * @experimental
     */
    readonly topic: sns.ITopic;
    /**
     * (experimental) Which fleet scaling events triggers a notification.
     *
     * @default ScalingEvents.ALL
     * @experimental
     */
    readonly scalingEvents?: ScalingEvents;
}
/**
 * (experimental) Fleet scaling events.
 *
 * @experimental
 */
export declare enum ScalingEvent {
    /**
     * (experimental) Notify when an instance was launched.
     *
     * @experimental
     */
    INSTANCE_LAUNCH = "autoscaling:EC2_INSTANCE_LAUNCH",
    /**
     * (experimental) Notify when an instance was terminated.
     *
     * @experimental
     */
    INSTANCE_TERMINATE = "autoscaling:EC2_INSTANCE_TERMINATE",
    /**
     * (experimental) Notify when an instance failed to terminate.
     *
     * @experimental
     */
    INSTANCE_TERMINATE_ERROR = "autoscaling:EC2_INSTANCE_TERMINATE_ERROR",
    /**
     * (experimental) Notify when an instance failed to launch.
     *
     * @experimental
     */
    INSTANCE_LAUNCH_ERROR = "autoscaling:EC2_INSTANCE_LAUNCH_ERROR",
    /**
     * (experimental) Send a test notification to the topic.
     *
     * @experimental
     */
    TEST_NOTIFICATION = "autoscaling:TEST_NOTIFICATION"
}
/**
 * (deprecated) Additional settings when a rolling update is selected.
 *
 * @deprecated use `UpdatePolicy.rollingUpdate()`
 */
export interface RollingUpdateConfiguration {
    /**
     * (deprecated) The maximum number of instances that AWS CloudFormation updates at once.
     *
     * @default 1
     * @deprecated
     */
    readonly maxBatchSize?: number;
    /**
     * (deprecated) The minimum number of instances that must be in service before more instances are replaced.
     *
     * This number affects the speed of the replacement.
     *
     * @default 0
     * @deprecated
     */
    readonly minInstancesInService?: number;
    /**
     * (deprecated) The percentage of instances that must signal success for an update to succeed.
     *
     * If an instance doesn't send a signal within the time specified in the
     * pauseTime property, AWS CloudFormation assumes that the instance wasn't
     * updated.
     *
     * This number affects the success of the replacement.
     *
     * If you specify this property, you must also enable the
     * waitOnResourceSignals and pauseTime properties.
     *
     * @default 100
     * @deprecated
     */
    readonly minSuccessfulInstancesPercent?: number;
    /**
     * (deprecated) The pause time after making a change to a batch of instances.
     *
     * This is intended to give those instances time to start software applications.
     *
     * Specify PauseTime in the ISO8601 duration format (in the format
     * PT#H#M#S, where each # is the number of hours, minutes, and seconds,
     * respectively). The maximum PauseTime is one hour (PT1H).
     *
     * @default Duration.minutes(5) if the waitOnResourceSignals property is true, otherwise 0
     * @deprecated
     */
    readonly pauseTime?: Duration;
    /**
     * (deprecated) Specifies whether the Auto Scaling group waits on signals from new instances during an update.
     *
     * AWS CloudFormation must receive a signal from each new instance within
     * the specified PauseTime before continuing the update.
     *
     * To have instances wait for an Elastic Load Balancing health check before
     * they signal success, add a health-check verification by using the
     * cfn-init helper script. For an example, see the verify_instance_health
     * command in the Auto Scaling rolling updates sample template.
     *
     * @default true if you specified the minSuccessfulInstancesPercent property, false otherwise
     * @deprecated
     */
    readonly waitOnResourceSignals?: boolean;
    /**
     * (deprecated) Specifies the Auto Scaling processes to suspend during a stack update.
     *
     * Suspending processes prevents Auto Scaling from interfering with a stack
     * update.
     *
     * @default HealthCheck, ReplaceUnhealthy, AZRebalance, AlarmNotification, ScheduledActions.
     * @deprecated
     */
    readonly suspendProcesses?: ScalingProcess[];
}
/**
 * (experimental) A list of ScalingEvents, you can use one of the predefined lists, such as ScalingEvents.ERRORS or create a custom group by instantiating a `NotificationTypes` object, e.g: `new NotificationTypes(`NotificationType.INSTANCE_LAUNCH`)`.
 *
 * @experimental
 */
export declare class ScalingEvents {
    /**
     * (experimental) Fleet scaling errors.
     *
     * @experimental
     */
    static readonly ERRORS: ScalingEvents;
    /**
     * (experimental) All fleet scaling events.
     *
     * @experimental
     */
    static readonly ALL: ScalingEvents;
    /**
     * (experimental) Fleet scaling launch events.
     *
     * @experimental
     */
    static readonly LAUNCH_EVENTS: ScalingEvents;
    /**
     * @internal
     */
    readonly _types: ScalingEvent[];
    /**
     * @experimental
     */
    constructor(...types: ScalingEvent[]);
}
/**
 * @experimental
 */
export declare enum ScalingProcess {
    /**
     * @experimental
     */
    LAUNCH = "Launch",
    /**
     * @experimental
     */
    TERMINATE = "Terminate",
    /**
     * @experimental
     */
    HEALTH_CHECK = "HealthCheck",
    /**
     * @experimental
     */
    REPLACE_UNHEALTHY = "ReplaceUnhealthy",
    /**
     * @experimental
     */
    AZ_REBALANCE = "AZRebalance",
    /**
     * @experimental
     */
    ALARM_NOTIFICATION = "AlarmNotification",
    /**
     * @experimental
     */
    SCHEDULED_ACTIONS = "ScheduledActions",
    /**
     * @experimental
     */
    ADD_TO_LOAD_BALANCER = "AddToLoadBalancer"
}
/**
 * (experimental) EC2 Heath check options.
 *
 * @experimental
 */
export interface Ec2HealthCheckOptions {
    /**
     * (experimental) Specified the time Auto Scaling waits before checking the health status of an EC2 instance that has come into service.
     *
     * @default Duration.seconds(0)
     * @experimental
     */
    readonly grace?: Duration;
}
/**
 * (experimental) ELB Heath check options.
 *
 * @experimental
 */
export interface ElbHealthCheckOptions {
    /**
     * (experimental) Specified the time Auto Scaling waits before checking the health status of an EC2 instance that has come into service.
     *
     * This option is required for ELB health checks.
     *
     * @experimental
     */
    readonly grace: Duration;
}
/**
 * (experimental) Health check settings.
 *
 * @experimental
 */
export declare class HealthCheck {
    readonly type: string;
    readonly gracePeriod?: Duration | undefined;
    /**
     * (experimental) Use EC2 for health checks.
     *
     * @param options EC2 health check options.
     * @experimental
     */
    static ec2(options?: Ec2HealthCheckOptions): HealthCheck;
    /**
     * (experimental) Use ELB for health checks.
     *
     * It considers the instance unhealthy if it fails either the EC2 status checks or the load balancer health checks.
     *
     * @param options ELB health check options.
     * @experimental
     */
    static elb(options: ElbHealthCheckOptions): HealthCheck;
    private constructor();
}
/**
 * (experimental) An AutoScalingGroup.
 *
 * @experimental
 */
export interface IAutoScalingGroup extends IResource, iam.IGrantable {
    /**
     * (experimental) The name of the AutoScalingGroup.
     *
     * @experimental
     * @attribute true
     */
    readonly autoScalingGroupName: string;
    /**
     * (experimental) The arn of the AutoScalingGroup.
     *
     * @experimental
     * @attribute true
     */
    readonly autoScalingGroupArn: string;
    /**
     * (experimental) The operating system family that the instances in this auto-scaling group belong to.
     *
     * Is 'UNKNOWN' for imported ASGs.
     *
     * @experimental
     */
    readonly osType: ec2.OperatingSystemType;
    /**
     * (experimental) Add command to the startup script of fleet instances.
     *
     * The command must be in the scripting language supported by the fleet's OS (i.e. Linux/Windows).
     * Does nothing for imported ASGs.
     *
     * @experimental
     */
    addUserData(...commands: string[]): void;
    /**
     * (experimental) Send a message to either an SQS queue or SNS topic when instances launch or terminate.
     *
     * @experimental
     */
    addLifecycleHook(id: string, props: BasicLifecycleHookProps): LifecycleHook;
    /**
     * (experimental) Scale out or in based on time.
     *
     * @experimental
     */
    scaleOnSchedule(id: string, props: BasicScheduledActionProps): ScheduledAction;
    /**
     * (experimental) Scale out or in to achieve a target CPU utilization.
     *
     * @experimental
     */
    scaleOnCpuUtilization(id: string, props: CpuUtilizationScalingProps): TargetTrackingScalingPolicy;
    /**
     * (experimental) Scale out or in to achieve a target network ingress rate.
     *
     * @experimental
     */
    scaleOnIncomingBytes(id: string, props: NetworkUtilizationScalingProps): TargetTrackingScalingPolicy;
    /**
     * (experimental) Scale out or in to achieve a target network egress rate.
     *
     * @experimental
     */
    scaleOnOutgoingBytes(id: string, props: NetworkUtilizationScalingProps): TargetTrackingScalingPolicy;
    /**
     * (experimental) Scale out or in in order to keep a metric around a target value.
     *
     * @experimental
     */
    scaleToTrackMetric(id: string, props: MetricTargetTrackingProps): TargetTrackingScalingPolicy;
    /**
     * (experimental) Scale out or in, in response to a metric.
     *
     * @experimental
     */
    scaleOnMetric(id: string, props: BasicStepScalingPolicyProps): StepScalingPolicy;
}
/**
 * (experimental) Properties for enabling scaling based on CPU utilization.
 *
 * @experimental
 */
export interface CpuUtilizationScalingProps extends BaseTargetTrackingProps {
    /**
     * (experimental) Target average CPU utilization across the task.
     *
     * @experimental
     */
    readonly targetUtilizationPercent: number;
}
/**
 * (experimental) Properties for enabling scaling based on network utilization.
 *
 * @experimental
 */
export interface NetworkUtilizationScalingProps extends BaseTargetTrackingProps {
    /**
     * (experimental) Target average bytes/seconds on each instance.
     *
     * @experimental
     */
    readonly targetBytesPerSecond: number;
}
/**
 * (experimental) Properties for enabling scaling based on request/second.
 *
 * @experimental
 */
export interface RequestCountScalingProps extends BaseTargetTrackingProps {
    /**
     * (deprecated) Target average requests/seconds on each instance.
     *
     * @default - Specify exactly one of 'targetRequestsPerMinute' and 'targetRequestsPerSecond'
     * @deprecated Use 'targetRequestsPerMinute' instead
     */
    readonly targetRequestsPerSecond?: number;
    /**
     * (experimental) Target average requests/minute on each instance.
     *
     * @default - Specify exactly one of 'targetRequestsPerMinute' and 'targetRequestsPerSecond'
     * @experimental
     */
    readonly targetRequestsPerMinute?: number;
}
/**
 * (experimental) Properties for enabling tracking of an arbitrary metric.
 *
 * @experimental
 */
export interface MetricTargetTrackingProps extends BaseTargetTrackingProps {
    /**
     * (experimental) Metric to track.
     *
     * The metric must represent a utilization, so that if it's higher than the
     * target value, your ASG should scale out, and if it's lower it should
     * scale in.
     *
     * @experimental
     */
    readonly metric: cloudwatch.IMetric;
    /**
     * (experimental) Value to keep the metric around.
     *
     * @experimental
     */
    readonly targetValue: number;
}
/**
 * (experimental) Options for applying CloudFormation init to an instance or instance group.
 *
 * @experimental
 */
export interface ApplyCloudFormationInitOptions {
    /**
     * (experimental) ConfigSet to activate.
     *
     * @default ['default']
     * @experimental
     */
    readonly configSets?: string[];
    /**
     * (experimental) Force instance replacement by embedding a config fingerprint.
     *
     * If `true` (the default), a hash of the config will be embedded into the
     * UserData, so that if the config changes, the UserData changes and
     * instances will be replaced (given an UpdatePolicy has been configured on
     * the AutoScalingGroup).
     *
     * If `false`, no such hash will be embedded, and if the CloudFormation Init
     * config changes nothing will happen to the running instances. If a
     * config update introduces errors, you will not notice until after the
     * CloudFormation deployment successfully finishes and the next instance
     * fails to launch.
     *
     * @default true
     * @experimental
     */
    readonly embedFingerprint?: boolean;
    /**
     * (experimental) Print the results of running cfn-init to the Instance System Log.
     *
     * By default, the output of running cfn-init is written to a log file
     * on the instance. Set this to `true` to print it to the System Log
     * (visible from the EC2 Console), `false` to not print it.
     *
     * (Be aware that the system log is refreshed at certain points in
     * time of the instance life cycle, and successful execution may
     * not always show up).
     *
     * @default true
     * @experimental
     */
    readonly printLog?: boolean;
    /**
     * (experimental) Don't fail the instance creation when cfn-init fails.
     *
     * You can use this to prevent CloudFormation from rolling back when
     * instances fail to start up, to help in debugging.
     *
     * @default false
     * @experimental
     */
    readonly ignoreFailures?: boolean;
}
export {};
