"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionHook = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const sns = require("../../aws-sns"); // Automatically re-written from '@aws-cdk/aws-sns'
const subs = require("../../aws-sns-subscriptions"); // Automatically re-written from '@aws-cdk/aws-sns-subscriptions'
const topic_hook_1 = require("./topic-hook");
/**
 * (experimental) Use a Lambda Function as a hook target.
 *
 * Internally creates a Topic to make the connection.
 *
 * @experimental
 */
class FunctionHook {
    /**
     * @param fn Function to invoke in response to a lifecycle event.
     * @param encryptionKey If provided, this key is used to encrypt the contents of the SNS topic.
     * @experimental
     */
    constructor(fn, encryptionKey) {
        this.fn = fn;
        this.encryptionKey = encryptionKey;
    }
    /**
     * (experimental) Called when this object is used as the target of a lifecycle hook.
     *
     * @experimental
     */
    bind(scope, lifecycleHook) {
        var _b;
        const topic = new sns.Topic(scope, 'Topic', {
            masterKey: this.encryptionKey,
        });
        // Per: https://docs.aws.amazon.com/sns/latest/dg/sns-key-management.html#sns-what-permissions-for-sse
        // Topic's grantPublish() is in a base class that does not know there is a kms key, and so does not
        // grant appropriate permissions to the kms key. We do that here to ensure the correct permissions
        // are in place.
        (_b = this.encryptionKey) === null || _b === void 0 ? void 0 : _b.grant(lifecycleHook.role, 'kms:Decrypt', 'kms:GenerateDataKey');
        topic.addSubscription(new subs.LambdaSubscription(this.fn));
        return new topic_hook_1.TopicHook(topic).bind(scope, lifecycleHook);
    }
}
exports.FunctionHook = FunctionHook;
_a = JSII_RTTI_SYMBOL_1;
FunctionHook[_a] = { fqn: "monocdk.aws_autoscaling_hooktargets.FunctionHook", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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