"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppsyncFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const appsync_generated_1 = require("./appsync.generated");
/**
 * (experimental) AppSync Functions are local functions that perform certain operations onto a backend data source.
 *
 * Developers can compose operations (Functions)
 * and execute them in sequence with Pipeline Resolvers.
 *
 * @experimental
 * @resource AWS::AppSync::FunctionConfiguration
 */
class AppsyncFunction extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        this.function = new appsync_generated_1.CfnFunctionConfiguration(this, 'Resource', {
            name: props.name,
            description: props.description,
            apiId: props.api.apiId,
            dataSourceName: props.dataSource.name,
            functionVersion: '2018-05-29',
            requestMappingTemplate: (_b = props.requestMappingTemplate) === null || _b === void 0 ? void 0 : _b.renderTemplate(),
            responseMappingTemplate: (_c = props.responseMappingTemplate) === null || _c === void 0 ? void 0 : _c.renderTemplate(),
        });
        this.functionName = this.function.attrName;
        this.functionArn = this.function.attrFunctionArn;
        this.functionId = this.function.attrFunctionId;
        this.dataSource = props.dataSource;
        this.function.addDependsOn(this.dataSource.ds);
        props.api.addSchemaDependency(this.function);
    }
    /**
     * (experimental) Import Appsync Function from arn.
     *
     * @experimental
     */
    static fromAppsyncFunctionAttributes(scope, id, attrs) {
        class Import extends core_1.Resource {
            constructor(s, i) {
                super(s, i);
                this.functionId = core_1.Lazy.stringValue({
                    produce: () => core_1.Fn.select(3, core_1.Fn.split('/', attrs.functionArn)),
                });
                this.functionArn = attrs.functionArn;
            }
        }
        return new Import(scope, id);
    }
}
exports.AppsyncFunction = AppsyncFunction;
_a = JSII_RTTI_SYMBOL_1;
AppsyncFunction[_a] = { fqn: "monocdk.aws_appsync.AppsyncFunction", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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