"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppStreamMetrics = void 0;
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class AppStreamMetrics {
    static capacityUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/AppStream',
            metricName: 'CapacityUtilization',
            dimensions,
            statistic: 'Average',
        };
    }
    static insufficientCapacityErrorSum(dimensions) {
        return {
            namespace: 'AWS/AppStream',
            metricName: 'InsufficientCapacityError',
            dimensions,
            statistic: 'Sum',
        };
    }
    static actualCapacityAverage(dimensions) {
        return {
            namespace: 'AWS/AppStream',
            metricName: 'ActualCapacity',
            dimensions,
            statistic: 'Average',
        };
    }
    static availableCapacityAverage(dimensions) {
        return {
            namespace: 'AWS/AppStream',
            metricName: 'AvailableCapacity',
            dimensions,
            statistic: 'Average',
        };
    }
    static desiredCapacityAverage(dimensions) {
        return {
            namespace: 'AWS/AppStream',
            metricName: 'DesiredCapacity',
            dimensions,
            statistic: 'Average',
        };
    }
    static inUseCapacityAverage(dimensions) {
        return {
            namespace: 'AWS/AppStream',
            metricName: 'InUseCapacity',
            dimensions,
            statistic: 'Average',
        };
    }
    static pendingCapacityAverage(dimensions) {
        return {
            namespace: 'AWS/AppStream',
            metricName: 'PendingCapacity',
            dimensions,
            statistic: 'Average',
        };
    }
    static runningCapacityAverage(dimensions) {
        return {
            namespace: 'AWS/AppStream',
            metricName: 'RunningCapacity',
            dimensions,
            statistic: 'Average',
        };
    }
}
exports.AppStreamMetrics = AppStreamMetrics;
//# sourceMappingURL=data:application/json;base64,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