"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualServiceProvider = exports.VirtualService = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const appmesh_generated_1 = require("./appmesh.generated");
const mesh_1 = require("./mesh");
/**
 * (experimental) VirtualService represents a service inside an AppMesh.
 *
 * It routes traffic either to a Virtual Node or to a Virtual Router.
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_services.html
 * @experimental
 */
class VirtualService extends cdk.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.virtualServiceName || cdk.Lazy.string({ produce: () => cdk.Names.uniqueId(this) }),
        });
        const providerConfig = props.virtualServiceProvider.bind(this);
        this.mesh = providerConfig.mesh;
        const svc = new appmesh_generated_1.CfnVirtualService(this, 'Resource', {
            meshName: this.mesh.meshName,
            virtualServiceName: this.physicalName,
            spec: {
                provider: providerConfig.virtualNodeProvider || providerConfig.virtualRouterProvider
                    ? {
                        virtualNode: providerConfig.virtualNodeProvider,
                        virtualRouter: providerConfig.virtualRouterProvider,
                    }
                    : undefined,
            },
        });
        this.virtualServiceName = this.getResourceNameAttribute(svc.attrVirtualServiceName);
        this.virtualServiceArn = this.getResourceArnAttribute(svc.ref, {
            service: 'appmesh',
            resource: `mesh/${this.mesh.meshName}/virtualService`,
            resourceName: this.physicalName,
        });
    }
    /**
     * (experimental) Import an existing VirtualService given an ARN.
     *
     * @experimental
     */
    static fromVirtualServiceArn(scope, id, virtualServiceArn) {
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.virtualServiceArn = virtualServiceArn;
                this.parsedArn = cdk.Fn.split('/', cdk.Stack.of(scope).parseArn(virtualServiceArn).resourceName);
                this.virtualServiceName = cdk.Fn.select(2, this.parsedArn);
                this.mesh = mesh_1.Mesh.fromMeshName(this, 'Mesh', cdk.Fn.select(0, this.parsedArn));
            }
        }(scope, id);
    }
    /**
     * (experimental) Import an existing VirtualService given its attributes.
     *
     * @experimental
     */
    static fromVirtualServiceAttributes(scope, id, attrs) {
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.virtualServiceName = attrs.virtualServiceName;
                this.mesh = attrs.mesh;
                this.virtualServiceArn = cdk.Stack.of(this).formatArn({
                    service: 'appmesh',
                    resource: `mesh/${attrs.mesh.meshName}/virtualService`,
                    resourceName: this.virtualServiceName,
                });
            }
        }(scope, id);
    }
}
exports.VirtualService = VirtualService;
_a = JSII_RTTI_SYMBOL_1;
VirtualService[_a] = { fqn: "monocdk.aws_appmesh.VirtualService", version: "1.106.1" };
/**
 * (experimental) Represents the properties needed to define the provider for a VirtualService.
 *
 * @experimental
 */
class VirtualServiceProvider {
    /**
     * (experimental) Returns a VirtualNode based Provider for a VirtualService.
     *
     * @experimental
     */
    static virtualNode(virtualNode) {
        return new VirtualServiceProviderImpl(virtualNode, undefined);
    }
    /**
     * (experimental) Returns a VirtualRouter based Provider for a VirtualService.
     *
     * @experimental
     */
    static virtualRouter(virtualRouter) {
        return new VirtualServiceProviderImpl(undefined, virtualRouter);
    }
    /**
     * (experimental) Returns an Empty Provider for a VirtualService.
     *
     * This provides no routing capabilities
     * and should only be used as a placeholder
     *
     * @experimental
     */
    static none(mesh) {
        return new VirtualServiceProviderImpl(undefined, undefined, mesh);
    }
}
exports.VirtualServiceProvider = VirtualServiceProvider;
_b = JSII_RTTI_SYMBOL_1;
VirtualServiceProvider[_b] = { fqn: "monocdk.aws_appmesh.VirtualServiceProvider", version: "1.106.1" };
class VirtualServiceProviderImpl extends VirtualServiceProvider {
    constructor(virtualNode, virtualRouter, mesh) {
        var _c, _d, _e, _f;
        super();
        this.virtualNode = virtualNode;
        this.virtualRouter = virtualRouter;
        const providedMesh = (_f = (_d = (_c = this.virtualNode) === null || _c === void 0 ? void 0 : _c.mesh) !== null && _d !== void 0 ? _d : (_e = this.virtualRouter) === null || _e === void 0 ? void 0 : _e.mesh) !== null && _f !== void 0 ? _f : mesh;
        this.mesh = providedMesh;
    }
    bind(_construct) {
        return {
            mesh: this.mesh,
            virtualNodeProvider: this.virtualNode
                ? {
                    virtualNodeName: this.virtualNode.virtualNodeName,
                }
                : undefined,
            virtualRouterProvider: this.virtualRouter
                ? {
                    virtualRouterName: this.virtualRouter.virtualRouterName,
                }
                : undefined,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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