import * as iam from "../../aws-iam";
import * as cdk from "../../core";
import { Construct } from 'constructs';
import { IMesh } from './mesh';
import { ServiceDiscovery } from './service-discovery';
import { AccessLog, BackendDefaults, Backend } from './shared-interfaces';
import { VirtualNodeListener } from './virtual-node-listener';
/**
 * (experimental) Interface which all VirtualNode based classes must implement.
 *
 * @experimental
 */
export interface IVirtualNode extends cdk.IResource {
    /**
     * (experimental) The name of the VirtualNode.
     *
     * @experimental
     * @attribute true
     */
    readonly virtualNodeName: string;
    /**
     * (experimental) The Amazon Resource Name belonging to the VirtualNode.
     *
     * Set this value as the APPMESH_VIRTUAL_NODE_NAME environment variable for
     * your task group's Envoy proxy container in your task definition or pod
     * spec.
     *
     * @experimental
     * @attribute true
     */
    readonly virtualNodeArn: string;
    /**
     * (experimental) The Mesh which the VirtualNode belongs to.
     *
     * @experimental
     */
    readonly mesh: IMesh;
    /**
     * (experimental) Grants the given entity `appmesh:StreamAggregatedResources`.
     *
     * @experimental
     */
    grantStreamAggregatedResources(identity: iam.IGrantable): iam.Grant;
}
/**
 * (experimental) Basic configuration properties for a VirtualNode.
 *
 * @experimental
 */
export interface VirtualNodeBaseProps {
    /**
     * (experimental) The name of the VirtualNode.
     *
     * @default - A name is automatically determined
     * @experimental
     */
    readonly virtualNodeName?: string;
    /**
     * (experimental) Defines how upstream clients will discover this VirtualNode.
     *
     * @default - No Service Discovery
     * @experimental
     */
    readonly serviceDiscovery?: ServiceDiscovery;
    /**
     * (experimental) Virtual Services that this is node expected to send outbound traffic to.
     *
     * @default - No backends
     * @experimental
     */
    readonly backends?: Backend[];
    /**
     * (experimental) Initial listener for the virtual node.
     *
     * @default - No listeners
     * @experimental
     */
    readonly listeners?: VirtualNodeListener[];
    /**
     * (experimental) Access Logging Configuration for the virtual node.
     *
     * @default - No access logging
     * @experimental
     */
    readonly accessLog?: AccessLog;
    /**
     * (experimental) Default Configuration Virtual Node uses to communicate with Virtual Service.
     *
     * @default - No Config
     * @experimental
     */
    readonly backendDefaults?: BackendDefaults;
}
/**
 * (experimental) The properties used when creating a new VirtualNode.
 *
 * @experimental
 */
export interface VirtualNodeProps extends VirtualNodeBaseProps {
    /**
     * (experimental) The Mesh which the VirtualNode belongs to.
     *
     * @experimental
     */
    readonly mesh: IMesh;
}
declare abstract class VirtualNodeBase extends cdk.Resource implements IVirtualNode {
    /**
     * The name of the VirtualNode
     */
    abstract readonly virtualNodeName: string;
    /**
     * The Amazon Resource Name belonging to the VirtualNode
     */
    abstract readonly virtualNodeArn: string;
    /**
     * The Mesh which the VirtualNode belongs to
     */
    abstract readonly mesh: IMesh;
    /**
     * (experimental) Grants the given entity `appmesh:StreamAggregatedResources`.
     *
     * @experimental
     */
    grantStreamAggregatedResources(identity: iam.IGrantable): iam.Grant;
}
/**
 * (experimental) VirtualNode represents a newly defined AppMesh VirtualNode.
 *
 * Any inbound traffic that your virtual node expects should be specified as a
 * listener. Any outbound traffic that your virtual node expects to reach
 * should be specified as a backend.
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_nodes.html
 * @experimental
 */
export declare class VirtualNode extends VirtualNodeBase {
    /**
     * (experimental) Import an existing VirtualNode given an ARN.
     *
     * @experimental
     */
    static fromVirtualNodeArn(scope: Construct, id: string, virtualNodeArn: string): IVirtualNode;
    /**
     * (experimental) Import an existing VirtualNode given its name.
     *
     * @experimental
     */
    static fromVirtualNodeAttributes(scope: Construct, id: string, attrs: VirtualNodeAttributes): IVirtualNode;
    /**
     * (experimental) The name of the VirtualNode.
     *
     * @experimental
     */
    readonly virtualNodeName: string;
    /**
     * (experimental) The Amazon Resource Name belonging to the VirtualNode.
     *
     * @experimental
     */
    readonly virtualNodeArn: string;
    /**
     * (experimental) The Mesh which the VirtualNode belongs to.
     *
     * @experimental
     */
    readonly mesh: IMesh;
    private readonly backends;
    private readonly listeners;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: VirtualNodeProps);
    /**
     * (experimental) Utility method to add an inbound listener for this VirtualNode.
     *
     * Note: At this time, Virtual Nodes support at most one listener. Adding
     * more than one will result in a failure to deploy the CloudFormation stack.
     * However, the App Mesh team has plans to add support for multiple listeners
     * on Virtual Nodes and Virtual Routers.
     *
     * @see https://github.com/aws/aws-app-mesh-roadmap/issues/120
     * @experimental
     */
    addListener(listener: VirtualNodeListener): void;
    /**
     * (experimental) Add a Virtual Services that this node is expected to send outbound traffic to.
     *
     * @experimental
     */
    addBackend(backend: Backend): void;
}
/**
 * (experimental) Interface with properties necessary to import a reusable VirtualNode.
 *
 * @experimental
 */
export interface VirtualNodeAttributes {
    /**
     * (experimental) The name of the VirtualNode.
     *
     * @experimental
     */
    readonly virtualNodeName: string;
    /**
     * (experimental) The Mesh that the VirtualNode belongs to.
     *
     * @experimental
     */
    readonly mesh: IMesh;
}
export {};
