"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualGatewayListener = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * (experimental) Represents the properties needed to define listeners for a VirtualGateway.
 *
 * @experimental
 */
class VirtualGatewayListener {
    /**
     * (experimental) Returns an HTTP Listener for a VirtualGateway.
     *
     * @experimental
     */
    static http(options = {}) {
        return new VirtualGatewayListenerImpl(shared_interfaces_1.Protocol.HTTP, options.healthCheck, options.port, options.tlsCertificate, options.connectionPool);
    }
    /**
     * (experimental) Returns an HTTP2 Listener for a VirtualGateway.
     *
     * @experimental
     */
    static http2(options = {}) {
        return new VirtualGatewayListenerImpl(shared_interfaces_1.Protocol.HTTP2, options.healthCheck, options.port, options.tlsCertificate, options.connectionPool);
    }
    /**
     * (experimental) Returns a GRPC Listener for a VirtualGateway.
     *
     * @experimental
     */
    static grpc(options = {}) {
        return new VirtualGatewayListenerImpl(shared_interfaces_1.Protocol.GRPC, options.healthCheck, options.port, options.tlsCertificate, options.connectionPool);
    }
}
exports.VirtualGatewayListener = VirtualGatewayListener;
_a = JSII_RTTI_SYMBOL_1;
VirtualGatewayListener[_a] = { fqn: "monocdk.aws_appmesh.VirtualGatewayListener", version: "1.106.1" };
/**
 * Represents the properties needed to define an HTTP Listener for a VirtualGateway
 */
class VirtualGatewayListenerImpl extends VirtualGatewayListener {
    constructor(protocol, healthCheck, port = 8080, tlsCertificate, connectionPool) {
        super();
        this.protocol = protocol;
        this.healthCheck = healthCheck;
        this.port = port;
        this.tlsCertificate = tlsCertificate;
        this.connectionPool = connectionPool;
    }
    /**
     * Called when the GatewayListener type is initialized. Can be used to enforce
     * mutual exclusivity
     */
    bind(scope) {
        var _b, _c;
        const tlsConfig = (_b = this.tlsCertificate) === null || _b === void 0 ? void 0 : _b.bind(scope);
        return {
            listener: {
                portMapping: {
                    port: this.port,
                    protocol: this.protocol,
                },
                healthCheck: (_c = this.healthCheck) === null || _c === void 0 ? void 0 : _c.bind(scope, { defaultPort: this.port }).virtualGatewayHealthCheck,
                tls: tlsConfig ? renderTls(tlsConfig) : undefined,
                connectionPool: this.connectionPool ? renderConnectionPool(this.connectionPool, this.protocol) : undefined,
            },
        };
    }
}
/**
 * Renders the TLS config for a listener
 */
function renderTls(tlsCertificateConfig) {
    return {
        certificate: tlsCertificateConfig.tlsCertificate,
        mode: tlsCertificateConfig.tlsMode.toString(),
    };
}
function renderConnectionPool(connectionPool, listenerProtocol) {
    return ({
        [listenerProtocol]: {
            maxRequests: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxRequests) !== undefined ? connectionPool.maxRequests : undefined,
            maxConnections: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxConnections) !== undefined ? connectionPool.maxConnections : undefined,
            maxPendingRequests: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxPendingRequests) !== undefined ? connectionPool.maxPendingRequests : undefined,
        },
    });
}
//# sourceMappingURL=data:application/json;base64,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