"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TlsCertificate = exports.TlsMode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) Enum of supported TLS modes.
 *
 * @experimental
 */
var TlsMode;
(function (TlsMode) {
    TlsMode["STRICT"] = "STRICT";
    TlsMode["PERMISSIVE"] = "PERMISSIVE";
    TlsMode["DISABLED"] = "DISABLED";
})(TlsMode = exports.TlsMode || (exports.TlsMode = {}));
/**
 * (experimental) Represents a TLS certificate.
 *
 * @experimental
 */
class TlsCertificate {
    /**
     * (experimental) Returns an File TLS Certificate.
     *
     * @experimental
     */
    static file(props) {
        return new FileTlsCertificate(props);
    }
    /**
     * (experimental) Returns an ACM TLS Certificate.
     *
     * @experimental
     */
    static acm(props) {
        return new AcmTlsCertificate(props);
    }
}
exports.TlsCertificate = TlsCertificate;
_a = JSII_RTTI_SYMBOL_1;
TlsCertificate[_a] = { fqn: "monocdk.aws_appmesh.TlsCertificate", version: "1.106.1" };
/**
 * Represents a ACM provided TLS certificate
 */
class AcmTlsCertificate extends TlsCertificate {
    constructor(props) {
        super();
        this.tlsMode = props.tlsMode;
        this.acmCertificate = props.certificate;
    }
    bind(_scope) {
        return {
            tlsCertificate: {
                acm: {
                    certificateArn: this.acmCertificate.certificateArn,
                },
            },
            tlsMode: this.tlsMode,
        };
    }
}
/**
 * Represents a file provided TLS certificate
 */
class FileTlsCertificate extends TlsCertificate {
    constructor(props) {
        super();
        this.tlsMode = props.tlsMode;
        this.certificateChain = props.certificateChainPath;
        this.privateKey = props.privateKeyPath;
    }
    bind(_scope) {
        return {
            tlsCertificate: {
                file: {
                    certificateChain: this.certificateChain,
                    privateKey: this.privateKey,
                },
            },
            tlsMode: this.tlsMode,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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