import * as acm from "../../aws-certificatemanager";
import { CfnVirtualNode } from './appmesh.generated';
import { Construct } from "../../core";
/**
 * (experimental) Enum of supported TLS modes.
 *
 * @experimental
 */
export declare enum TlsMode {
    /**
     * (experimental) Only accept encrypted traffic.
     *
     * @experimental
     */
    STRICT = "STRICT",
    /**
     * (experimental) Accept encrypted and plaintext traffic.
     *
     * @experimental
     */
    PERMISSIVE = "PERMISSIVE",
    /**
     * (experimental) TLS is disabled, only accept plaintext traffic.
     *
     * @experimental
     */
    DISABLED = "DISABLED"
}
/**
 * (experimental) A wrapper for the tls config returned by {@link TlsCertificate.bind}.
 *
 * @experimental
 */
export interface TlsCertificateConfig {
    /**
     * (experimental) The CFN shape for a listener TLS certificate.
     *
     * @experimental
     */
    readonly tlsCertificate: CfnVirtualNode.ListenerTlsCertificateProperty;
    /**
     * (experimental) The TLS mode.
     *
     * @experimental
     */
    readonly tlsMode: TlsMode;
}
/**
 * (experimental) ACM Certificate Properties.
 *
 * @experimental
 */
export interface AcmCertificateOptions {
    /**
     * (experimental) The TLS mode.
     *
     * @experimental
     */
    readonly tlsMode: TlsMode;
    /**
     * (experimental) The ACM certificate.
     *
     * @experimental
     */
    readonly certificate: acm.ICertificate;
}
/**
 * (experimental) File Certificate Properties.
 *
 * @experimental
 */
export interface FileCertificateOptions {
    /**
     * (experimental) The TLS mode.
     *
     * @experimental
     */
    readonly tlsMode: TlsMode;
    /**
     * (experimental) The file path of the certificate chain file.
     *
     * @experimental
     */
    readonly certificateChainPath: string;
    /**
     * (experimental) The file path of the private key file.
     *
     * @experimental
     */
    readonly privateKeyPath: string;
}
/**
 * (experimental) Represents a TLS certificate.
 *
 * @experimental
 */
export declare abstract class TlsCertificate {
    /**
     * (experimental) Returns an File TLS Certificate.
     *
     * @experimental
     */
    static file(props: FileCertificateOptions): TlsCertificate;
    /**
     * (experimental) Returns an ACM TLS Certificate.
     *
     * @experimental
     */
    static acm(props: AcmCertificateOptions): TlsCertificate;
    /**
     * (experimental) Returns TLS certificate based provider.
     *
     * @experimental
     */
    abstract bind(_scope: Construct): TlsCertificateConfig;
}
