import * as cdk from "../../core";
import { CfnVirtualGateway, CfnVirtualNode } from './appmesh.generated';
import { ClientPolicy } from './client-policy';
import { IVirtualService } from './virtual-service';
import { Construct } from "../../core";
/**
 * (experimental) Represents timeouts for HTTP protocols.
 *
 * @experimental
 */
export interface HttpTimeout {
    /**
     * (experimental) Represents an idle timeout.
     *
     * The amount of time that a connection may be idle.
     *
     * @default - none
     * @experimental
     */
    readonly idle?: cdk.Duration;
    /**
     * (experimental) Represents per request timeout.
     *
     * @default - 15 s
     * @experimental
     */
    readonly perRequest?: cdk.Duration;
}
/**
 * (experimental) Represents timeouts for GRPC protocols.
 *
 * @experimental
 */
export interface GrpcTimeout {
    /**
     * (experimental) Represents an idle timeout.
     *
     * The amount of time that a connection may be idle.
     *
     * @default - none
     * @experimental
     */
    readonly idle?: cdk.Duration;
    /**
     * (experimental) Represents per request timeout.
     *
     * @default - 15 s
     * @experimental
     */
    readonly perRequest?: cdk.Duration;
}
/**
 * (experimental) Represents timeouts for TCP protocols.
 *
 * @experimental
 */
export interface TcpTimeout {
    /**
     * (experimental) Represents an idle timeout.
     *
     * The amount of time that a connection may be idle.
     *
     * @default - none
     * @experimental
     */
    readonly idle?: cdk.Duration;
}
/**
 * (deprecated) Enum of supported AppMesh protocols.
 *
 * @deprecated not for use outside package
 */
export declare enum Protocol {
    /**
     * @deprecated
     */
    HTTP = "http",
    /**
     * @deprecated
     */
    TCP = "tcp",
    /**
     * @deprecated
     */
    HTTP2 = "http2",
    /**
     * @deprecated
     */
    GRPC = "grpc"
}
/**
 * (experimental) Represents the outlier detection for a listener.
 *
 * @experimental
 */
export interface OutlierDetection {
    /**
     * (experimental) The base amount of time for which a host is ejected.
     *
     * @experimental
     */
    readonly baseEjectionDuration: cdk.Duration;
    /**
     * (experimental) The time interval between ejection sweep analysis.
     *
     * @experimental
     */
    readonly interval: cdk.Duration;
    /**
     * (experimental) Maximum percentage of hosts in load balancing pool for upstream service that can be ejected.
     *
     * Will eject at
     * least one host regardless of the value.
     *
     * @experimental
     */
    readonly maxEjectionPercent: number;
    /**
     * (experimental) Number of consecutive 5xx errors required for ejection.
     *
     * @experimental
     */
    readonly maxServerErrors: number;
}
/**
 * (experimental) All Properties for Envoy Access logs for mesh endpoints.
 *
 * @experimental
 */
export interface AccessLogConfig {
    /**
     * (experimental) VirtualNode CFN configuration for Access Logging.
     *
     * @default - no access logging
     * @experimental
     */
    readonly virtualNodeAccessLog?: CfnVirtualNode.AccessLogProperty;
    /**
     * (experimental) VirtualGateway CFN configuration for Access Logging.
     *
     * @default - no access logging
     * @experimental
     */
    readonly virtualGatewayAccessLog?: CfnVirtualGateway.VirtualGatewayAccessLogProperty;
}
/**
 * (experimental) Configuration for Envoy Access logs for mesh endpoints.
 *
 * @experimental
 */
export declare abstract class AccessLog {
    /**
     * (experimental) Path to a file to write access logs to.
     *
     * @default - no file based access logging
     * @experimental
     */
    static fromFilePath(filePath: string): AccessLog;
    /**
     * (experimental) Called when the AccessLog type is initialized.
     *
     * Can be used to enforce
     * mutual exclusivity with future properties
     *
     * @experimental
     */
    abstract bind(scope: Construct): AccessLogConfig;
}
/**
 * (experimental) Represents the properties needed to define backend defaults.
 *
 * @experimental
 */
export interface BackendDefaults {
    /**
     * (experimental) Client policy for backend defaults.
     *
     * @default none
     * @experimental
     */
    readonly clientPolicy?: ClientPolicy;
}
/**
 * (experimental) Represents the properties needed to define a Virtual Service backend.
 *
 * @experimental
 */
export interface VirtualServiceBackendOptions {
    /**
     * (experimental) Client policy for the backend.
     *
     * @default none
     * @experimental
     */
    readonly clientPolicy?: ClientPolicy;
}
/**
 * (experimental) Properties for a backend.
 *
 * @experimental
 */
export interface BackendConfig {
    /**
     * (experimental) Config for a Virtual Service backend.
     *
     * @experimental
     */
    readonly virtualServiceBackend: CfnVirtualNode.BackendProperty;
}
/**
 * (experimental) Contains static factory methods to create backends.
 *
 * @experimental
 */
export declare abstract class Backend {
    /**
     * (experimental) Construct a Virtual Service backend.
     *
     * @experimental
     */
    static virtualService(virtualService: IVirtualService, props?: VirtualServiceBackendOptions): Backend;
    /**
     * (experimental) Return backend config.
     *
     * @experimental
     */
    abstract bind(_scope: Construct): BackendConfig;
}
/**
 * (experimental) Connection pool properties for HTTP listeners.
 *
 * @experimental
 */
export interface HttpConnectionPool {
    /**
     * (experimental) The maximum connections in the pool.
     *
     * @default - none
     * @experimental
     */
    readonly maxConnections: number;
    /**
     * (experimental) The maximum pending requests in the pool.
     *
     * @default - none
     * @experimental
     */
    readonly maxPendingRequests: number;
}
/**
 * (experimental) Connection pool properties for TCP listeners.
 *
 * @experimental
 */
export interface TcpConnectionPool {
    /**
     * (experimental) The maximum connections in the pool.
     *
     * @default - none
     * @experimental
     */
    readonly maxConnections: number;
}
/**
 * (experimental) Connection pool properties for gRPC listeners.
 *
 * @experimental
 */
export interface GrpcConnectionPool {
    /**
     * (experimental) The maximum requests in the pool.
     *
     * @default - none
     * @experimental
     */
    readonly maxRequests: number;
}
/**
 * (experimental) Connection pool properties for HTTP2 listeners.
 *
 * @experimental
 */
export interface Http2ConnectionPool {
    /**
     * (experimental) The maximum requests in the pool.
     *
     * @default - none
     * @experimental
     */
    readonly maxRequests: number;
}
