"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceDiscovery = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) Provides the Service Discovery method a VirtualNode uses.
 *
 * @experimental
 */
class ServiceDiscovery {
    /**
     * (experimental) Returns DNS based service discovery.
     *
     * @experimental
     */
    static dns(hostname) {
        return new DnsServiceDiscovery(hostname);
    }
    /**
     * (experimental) Returns Cloud Map based service discovery.
     *
     * @experimental
     */
    static cloudMap(options) {
        return new CloudMapServiceDiscovery(options);
    }
}
exports.ServiceDiscovery = ServiceDiscovery;
_a = JSII_RTTI_SYMBOL_1;
ServiceDiscovery[_a] = { fqn: "monocdk.aws_appmesh.ServiceDiscovery", version: "1.106.1" };
class DnsServiceDiscovery extends ServiceDiscovery {
    constructor(hostname) {
        super();
        this.hostname = hostname;
    }
    bind(_scope) {
        return {
            dns: {
                hostname: this.hostname,
            },
        };
    }
}
class CloudMapServiceDiscovery extends ServiceDiscovery {
    constructor(options) {
        super();
        this.service = options.service;
        this.instanceAttributes = options.instanceAttributes;
    }
    bind(_scope) {
        return {
            cloudmap: {
                namespaceName: this.service.namespace.namespaceName,
                serviceName: this.service.serviceName,
                attributes: renderAttributes(this.instanceAttributes),
            },
        };
    }
}
function renderAttributes(attrs) {
    if (attrs === undefined) {
        return undefined;
    }
    return Object.entries(attrs).map(([key, value]) => ({ key, value }));
}
//# sourceMappingURL=data:application/json;base64,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