import * as cdk from "../../core";
import { Construct } from 'constructs';
import { IMesh } from './mesh';
import { RouteSpec } from './route-spec';
import { IVirtualRouter } from './virtual-router';
/**
 * (experimental) Interface for which all Route based classes MUST implement.
 *
 * @experimental
 */
export interface IRoute extends cdk.IResource {
    /**
     * (experimental) The name of the route.
     *
     * @experimental
     * @attribute true
     */
    readonly routeName: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) for the route.
     *
     * @experimental
     * @attribute true
     */
    readonly routeArn: string;
    /**
     * (experimental) The VirtualRouter the Route belongs to.
     *
     * @experimental
     */
    readonly virtualRouter: IVirtualRouter;
}
/**
 * (experimental) Base interface properties for all Routes.
 *
 * @experimental
 */
export interface RouteBaseProps {
    /**
     * (experimental) The name of the route.
     *
     * @default - An automatically generated name
     * @experimental
     */
    readonly routeName?: string;
    /**
     * (experimental) Protocol specific spec.
     *
     * @experimental
     */
    readonly routeSpec: RouteSpec;
}
/**
 * (experimental) Properties to define new Routes.
 *
 * @experimental
 */
export interface RouteProps extends RouteBaseProps {
    /**
     * (experimental) The service mesh to define the route in.
     *
     * @experimental
     */
    readonly mesh: IMesh;
    /**
     * (experimental) The VirtualRouter the Route belongs to.
     *
     * @experimental
     */
    readonly virtualRouter: IVirtualRouter;
}
/**
 * (experimental) Route represents a new or existing route attached to a VirtualRouter and Mesh.
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/routes.html
 * @experimental
 */
export declare class Route extends cdk.Resource implements IRoute {
    /**
     * (experimental) Import an existing Route given an ARN.
     *
     * @experimental
     */
    static fromRouteArn(scope: Construct, id: string, routeArn: string): IRoute;
    /**
     * (experimental) Import an existing Route given attributes.
     *
     * @experimental
     */
    static fromRouteAttributes(scope: Construct, id: string, attrs: RouteAttributes): IRoute;
    /**
     * (experimental) The name of the Route.
     *
     * @experimental
     */
    readonly routeName: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) for the route.
     *
     * @experimental
     */
    readonly routeArn: string;
    /**
     * (experimental) The VirtualRouter the Route belongs to.
     *
     * @experimental
     */
    readonly virtualRouter: IVirtualRouter;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: RouteProps);
}
/**
 * (experimental) Interface with properties ncecessary to import a reusable Route.
 *
 * @experimental
 */
export interface RouteAttributes {
    /**
     * (experimental) The name of the Route.
     *
     * @experimental
     */
    readonly routeName: string;
    /**
     * (experimental) The VirtualRouter the Route belongs to.
     *
     * @experimental
     */
    readonly virtualRouter: IVirtualRouter;
}
