"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RouteSpec = exports.GrpcRetryEvent = exports.TcpRetryEvent = exports.HttpRetryEvent = exports.HttpHeaderMatch = exports.HttpRouteProtocol = exports.HttpRouteMatchMethod = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * (experimental) Supported values for matching routes based on the HTTP request method.
 *
 * @experimental
 */
var HttpRouteMatchMethod;
(function (HttpRouteMatchMethod) {
    HttpRouteMatchMethod["GET"] = "GET";
    HttpRouteMatchMethod["HEAD"] = "HEAD";
    HttpRouteMatchMethod["POST"] = "POST";
    HttpRouteMatchMethod["PUT"] = "PUT";
    HttpRouteMatchMethod["DELETE"] = "DELETE";
    HttpRouteMatchMethod["CONNECT"] = "CONNECT";
    HttpRouteMatchMethod["OPTIONS"] = "OPTIONS";
    HttpRouteMatchMethod["TRACE"] = "TRACE";
    HttpRouteMatchMethod["PATCH"] = "PATCH";
})(HttpRouteMatchMethod = exports.HttpRouteMatchMethod || (exports.HttpRouteMatchMethod = {}));
/**
 * (experimental) Supported :scheme options for HTTP2.
 *
 * @experimental
 */
var HttpRouteProtocol;
(function (HttpRouteProtocol) {
    HttpRouteProtocol["HTTP"] = "http";
    HttpRouteProtocol["HTTPS"] = "https";
})(HttpRouteProtocol = exports.HttpRouteProtocol || (exports.HttpRouteProtocol = {}));
/**
 * (experimental) Used to generate header matching methods.
 *
 * @experimental
 */
class HttpHeaderMatch {
    /**
     * (experimental) The value of the header with the given name in the request must match the specified value exactly.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param headerValue The exact value to test against.
     * @experimental
     */
    static valueIs(headerName, headerValue) {
        return new HeaderMatchImpl(headerName, false, { exact: headerValue });
    }
    /**
     * (experimental) The value of the header with the given name in the request must not match the specified value exactly.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param headerValue The exact value to test against.
     * @experimental
     */
    static valueIsNot(headerName, headerValue) {
        return new HeaderMatchImpl(headerName, true, { exact: headerValue });
    }
    /**
     * (experimental) The value of the header with the given name in the request must start with the specified characters.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param prefix The prefix to test against.
     * @experimental
     */
    static valueStartsWith(headerName, prefix) {
        return new HeaderMatchImpl(headerName, false, { prefix });
    }
    /**
     * (experimental) The value of the header with the given name in the request must not start with the specified characters.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param prefix The prefix to test against.
     * @experimental
     */
    static valueDoesNotStartWith(headerName, prefix) {
        return new HeaderMatchImpl(headerName, true, { prefix });
    }
    /**
     * (experimental) The value of the header with the given name in the request must end with the specified characters.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param suffix The suffix to test against.
     * @experimental
     */
    static valueEndsWith(headerName, suffix) {
        return new HeaderMatchImpl(headerName, false, { suffix });
    }
    /**
     * (experimental) The value of the header with the given name in the request must not end with the specified characters.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param suffix The suffix to test against.
     * @experimental
     */
    static valueDoesNotEndWith(headerName, suffix) {
        return new HeaderMatchImpl(headerName, true, { suffix });
    }
    /**
     * (experimental) The value of the header with the given name in the request must include the specified characters.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param regex The regex to test against.
     * @experimental
     */
    static valueMatchesRegex(headerName, regex) {
        return new HeaderMatchImpl(headerName, false, { regex });
    }
    /**
     * (experimental) The value of the header with the given name in the request must not include the specified characters.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param regex The regex to test against.
     * @experimental
     */
    static valueDoesNotMatchRegex(headerName, regex) {
        return new HeaderMatchImpl(headerName, true, { regex });
    }
    /**
     * (experimental) The value of the header with the given name in the request must be in a range of values.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param start Match on values starting at and including this value.
     * @param end Match on values up to but not including this value.
     * @experimental
     */
    static valuesIsInRange(headerName, start, end) {
        return new HeaderMatchImpl(headerName, false, {
            range: {
                start,
                end,
            },
        });
    }
    /**
     * (experimental) The value of the header with the given name in the request must not be in a range of values.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param start Match on values starting at and including this value.
     * @param end Match on values up to but not including this value.
     * @experimental
     */
    static valuesIsNotInRange(headerName, start, end) {
        return new HeaderMatchImpl(headerName, true, {
            range: {
                start,
                end,
            },
        });
    }
}
exports.HttpHeaderMatch = HttpHeaderMatch;
_a = JSII_RTTI_SYMBOL_1;
HttpHeaderMatch[_a] = { fqn: "monocdk.aws_appmesh.HttpHeaderMatch", version: "1.106.1" };
class HeaderMatchImpl extends HttpHeaderMatch {
    constructor(headerName, invert, matchProperty) {
        super();
        this.headerName = headerName;
        this.invert = invert;
        this.matchProperty = matchProperty;
    }
    bind(_scope) {
        return {
            httpRouteHeader: {
                name: this.headerName,
                invert: this.invert,
                match: this.matchProperty,
            },
        };
    }
}
/**
 * (experimental) HTTP events on which to retry.
 *
 * @experimental
 */
var HttpRetryEvent;
(function (HttpRetryEvent) {
    HttpRetryEvent["SERVER_ERROR"] = "server-error";
    HttpRetryEvent["GATEWAY_ERROR"] = "gateway-error";
    HttpRetryEvent["CLIENT_ERROR"] = "client-error";
    HttpRetryEvent["STREAM_ERROR"] = "stream-error";
})(HttpRetryEvent = exports.HttpRetryEvent || (exports.HttpRetryEvent = {}));
/**
 * TCP events on which you may retry
 */
var TcpRetryEvent;
(function (TcpRetryEvent) {
    TcpRetryEvent["CONNECTION_ERROR"] = "connection-error";
})(TcpRetryEvent = exports.TcpRetryEvent || (exports.TcpRetryEvent = {}));
/**
 * (experimental) gRPC events.
 *
 * @experimental
 */
var GrpcRetryEvent;
(function (GrpcRetryEvent) {
    GrpcRetryEvent["CANCELLED"] = "cancelled";
    GrpcRetryEvent["DEADLINE_EXCEEDED"] = "deadline-exceeded";
    GrpcRetryEvent["INTERNAL_ERROR"] = "internal";
    GrpcRetryEvent["RESOURCE_EXHAUSTED"] = "resource-exhausted";
    GrpcRetryEvent["UNAVAILABLE"] = "unavailable";
})(GrpcRetryEvent = exports.GrpcRetryEvent || (exports.GrpcRetryEvent = {}));
/**
 * (experimental) Used to generate specs with different protocols for a RouteSpec.
 *
 * @experimental
 */
class RouteSpec {
    /**
     * (experimental) Creates an HTTP Based RouteSpec.
     *
     * @experimental
     */
    static http(options) {
        return new HttpRouteSpec(options, shared_interfaces_1.Protocol.HTTP);
    }
    /**
     * (experimental) Creates an HTTP2 Based RouteSpec.
     *
     * @experimental
     */
    static http2(options) {
        return new HttpRouteSpec(options, shared_interfaces_1.Protocol.HTTP2);
    }
    /**
     * (experimental) Creates a TCP Based RouteSpec.
     *
     * @experimental
     */
    static tcp(options) {
        return new TcpRouteSpec(options);
    }
    /**
     * (experimental) Creates a GRPC Based RouteSpec.
     *
     * @experimental
     */
    static grpc(options) {
        return new GrpcRouteSpec(options);
    }
}
exports.RouteSpec = RouteSpec;
_b = JSII_RTTI_SYMBOL_1;
RouteSpec[_b] = { fqn: "monocdk.aws_appmesh.RouteSpec", version: "1.106.1" };
class HttpRouteSpec extends RouteSpec {
    constructor(props, protocol) {
        var _c, _d;
        super();
        this.protocol = protocol;
        this.match = props.match;
        this.weightedTargets = props.weightedTargets;
        this.timeout = props.timeout;
        this.priority = props.priority;
        if (props.retryPolicy) {
            const httpRetryEvents = (_c = props.retryPolicy.httpRetryEvents) !== null && _c !== void 0 ? _c : [];
            const tcpRetryEvents = (_d = props.retryPolicy.tcpRetryEvents) !== null && _d !== void 0 ? _d : [];
            if (httpRetryEvents.length + tcpRetryEvents.length === 0) {
                throw new Error('You must specify one value for at least one of `httpRetryEvents` or `tcpRetryEvents`');
            }
            this.retryPolicy = {
                ...props.retryPolicy,
                httpRetryEvents: httpRetryEvents.length > 0 ? httpRetryEvents : undefined,
                tcpRetryEvents: tcpRetryEvents.length > 0 ? tcpRetryEvents : undefined,
            };
        }
    }
    bind(scope) {
        var _c, _d, _e, _f;
        const prefixPath = this.match ? this.match.prefixPath : '/';
        if (prefixPath[0] != '/') {
            throw new Error(`Prefix Path must start with \'/\', got: ${prefixPath}`);
        }
        const httpConfig = {
            action: {
                weightedTargets: renderWeightedTargets(this.weightedTargets),
            },
            match: {
                prefix: prefixPath,
                headers: (_d = (_c = this.match) === null || _c === void 0 ? void 0 : _c.headers) === null || _d === void 0 ? void 0 : _d.map(header => header.bind(scope).httpRouteHeader),
                method: (_e = this.match) === null || _e === void 0 ? void 0 : _e.method,
                scheme: (_f = this.match) === null || _f === void 0 ? void 0 : _f.protocol,
            },
            timeout: renderTimeout(this.timeout),
            retryPolicy: this.retryPolicy ? renderHttpRetryPolicy(this.retryPolicy) : undefined,
        };
        return {
            priority: this.priority,
            httpRouteSpec: this.protocol === shared_interfaces_1.Protocol.HTTP ? httpConfig : undefined,
            http2RouteSpec: this.protocol === shared_interfaces_1.Protocol.HTTP2 ? httpConfig : undefined,
        };
    }
}
class TcpRouteSpec extends RouteSpec {
    constructor(props) {
        super();
        this.weightedTargets = props.weightedTargets;
        this.timeout = props.timeout;
        this.priority = props.priority;
    }
    bind(_scope) {
        return {
            priority: this.priority,
            tcpRouteSpec: {
                action: {
                    weightedTargets: renderWeightedTargets(this.weightedTargets),
                },
                timeout: renderTimeout(this.timeout),
            },
        };
    }
}
class GrpcRouteSpec extends RouteSpec {
    constructor(props) {
        var _c, _d, _e;
        super();
        this.weightedTargets = props.weightedTargets;
        this.match = props.match;
        this.timeout = props.timeout;
        this.priority = props.priority;
        if (props.retryPolicy) {
            const grpcRetryEvents = (_c = props.retryPolicy.grpcRetryEvents) !== null && _c !== void 0 ? _c : [];
            const httpRetryEvents = (_d = props.retryPolicy.httpRetryEvents) !== null && _d !== void 0 ? _d : [];
            const tcpRetryEvents = (_e = props.retryPolicy.tcpRetryEvents) !== null && _e !== void 0 ? _e : [];
            if (grpcRetryEvents.length + httpRetryEvents.length + tcpRetryEvents.length === 0) {
                throw new Error('You must specify one value for at least one of `grpcRetryEvents`, `httpRetryEvents` or `tcpRetryEvents`');
            }
            this.retryPolicy = {
                ...props.retryPolicy,
                grpcRetryEvents: grpcRetryEvents.length > 0 ? grpcRetryEvents : undefined,
                httpRetryEvents: httpRetryEvents.length > 0 ? httpRetryEvents : undefined,
                tcpRetryEvents: tcpRetryEvents.length > 0 ? tcpRetryEvents : undefined,
            };
        }
    }
    bind(_scope) {
        return {
            priority: this.priority,
            grpcRouteSpec: {
                action: {
                    weightedTargets: renderWeightedTargets(this.weightedTargets),
                },
                match: {
                    serviceName: this.match.serviceName,
                },
                timeout: renderTimeout(this.timeout),
                retryPolicy: this.retryPolicy ? renderGrpcRetryPolicy(this.retryPolicy) : undefined,
            },
        };
    }
}
/**
* Utility method to add weighted route targets to an existing route
*/
function renderWeightedTargets(weightedTargets) {
    const renderedTargets = [];
    for (const t of weightedTargets) {
        renderedTargets.push({
            virtualNode: t.virtualNode.virtualNodeName,
            weight: t.weight || 1,
        });
    }
    return renderedTargets;
}
/**
 * Utility method to construct a route timeout object
 */
function renderTimeout(timeout) {
    return timeout
        ? {
            idle: (timeout === null || timeout === void 0 ? void 0 : timeout.idle) !== undefined
                ? {
                    unit: 'ms',
                    value: timeout === null || timeout === void 0 ? void 0 : timeout.idle.toMilliseconds(),
                }
                : undefined,
            perRequest: (timeout === null || timeout === void 0 ? void 0 : timeout.perRequest) !== undefined
                ? {
                    unit: 'ms',
                    value: timeout === null || timeout === void 0 ? void 0 : timeout.perRequest.toMilliseconds(),
                }
                : undefined,
        }
        : undefined;
}
function renderHttpRetryPolicy(retryPolicy) {
    return {
        maxRetries: retryPolicy.retryAttempts,
        perRetryTimeout: {
            unit: 'ms',
            value: retryPolicy.retryTimeout.toMilliseconds(),
        },
        httpRetryEvents: retryPolicy.httpRetryEvents,
        tcpRetryEvents: retryPolicy.tcpRetryEvents,
    };
}
function renderGrpcRetryPolicy(retryPolicy) {
    return {
        ...renderHttpRetryPolicy(retryPolicy),
        grpcRetryEvents: retryPolicy.grpcRetryEvents,
    };
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicm91dGUtc3BlYy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInJvdXRlLXNwZWMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFFQSwyREFBcUY7Ozs7OztBQXNEckYsSUFBWSxvQkFxQ1g7QUFyQ0QsV0FBWSxvQkFBb0I7SUFJNUIsbUNBQVcsQ0FBQTtJQUlYLHFDQUFhLENBQUE7SUFJYixxQ0FBYSxDQUFBO0lBSWIsbUNBQVcsQ0FBQTtJQUlYLHlDQUFpQixDQUFBO0lBSWpCLDJDQUFtQixDQUFBO0lBSW5CLDJDQUFtQixDQUFBO0lBSW5CLHVDQUFlLENBQUE7SUFJZix1Q0FBZSxDQUFBO0FBQ25CLENBQUMsRUFyQ1csb0JBQW9CLEdBQXBCLDRCQUFvQixLQUFwQiw0QkFBb0IsUUFxQy9COzs7Ozs7QUFJRCxJQUFZLGlCQVNYO0FBVEQsV0FBWSxpQkFBaUI7SUFJekIsa0NBQWEsQ0FBQTtJQUliLG9DQUFlLENBQUE7QUFDbkIsQ0FBQyxFQVRXLGlCQUFpQixHQUFqQix5QkFBaUIsS0FBakIseUJBQWlCLFFBUzVCOzs7Ozs7QUFhRCxNQUFzQixlQUFlOzs7Ozs7OztJQVFqQyxNQUFNLENBQUMsT0FBTyxDQUFDLFVBQWtCLEVBQUUsV0FBbUI7UUFDbEQsT0FBTyxJQUFJLGVBQWUsQ0FBQyxVQUFVLEVBQUUsS0FBSyxFQUFFLEVBQUUsS0FBSyxFQUFFLFdBQVcsRUFBRSxDQUFDLENBQUM7SUFDMUUsQ0FBQzs7Ozs7Ozs7SUFRRCxNQUFNLENBQUMsVUFBVSxDQUFDLFVBQWtCLEVBQUUsV0FBbUI7UUFDckQsT0FBTyxJQUFJLGVBQWUsQ0FBQyxVQUFVLEVBQUUsSUFBSSxFQUFFLEVBQUUsS0FBSyxFQUFFLFdBQVcsRUFBRSxDQUFDLENBQUM7SUFDekUsQ0FBQzs7Ozs7Ozs7SUFRRCxNQUFNLENBQUMsZUFBZSxDQUFDLFVBQWtCLEVBQUUsTUFBYztRQUNyRCxPQUFPLElBQUksZUFBZSxDQUFDLFVBQVUsRUFBRSxLQUFLLEVBQUUsRUFBRSxNQUFNLEVBQUUsQ0FBQyxDQUFDO0lBQzlELENBQUM7Ozs7Ozs7O0lBUUQsTUFBTSxDQUFDLHFCQUFxQixDQUFDLFVBQWtCLEVBQUUsTUFBYztRQUMzRCxPQUFPLElBQUksZUFBZSxDQUFDLFVBQVUsRUFBRSxJQUFJLEVBQUUsRUFBRSxNQUFNLEVBQUUsQ0FBQyxDQUFDO0lBQzdELENBQUM7Ozs7Ozs7O0lBUUQsTUFBTSxDQUFDLGFBQWEsQ0FBQyxVQUFrQixFQUFFLE1BQWM7UUFDbkQsT0FBTyxJQUFJLGVBQWUsQ0FBQyxVQUFVLEVBQUUsS0FBSyxFQUFFLEVBQUUsTUFBTSxFQUFFLENBQUMsQ0FBQztJQUM5RCxDQUFDOzs7Ozs7OztJQVFELE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxVQUFrQixFQUFFLE1BQWM7UUFDekQsT0FBTyxJQUFJLGVBQWUsQ0FBQyxVQUFVLEVBQUUsSUFBSSxFQUFFLEVBQUUsTUFBTSxFQUFFLENBQUMsQ0FBQztJQUM3RCxDQUFDOzs7Ozs7OztJQVFELE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQyxVQUFrQixFQUFFLEtBQWE7UUFDdEQsT0FBTyxJQUFJLGVBQWUsQ0FBQyxVQUFVLEVBQUUsS0FBSyxFQUFFLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQztJQUM3RCxDQUFDOzs7Ozs7OztJQVFELE1BQU0sQ0FBQyxzQkFBc0IsQ0FBQyxVQUFrQixFQUFFLEtBQWE7UUFDM0QsT0FBTyxJQUFJLGVBQWUsQ0FBQyxVQUFVLEVBQUUsSUFBSSxFQUFFLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQztJQUM1RCxDQUFDOzs7Ozs7Ozs7SUFTRCxNQUFNLENBQUMsZUFBZSxDQUFDLFVBQWtCLEVBQUUsS0FBYSxFQUFFLEdBQVc7UUFDakUsT0FBTyxJQUFJLGVBQWUsQ0FBQyxVQUFVLEVBQUUsS0FBSyxFQUFFO1lBQzFDLEtBQUssRUFBRTtnQkFDSCxLQUFLO2dCQUNMLEdBQUc7YUFDTjtTQUNKLENBQUMsQ0FBQztJQUNQLENBQUM7Ozs7Ozs7OztJQVNELE1BQU0sQ0FBQyxrQkFBa0IsQ0FBQyxVQUFrQixFQUFFLEtBQWEsRUFBRSxHQUFXO1FBQ3BFLE9BQU8sSUFBSSxlQUFlLENBQUMsVUFBVSxFQUFFLElBQUksRUFBRTtZQUN6QyxLQUFLLEVBQUU7Z0JBQ0gsS0FBSztnQkFDTCxHQUFHO2FBQ047U0FDSixDQUFDLENBQUM7SUFDUCxDQUFDOztBQWhITCwwQ0FxSEM7OztBQUNELE1BQU0sZUFBZ0IsU0FBUSxlQUFlO0lBQ3pDLFlBQTZCLFVBQWtCLEVBQW1CLE1BQWUsRUFBbUIsYUFBaUQ7UUFDakosS0FBSyxFQUFFLENBQUM7UUFEaUIsZUFBVSxHQUFWLFVBQVUsQ0FBUTtRQUFtQixXQUFNLEdBQU4sTUFBTSxDQUFTO1FBQW1CLGtCQUFhLEdBQWIsYUFBYSxDQUFvQztJQUVySixDQUFDO0lBQ0QsSUFBSSxDQUFDLE1BQWlCO1FBQ2xCLE9BQU87WUFDSCxlQUFlLEVBQUU7Z0JBQ2IsSUFBSSxFQUFFLElBQUksQ0FBQyxVQUFVO2dCQUNyQixNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU07Z0JBQ25CLEtBQUssRUFBRSxJQUFJLENBQUMsYUFBYTthQUM1QjtTQUNKLENBQUM7SUFDTixDQUFDO0NBQ0o7Ozs7OztBQWlGRCxJQUFZLGNBaUJYO0FBakJELFdBQVksY0FBYztJQUl0QiwrQ0FBNkIsQ0FBQTtJQUk3QixpREFBK0IsQ0FBQTtJQUkvQiwrQ0FBNkIsQ0FBQTtJQUk3QiwrQ0FBNkIsQ0FBQTtBQUNqQyxDQUFDLEVBakJXLGNBQWMsR0FBZCxzQkFBYyxLQUFkLHNCQUFjLFFBaUJ6QjtBQUNEOztHQUVHO0FBQ0gsSUFBWSxhQUtYO0FBTEQsV0FBWSxhQUFhO0lBSXJCLHNEQUFxQyxDQUFBO0FBQ3pDLENBQUMsRUFMVyxhQUFhLEdBQWIscUJBQWEsS0FBYixxQkFBYSxRQUt4Qjs7Ozs7O0FBc0RELElBQVksY0ErQlg7QUEvQkQsV0FBWSxjQUFjO0lBTXRCLHlDQUF1QixDQUFBO0lBTXZCLHlEQUF1QyxDQUFBO0lBTXZDLDZDQUEyQixDQUFBO0lBTTNCLDJEQUF5QyxDQUFBO0lBTXpDLDZDQUEyQixDQUFBO0FBQy9CLENBQUMsRUEvQlcsY0FBYyxHQUFkLHNCQUFjLEtBQWQsc0JBQWMsUUErQnpCOzs7Ozs7QUF3Q0QsTUFBc0IsU0FBUzs7Ozs7O0lBSXBCLE1BQU0sQ0FBQyxJQUFJLENBQUMsT0FBNkI7UUFDNUMsT0FBTyxJQUFJLGFBQWEsQ0FBQyxPQUFPLEVBQUUsNEJBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUNyRCxDQUFDOzs7Ozs7SUFLTSxNQUFNLENBQUMsS0FBSyxDQUFDLE9BQTZCO1FBQzdDLE9BQU8sSUFBSSxhQUFhLENBQUMsT0FBTyxFQUFFLDRCQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDdEQsQ0FBQzs7Ozs7O0lBSU0sTUFBTSxDQUFDLEdBQUcsQ0FBQyxPQUE0QjtRQUMxQyxPQUFPLElBQUksWUFBWSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0lBQ3JDLENBQUM7Ozs7OztJQUlNLE1BQU0sQ0FBQyxJQUFJLENBQUMsT0FBNkI7UUFDNUMsT0FBTyxJQUFJLGFBQWEsQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUN0QyxDQUFDOztBQXpCTCw4QkErQkM7OztBQUNELE1BQU0sYUFBYyxTQUFRLFNBQVM7SUFVakMsWUFBWSxLQUEyQixFQUFFLFFBQWtCOztRQUN2RCxLQUFLLEVBQUUsQ0FBQztRQUNSLElBQUksQ0FBQyxRQUFRLEdBQUcsUUFBUSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDLEtBQUssQ0FBQztRQUN6QixJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQyxlQUFlLENBQUM7UUFDN0MsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQzdCLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLEtBQUssQ0FBQyxXQUFXLEVBQUU7WUFDbkIsTUFBTSxlQUFlLFNBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQyxlQUFlLG1DQUFJLEVBQUUsQ0FBQztZQUNoRSxNQUFNLGNBQWMsU0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDLGNBQWMsbUNBQUksRUFBRSxDQUFDO1lBQzlELElBQUksZUFBZSxDQUFDLE1BQU0sR0FBRyxjQUFjLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtnQkFDdEQsTUFBTSxJQUFJLEtBQUssQ0FBQyxzRkFBc0YsQ0FBQyxDQUFDO2FBQzNHO1lBQ0QsSUFBSSxDQUFDLFdBQVcsR0FBRztnQkFDZixHQUFHLEtBQUssQ0FBQyxXQUFXO2dCQUNwQixlQUFlLEVBQUUsZUFBZSxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUMsU0FBUztnQkFDekUsY0FBYyxFQUFFLGNBQWMsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFNBQVM7YUFDekUsQ0FBQztTQUNMO0lBQ0wsQ0FBQztJQUNNLElBQUksQ0FBQyxLQUFnQjs7UUFDeEIsTUFBTSxVQUFVLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQztRQUM1RCxJQUFJLFVBQVUsQ0FBQyxDQUFDLENBQUMsSUFBSSxHQUFHLEVBQUU7WUFDdEIsTUFBTSxJQUFJLEtBQUssQ0FBQywyQ0FBMkMsVUFBVSxFQUFFLENBQUMsQ0FBQztTQUM1RTtRQUNELE1BQU0sVUFBVSxHQUErQjtZQUMzQyxNQUFNLEVBQUU7Z0JBQ0osZUFBZSxFQUFFLHFCQUFxQixDQUFDLElBQUksQ0FBQyxlQUFlLENBQUM7YUFDL0Q7WUFDRCxLQUFLLEVBQUU7Z0JBQ0gsTUFBTSxFQUFFLFVBQVU7Z0JBQ2xCLE9BQU8sY0FBRSxJQUFJLENBQUMsS0FBSywwQ0FBRSxPQUFPLDBDQUFFLEdBQUcsQ0FBQyxNQUFNLENBQUMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsZUFBZSxDQUFDO2dCQUMvRSxNQUFNLFFBQUUsSUFBSSxDQUFDLEtBQUssMENBQUUsTUFBTTtnQkFDMUIsTUFBTSxRQUFFLElBQUksQ0FBQyxLQUFLLDBDQUFFLFFBQVE7YUFDL0I7WUFDRCxPQUFPLEVBQUUsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUM7WUFDcEMsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLHFCQUFxQixDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUztTQUN0RixDQUFDO1FBQ0YsT0FBTztZQUNILFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixhQUFhLEVBQUUsSUFBSSxDQUFDLFFBQVEsS0FBSyw0QkFBUSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxTQUFTO1lBQ3ZFLGNBQWMsRUFBRSxJQUFJLENBQUMsUUFBUSxLQUFLLDRCQUFRLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLFNBQVM7U0FDNUUsQ0FBQztJQUNOLENBQUM7Q0FDSjtBQUNELE1BQU0sWUFBYSxTQUFRLFNBQVM7SUFhaEMsWUFBWSxLQUEwQjtRQUNsQyxLQUFLLEVBQUUsQ0FBQztRQUNSLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztRQUM3QyxJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7UUFDN0IsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO0lBQ25DLENBQUM7SUFDTSxJQUFJLENBQUMsTUFBaUI7UUFDekIsT0FBTztZQUNILFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixZQUFZLEVBQUU7Z0JBQ1YsTUFBTSxFQUFFO29CQUNKLGVBQWUsRUFBRSxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDO2lCQUMvRDtnQkFDRCxPQUFPLEVBQUUsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUM7YUFDdkM7U0FDSixDQUFDO0lBQ04sQ0FBQztDQUNKO0FBQ0QsTUFBTSxhQUFjLFNBQVEsU0FBUztJQVlqQyxZQUFZLEtBQTJCOztRQUNuQyxLQUFLLEVBQUUsQ0FBQztRQUNSLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztRQUM3QyxJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQyxLQUFLLENBQUM7UUFDekIsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQzdCLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLEtBQUssQ0FBQyxXQUFXLEVBQUU7WUFDbkIsTUFBTSxlQUFlLFNBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQyxlQUFlLG1DQUFJLEVBQUUsQ0FBQztZQUNoRSxNQUFNLGVBQWUsU0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDLGVBQWUsbUNBQUksRUFBRSxDQUFDO1lBQ2hFLE1BQU0sY0FBYyxTQUFHLEtBQUssQ0FBQyxXQUFXLENBQUMsY0FBYyxtQ0FBSSxFQUFFLENBQUM7WUFDOUQsSUFBSSxlQUFlLENBQUMsTUFBTSxHQUFHLGVBQWUsQ0FBQyxNQUFNLEdBQUcsY0FBYyxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUU7Z0JBQy9FLE1BQU0sSUFBSSxLQUFLLENBQUMseUdBQXlHLENBQUMsQ0FBQzthQUM5SDtZQUNELElBQUksQ0FBQyxXQUFXLEdBQUc7Z0JBQ2YsR0FBRyxLQUFLLENBQUMsV0FBVztnQkFDcEIsZUFBZSxFQUFFLGVBQWUsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDLFNBQVM7Z0JBQ3pFLGVBQWUsRUFBRSxlQUFlLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQyxTQUFTO2dCQUN6RSxjQUFjLEVBQUUsY0FBYyxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsU0FBUzthQUN6RSxDQUFDO1NBQ0w7SUFDTCxDQUFDO0lBQ00sSUFBSSxDQUFDLE1BQWlCO1FBQ3pCLE9BQU87WUFDSCxRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIsYUFBYSxFQUFFO2dCQUNYLE1BQU0sRUFBRTtvQkFDSixlQUFlLEVBQUUscUJBQXFCLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQztpQkFDL0Q7Z0JBQ0QsS0FBSyxFQUFFO29CQUNILFdBQVcsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVc7aUJBQ3RDO2dCQUNELE9BQU8sRUFBRSxhQUFhLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQztnQkFDcEMsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLHFCQUFxQixDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUzthQUN0RjtTQUNKLENBQUM7SUFDTixDQUFDO0NBQ0o7QUFDRDs7RUFFRTtBQUNGLFNBQVMscUJBQXFCLENBQUMsZUFBaUM7SUFDNUQsTUFBTSxlQUFlLEdBQXNDLEVBQUUsQ0FBQztJQUM5RCxLQUFLLE1BQU0sQ0FBQyxJQUFJLGVBQWUsRUFBRTtRQUM3QixlQUFlLENBQUMsSUFBSSxDQUFDO1lBQ2pCLFdBQVcsRUFBRSxDQUFDLENBQUMsV0FBVyxDQUFDLGVBQWU7WUFDMUMsTUFBTSxFQUFFLENBQUMsQ0FBQyxNQUFNLElBQUksQ0FBQztTQUN4QixDQUFDLENBQUM7S0FDTjtJQUNELE9BQU8sZUFBZSxDQUFDO0FBQzNCLENBQUM7QUFDRDs7R0FFRztBQUNILFNBQVMsYUFBYSxDQUFDLE9BQXFCO0lBQ3hDLE9BQU8sT0FBTztRQUNWLENBQUMsQ0FBQztZQUNFLElBQUksRUFBRSxDQUFBLE9BQU8sYUFBUCxPQUFPLHVCQUFQLE9BQU8sQ0FBRSxJQUFJLE1BQUssU0FBUztnQkFDN0IsQ0FBQyxDQUFDO29CQUNFLElBQUksRUFBRSxJQUFJO29CQUNWLEtBQUssRUFBRSxPQUFPLGFBQVAsT0FBTyx1QkFBUCxPQUFPLENBQUUsSUFBSSxDQUFDLGNBQWMsRUFBRTtpQkFDeEM7Z0JBQ0QsQ0FBQyxDQUFDLFNBQVM7WUFDZixVQUFVLEVBQUUsQ0FBQSxPQUFPLGFBQVAsT0FBTyx1QkFBUCxPQUFPLENBQUUsVUFBVSxNQUFLLFNBQVM7Z0JBQ3pDLENBQUMsQ0FBQztvQkFDRSxJQUFJLEVBQUUsSUFBSTtvQkFDVixLQUFLLEVBQUUsT0FBTyxhQUFQLE9BQU8sdUJBQVAsT0FBTyxDQUFFLFVBQVUsQ0FBQyxjQUFjLEVBQUU7aUJBQzlDO2dCQUNELENBQUMsQ0FBQyxTQUFTO1NBQ2xCO1FBQ0QsQ0FBQyxDQUFDLFNBQVMsQ0FBQztBQUNwQixDQUFDO0FBQ0QsU0FBUyxxQkFBcUIsQ0FBQyxXQUE0QjtJQUN2RCxPQUFPO1FBQ0gsVUFBVSxFQUFFLFdBQVcsQ0FBQyxhQUFhO1FBQ3JDLGVBQWUsRUFBRTtZQUNiLElBQUksRUFBRSxJQUFJO1lBQ1YsS0FBSyxFQUFFLFdBQVcsQ0FBQyxZQUFZLENBQUMsY0FBYyxFQUFFO1NBQ25EO1FBQ0QsZUFBZSxFQUFFLFdBQVcsQ0FBQyxlQUFlO1FBQzVDLGNBQWMsRUFBRSxXQUFXLENBQUMsY0FBYztLQUM3QyxDQUFDO0FBQ04sQ0FBQztBQUNELFNBQVMscUJBQXFCLENBQUMsV0FBNEI7SUFDdkQsT0FBTztRQUNILEdBQUcscUJBQXFCLENBQUMsV0FBVyxDQUFDO1FBQ3JDLGVBQWUsRUFBRSxXQUFXLENBQUMsZUFBZTtLQUMvQyxDQUFDO0FBQ04sQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tIFwiLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbmltcG9ydCB7IENmblJvdXRlIH0gZnJvbSAnLi9hcHBtZXNoLmdlbmVyYXRlZCc7XG5pbXBvcnQgeyBIdHRwVGltZW91dCwgR3JwY1RpbWVvdXQsIFByb3RvY29sLCBUY3BUaW1lb3V0IH0gZnJvbSAnLi9zaGFyZWQtaW50ZXJmYWNlcyc7XG5pbXBvcnQgeyBJVmlydHVhbE5vZGUgfSBmcm9tICcuL3ZpcnR1YWwtbm9kZSc7XG4vLyBrZWVwIHRoaXMgaW1wb3J0IHNlcGFyYXRlIGZyb20gb3RoZXIgaW1wb3J0cyB0byByZWR1Y2UgY2hhbmNlIGZvciBtZXJnZSBjb25mbGljdHMgd2l0aCB2Mi1tYWluXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgbm8tZHVwbGljYXRlLWltcG9ydHMsIGltcG9ydC9vcmRlclxuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSBcIi4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBXZWlnaHRlZFRhcmdldCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgdmlydHVhbE5vZGU6IElWaXJ0dWFsTm9kZTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSB3ZWlnaHQ/OiBudW1iZXI7XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSHR0cFJvdXRlTWF0Y2gge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IHByZWZpeFBhdGg6IHN0cmluZztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgaGVhZGVycz86IEh0dHBIZWFkZXJNYXRjaFtdO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBtZXRob2Q/OiBIdHRwUm91dGVNYXRjaE1ldGhvZDtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgcHJvdG9jb2w/OiBIdHRwUm91dGVQcm90b2NvbDtcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgZW51bSBIdHRwUm91dGVNYXRjaE1ldGhvZCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgR0VUID0gJ0dFVCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIEhFQUQgPSAnSEVBRCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIFBPU1QgPSAnUE9TVCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgUFVUID0gJ1BVVCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgREVMRVRFID0gJ0RFTEVURScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIENPTk5FQ1QgPSAnQ09OTkVDVCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIE9QVElPTlMgPSAnT1BUSU9OUycsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBUUkFDRSA9ICdUUkFDRScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBQQVRDSCA9ICdQQVRDSCdcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBlbnVtIEh0dHBSb3V0ZVByb3RvY29sIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIEhUVFAgPSAnaHR0cCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgSFRUUFMgPSAnaHR0cHMnXG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSHR0cEhlYWRlck1hdGNoQ29uZmlnIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IGh0dHBSb3V0ZUhlYWRlcjogQ2ZuUm91dGUuSHR0cFJvdXRlSGVhZGVyUHJvcGVydHk7XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgSHR0cEhlYWRlck1hdGNoIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgc3RhdGljIHZhbHVlSXMoaGVhZGVyTmFtZTogc3RyaW5nLCBoZWFkZXJWYWx1ZTogc3RyaW5nKTogSHR0cEhlYWRlck1hdGNoIHtcbiAgICAgICAgcmV0dXJuIG5ldyBIZWFkZXJNYXRjaEltcGwoaGVhZGVyTmFtZSwgZmFsc2UsIHsgZXhhY3Q6IGhlYWRlclZhbHVlIH0pO1xuICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHN0YXRpYyB2YWx1ZUlzTm90KGhlYWRlck5hbWU6IHN0cmluZywgaGVhZGVyVmFsdWU6IHN0cmluZyk6IEh0dHBIZWFkZXJNYXRjaCB7XG4gICAgICAgIHJldHVybiBuZXcgSGVhZGVyTWF0Y2hJbXBsKGhlYWRlck5hbWUsIHRydWUsIHsgZXhhY3Q6IGhlYWRlclZhbHVlIH0pO1xuICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHN0YXRpYyB2YWx1ZVN0YXJ0c1dpdGgoaGVhZGVyTmFtZTogc3RyaW5nLCBwcmVmaXg6IHN0cmluZyk6IEh0dHBIZWFkZXJNYXRjaCB7XG4gICAgICAgIHJldHVybiBuZXcgSGVhZGVyTWF0Y2hJbXBsKGhlYWRlck5hbWUsIGZhbHNlLCB7IHByZWZpeCB9KTtcbiAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgc3RhdGljIHZhbHVlRG9lc05vdFN0YXJ0V2l0aChoZWFkZXJOYW1lOiBzdHJpbmcsIHByZWZpeDogc3RyaW5nKTogSHR0cEhlYWRlck1hdGNoIHtcbiAgICAgICAgcmV0dXJuIG5ldyBIZWFkZXJNYXRjaEltcGwoaGVhZGVyTmFtZSwgdHJ1ZSwgeyBwcmVmaXggfSk7XG4gICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHN0YXRpYyB2YWx1ZUVuZHNXaXRoKGhlYWRlck5hbWU6IHN0cmluZywgc3VmZml4OiBzdHJpbmcpOiBIdHRwSGVhZGVyTWF0Y2gge1xuICAgICAgICByZXR1cm4gbmV3IEhlYWRlck1hdGNoSW1wbChoZWFkZXJOYW1lLCBmYWxzZSwgeyBzdWZmaXggfSk7XG4gICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBzdGF0aWMgdmFsdWVEb2VzTm90RW5kV2l0aChoZWFkZXJOYW1lOiBzdHJpbmcsIHN1ZmZpeDogc3RyaW5nKTogSHR0cEhlYWRlck1hdGNoIHtcbiAgICAgICAgcmV0dXJuIG5ldyBIZWFkZXJNYXRjaEltcGwoaGVhZGVyTmFtZSwgdHJ1ZSwgeyBzdWZmaXggfSk7XG4gICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHN0YXRpYyB2YWx1ZU1hdGNoZXNSZWdleChoZWFkZXJOYW1lOiBzdHJpbmcsIHJlZ2V4OiBzdHJpbmcpOiBIdHRwSGVhZGVyTWF0Y2gge1xuICAgICAgICByZXR1cm4gbmV3IEhlYWRlck1hdGNoSW1wbChoZWFkZXJOYW1lLCBmYWxzZSwgeyByZWdleCB9KTtcbiAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHN0YXRpYyB2YWx1ZURvZXNOb3RNYXRjaFJlZ2V4KGhlYWRlck5hbWU6IHN0cmluZywgcmVnZXg6IHN0cmluZyk6IEh0dHBIZWFkZXJNYXRjaCB7XG4gICAgICAgIHJldHVybiBuZXcgSGVhZGVyTWF0Y2hJbXBsKGhlYWRlck5hbWUsIHRydWUsIHsgcmVnZXggfSk7XG4gICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHN0YXRpYyB2YWx1ZXNJc0luUmFuZ2UoaGVhZGVyTmFtZTogc3RyaW5nLCBzdGFydDogbnVtYmVyLCBlbmQ6IG51bWJlcik6IEh0dHBIZWFkZXJNYXRjaCB7XG4gICAgICAgIHJldHVybiBuZXcgSGVhZGVyTWF0Y2hJbXBsKGhlYWRlck5hbWUsIGZhbHNlLCB7XG4gICAgICAgICAgICByYW5nZToge1xuICAgICAgICAgICAgICAgIHN0YXJ0LFxuICAgICAgICAgICAgICAgIGVuZCxcbiAgICAgICAgICAgIH0sXG4gICAgICAgIH0pO1xuICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgc3RhdGljIHZhbHVlc0lzTm90SW5SYW5nZShoZWFkZXJOYW1lOiBzdHJpbmcsIHN0YXJ0OiBudW1iZXIsIGVuZDogbnVtYmVyKTogSHR0cEhlYWRlck1hdGNoIHtcbiAgICAgICAgcmV0dXJuIG5ldyBIZWFkZXJNYXRjaEltcGwoaGVhZGVyTmFtZSwgdHJ1ZSwge1xuICAgICAgICAgICAgcmFuZ2U6IHtcbiAgICAgICAgICAgICAgICBzdGFydCxcbiAgICAgICAgICAgICAgICBlbmQsXG4gICAgICAgICAgICB9LFxuICAgICAgICB9KTtcbiAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIGFic3RyYWN0IGJpbmQoc2NvcGU6IENvbnN0cnVjdCk6IEh0dHBIZWFkZXJNYXRjaENvbmZpZztcbn1cbmNsYXNzIEhlYWRlck1hdGNoSW1wbCBleHRlbmRzIEh0dHBIZWFkZXJNYXRjaCB7XG4gICAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBoZWFkZXJOYW1lOiBzdHJpbmcsIHByaXZhdGUgcmVhZG9ubHkgaW52ZXJ0OiBib29sZWFuLCBwcml2YXRlIHJlYWRvbmx5IG1hdGNoUHJvcGVydHk6IENmblJvdXRlLkhlYWRlck1hdGNoTWV0aG9kUHJvcGVydHkpIHtcbiAgICAgICAgc3VwZXIoKTtcbiAgICB9XG4gICAgYmluZChfc2NvcGU6IENvbnN0cnVjdCk6IEh0dHBIZWFkZXJNYXRjaENvbmZpZyB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBodHRwUm91dGVIZWFkZXI6IHtcbiAgICAgICAgICAgICAgICBuYW1lOiB0aGlzLmhlYWRlck5hbWUsXG4gICAgICAgICAgICAgICAgaW52ZXJ0OiB0aGlzLmludmVydCxcbiAgICAgICAgICAgICAgICBtYXRjaDogdGhpcy5tYXRjaFByb3BlcnR5LFxuICAgICAgICAgICAgfSxcbiAgICAgICAgfTtcbiAgICB9XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgR3JwY1JvdXRlTWF0Y2gge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgc2VydmljZU5hbWU6IHN0cmluZztcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFJvdXRlU3BlY09wdGlvbnNCYXNlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBwcmlvcml0eT86IG51bWJlcjtcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSHR0cFJvdXRlU3BlY09wdGlvbnMgZXh0ZW5kcyBSb3V0ZVNwZWNPcHRpb25zQmFzZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBtYXRjaD86IEh0dHBSb3V0ZU1hdGNoO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IHdlaWdodGVkVGFyZ2V0czogV2VpZ2h0ZWRUYXJnZXRbXTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IHRpbWVvdXQ/OiBIdHRwVGltZW91dDtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgcmV0cnlQb2xpY3k/OiBIdHRwUmV0cnlQb2xpY3k7XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEh0dHBSZXRyeVBvbGljeSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgaHR0cFJldHJ5RXZlbnRzPzogSHR0cFJldHJ5RXZlbnRbXTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgcmV0cnlBdHRlbXB0czogbnVtYmVyO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgcmV0cnlUaW1lb3V0OiBjZGsuRHVyYXRpb247XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IHRjcFJldHJ5RXZlbnRzPzogVGNwUmV0cnlFdmVudFtdO1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBlbnVtIEh0dHBSZXRyeUV2ZW50IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgU0VSVkVSX0VSUk9SID0gJ3NlcnZlci1lcnJvcicsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgR0FURVdBWV9FUlJPUiA9ICdnYXRld2F5LWVycm9yJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBDTElFTlRfRVJST1IgPSAnY2xpZW50LWVycm9yJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBTVFJFQU1fRVJST1IgPSAnc3RyZWFtLWVycm9yJ1xufVxuLyoqXG4gKiBUQ1AgZXZlbnRzIG9uIHdoaWNoIHlvdSBtYXkgcmV0cnlcbiAqL1xuZXhwb3J0IGVudW0gVGNwUmV0cnlFdmVudCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIENPTk5FQ1RJT05fRVJST1IgPSAnY29ubmVjdGlvbi1lcnJvcidcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFRjcFJvdXRlU3BlY09wdGlvbnMgZXh0ZW5kcyBSb3V0ZVNwZWNPcHRpb25zQmFzZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgd2VpZ2h0ZWRUYXJnZXRzOiBXZWlnaHRlZFRhcmdldFtdO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSB0aW1lb3V0PzogVGNwVGltZW91dDtcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBHcnBjUm91dGVTcGVjT3B0aW9ucyBleHRlbmRzIFJvdXRlU3BlY09wdGlvbnNCYXNlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgbWF0Y2g6IEdycGNSb3V0ZU1hdGNoO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgdGltZW91dD86IEdycGNUaW1lb3V0O1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IHdlaWdodGVkVGFyZ2V0czogV2VpZ2h0ZWRUYXJnZXRbXTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgcmV0cnlQb2xpY3k/OiBHcnBjUmV0cnlQb2xpY3k7XG59XG4gICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgR3JwY1JldHJ5UG9saWN5IGV4dGVuZHMgSHR0cFJldHJ5UG9saWN5IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgZ3JwY1JldHJ5RXZlbnRzPzogR3JwY1JldHJ5RXZlbnRbXTtcbn1cbiAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBlbnVtIEdycGNSZXRyeUV2ZW50IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIENBTkNFTExFRCA9ICdjYW5jZWxsZWQnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIERFQURMSU5FX0VYQ0VFREVEID0gJ2RlYWRsaW5lLWV4Y2VlZGVkJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgSU5URVJOQUxfRVJST1IgPSAnaW50ZXJuYWwnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgUkVTT1VSQ0VfRVhIQVVTVEVEID0gJ3Jlc291cmNlLWV4aGF1c3RlZCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIFVOQVZBSUxBQkxFID0gJ3VuYXZhaWxhYmxlJ1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFJvdXRlU3BlY0NvbmZpZyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBodHRwUm91dGVTcGVjPzogQ2ZuUm91dGUuSHR0cFJvdXRlUHJvcGVydHk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IGh0dHAyUm91dGVTcGVjPzogQ2ZuUm91dGUuSHR0cFJvdXRlUHJvcGVydHk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IGdycGNSb3V0ZVNwZWM/OiBDZm5Sb3V0ZS5HcnBjUm91dGVQcm9wZXJ0eTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IHRjcFJvdXRlU3BlYz86IENmblJvdXRlLlRjcFJvdXRlUHJvcGVydHk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgcHJpb3JpdHk/OiBudW1iZXI7XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGFic3RyYWN0IGNsYXNzIFJvdXRlU3BlYyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIGh0dHAob3B0aW9uczogSHR0cFJvdXRlU3BlY09wdGlvbnMpOiBSb3V0ZVNwZWMge1xuICAgICAgICByZXR1cm4gbmV3IEh0dHBSb3V0ZVNwZWMob3B0aW9ucywgUHJvdG9jb2wuSFRUUCk7XG4gICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIGh0dHAyKG9wdGlvbnM6IEh0dHBSb3V0ZVNwZWNPcHRpb25zKTogUm91dGVTcGVjIHtcbiAgICAgICAgcmV0dXJuIG5ldyBIdHRwUm91dGVTcGVjKG9wdGlvbnMsIFByb3RvY29sLkhUVFAyKTtcbiAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyB0Y3Aob3B0aW9uczogVGNwUm91dGVTcGVjT3B0aW9ucyk6IFJvdXRlU3BlYyB7XG4gICAgICAgIHJldHVybiBuZXcgVGNwUm91dGVTcGVjKG9wdGlvbnMpO1xuICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyBncnBjKG9wdGlvbnM6IEdycGNSb3V0ZVNwZWNPcHRpb25zKTogUm91dGVTcGVjIHtcbiAgICAgICAgcmV0dXJuIG5ldyBHcnBjUm91dGVTcGVjKG9wdGlvbnMpO1xuICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgYWJzdHJhY3QgYmluZChzY29wZTogQ29uc3RydWN0KTogUm91dGVTcGVjQ29uZmlnO1xufVxuY2xhc3MgSHR0cFJvdXRlU3BlYyBleHRlbmRzIFJvdXRlU3BlYyB7XG4gICAgcHVibGljIHJlYWRvbmx5IHByaW9yaXR5PzogbnVtYmVyO1xuICAgIHB1YmxpYyByZWFkb25seSBwcm90b2NvbDogUHJvdG9jb2w7XG4gICAgcHVibGljIHJlYWRvbmx5IG1hdGNoPzogSHR0cFJvdXRlTWF0Y2g7XG4gICAgcHVibGljIHJlYWRvbmx5IHRpbWVvdXQ/OiBIdHRwVGltZW91dDtcbiAgICBwdWJsaWMgcmVhZG9ubHkgd2VpZ2h0ZWRUYXJnZXRzOiBXZWlnaHRlZFRhcmdldFtdO1xuICAgIC8qKlxuICAgICAqIFRoZSByZXRyeSBwb2xpY3lcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgcmV0cnlQb2xpY3k/OiBIdHRwUmV0cnlQb2xpY3k7XG4gICAgY29uc3RydWN0b3IocHJvcHM6IEh0dHBSb3V0ZVNwZWNPcHRpb25zLCBwcm90b2NvbDogUHJvdG9jb2wpIHtcbiAgICAgICAgc3VwZXIoKTtcbiAgICAgICAgdGhpcy5wcm90b2NvbCA9IHByb3RvY29sO1xuICAgICAgICB0aGlzLm1hdGNoID0gcHJvcHMubWF0Y2g7XG4gICAgICAgIHRoaXMud2VpZ2h0ZWRUYXJnZXRzID0gcHJvcHMud2VpZ2h0ZWRUYXJnZXRzO1xuICAgICAgICB0aGlzLnRpbWVvdXQgPSBwcm9wcy50aW1lb3V0O1xuICAgICAgICB0aGlzLnByaW9yaXR5ID0gcHJvcHMucHJpb3JpdHk7XG4gICAgICAgIGlmIChwcm9wcy5yZXRyeVBvbGljeSkge1xuICAgICAgICAgICAgY29uc3QgaHR0cFJldHJ5RXZlbnRzID0gcHJvcHMucmV0cnlQb2xpY3kuaHR0cFJldHJ5RXZlbnRzID8/IFtdO1xuICAgICAgICAgICAgY29uc3QgdGNwUmV0cnlFdmVudHMgPSBwcm9wcy5yZXRyeVBvbGljeS50Y3BSZXRyeUV2ZW50cyA/PyBbXTtcbiAgICAgICAgICAgIGlmIChodHRwUmV0cnlFdmVudHMubGVuZ3RoICsgdGNwUmV0cnlFdmVudHMubGVuZ3RoID09PSAwKSB7XG4gICAgICAgICAgICAgICAgdGhyb3cgbmV3IEVycm9yKCdZb3UgbXVzdCBzcGVjaWZ5IG9uZSB2YWx1ZSBmb3IgYXQgbGVhc3Qgb25lIG9mIGBodHRwUmV0cnlFdmVudHNgIG9yIGB0Y3BSZXRyeUV2ZW50c2AnKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHRoaXMucmV0cnlQb2xpY3kgPSB7XG4gICAgICAgICAgICAgICAgLi4ucHJvcHMucmV0cnlQb2xpY3ksXG4gICAgICAgICAgICAgICAgaHR0cFJldHJ5RXZlbnRzOiBodHRwUmV0cnlFdmVudHMubGVuZ3RoID4gMCA/IGh0dHBSZXRyeUV2ZW50cyA6IHVuZGVmaW5lZCxcbiAgICAgICAgICAgICAgICB0Y3BSZXRyeUV2ZW50czogdGNwUmV0cnlFdmVudHMubGVuZ3RoID4gMCA/IHRjcFJldHJ5RXZlbnRzIDogdW5kZWZpbmVkLFxuICAgICAgICAgICAgfTtcbiAgICAgICAgfVxuICAgIH1cbiAgICBwdWJsaWMgYmluZChzY29wZTogQ29uc3RydWN0KTogUm91dGVTcGVjQ29uZmlnIHtcbiAgICAgICAgY29uc3QgcHJlZml4UGF0aCA9IHRoaXMubWF0Y2ggPyB0aGlzLm1hdGNoLnByZWZpeFBhdGggOiAnLyc7XG4gICAgICAgIGlmIChwcmVmaXhQYXRoWzBdICE9ICcvJykge1xuICAgICAgICAgICAgdGhyb3cgbmV3IEVycm9yKGBQcmVmaXggUGF0aCBtdXN0IHN0YXJ0IHdpdGggXFwnL1xcJywgZ290OiAke3ByZWZpeFBhdGh9YCk7XG4gICAgICAgIH1cbiAgICAgICAgY29uc3QgaHR0cENvbmZpZzogQ2ZuUm91dGUuSHR0cFJvdXRlUHJvcGVydHkgPSB7XG4gICAgICAgICAgICBhY3Rpb246IHtcbiAgICAgICAgICAgICAgICB3ZWlnaHRlZFRhcmdldHM6IHJlbmRlcldlaWdodGVkVGFyZ2V0cyh0aGlzLndlaWdodGVkVGFyZ2V0cyksXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgbWF0Y2g6IHtcbiAgICAgICAgICAgICAgICBwcmVmaXg6IHByZWZpeFBhdGgsXG4gICAgICAgICAgICAgICAgaGVhZGVyczogdGhpcy5tYXRjaD8uaGVhZGVycz8ubWFwKGhlYWRlciA9PiBoZWFkZXIuYmluZChzY29wZSkuaHR0cFJvdXRlSGVhZGVyKSxcbiAgICAgICAgICAgICAgICBtZXRob2Q6IHRoaXMubWF0Y2g/Lm1ldGhvZCxcbiAgICAgICAgICAgICAgICBzY2hlbWU6IHRoaXMubWF0Y2g/LnByb3RvY29sLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIHRpbWVvdXQ6IHJlbmRlclRpbWVvdXQodGhpcy50aW1lb3V0KSxcbiAgICAgICAgICAgIHJldHJ5UG9saWN5OiB0aGlzLnJldHJ5UG9saWN5ID8gcmVuZGVySHR0cFJldHJ5UG9saWN5KHRoaXMucmV0cnlQb2xpY3kpIDogdW5kZWZpbmVkLFxuICAgICAgICB9O1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgcHJpb3JpdHk6IHRoaXMucHJpb3JpdHksXG4gICAgICAgICAgICBodHRwUm91dGVTcGVjOiB0aGlzLnByb3RvY29sID09PSBQcm90b2NvbC5IVFRQID8gaHR0cENvbmZpZyA6IHVuZGVmaW5lZCxcbiAgICAgICAgICAgIGh0dHAyUm91dGVTcGVjOiB0aGlzLnByb3RvY29sID09PSBQcm90b2NvbC5IVFRQMiA/IGh0dHBDb25maWcgOiB1bmRlZmluZWQsXG4gICAgICAgIH07XG4gICAgfVxufVxuY2xhc3MgVGNwUm91dGVTcGVjIGV4dGVuZHMgUm91dGVTcGVjIHtcbiAgICAvKipcbiAgICAgKiBUaGUgcHJpb3JpdHkgZm9yIHRoZSByb3V0ZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgcHJpb3JpdHk/OiBudW1iZXI7XG4gICAgLypcbiAgICAgKiBMaXN0IG9mIHRhcmdldHMgdGhhdCB0cmFmZmljIGlzIHJvdXRlZCB0byB3aGVuIGEgcmVxdWVzdCBtYXRjaGVzIHRoZSByb3V0ZVxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSB3ZWlnaHRlZFRhcmdldHM6IFdlaWdodGVkVGFyZ2V0W107XG4gICAgLyoqXG4gICAgICogVGhlIGNyaXRlcmlhIGZvciBkZXRlcm1pbmluZyBhIHRpbWVvdXQgY29uZmlndXJhdGlvblxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSB0aW1lb3V0PzogVGNwVGltZW91dDtcbiAgICBjb25zdHJ1Y3Rvcihwcm9wczogVGNwUm91dGVTcGVjT3B0aW9ucykge1xuICAgICAgICBzdXBlcigpO1xuICAgICAgICB0aGlzLndlaWdodGVkVGFyZ2V0cyA9IHByb3BzLndlaWdodGVkVGFyZ2V0cztcbiAgICAgICAgdGhpcy50aW1lb3V0ID0gcHJvcHMudGltZW91dDtcbiAgICAgICAgdGhpcy5wcmlvcml0eSA9IHByb3BzLnByaW9yaXR5O1xuICAgIH1cbiAgICBwdWJsaWMgYmluZChfc2NvcGU6IENvbnN0cnVjdCk6IFJvdXRlU3BlY0NvbmZpZyB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBwcmlvcml0eTogdGhpcy5wcmlvcml0eSxcbiAgICAgICAgICAgIHRjcFJvdXRlU3BlYzoge1xuICAgICAgICAgICAgICAgIGFjdGlvbjoge1xuICAgICAgICAgICAgICAgICAgICB3ZWlnaHRlZFRhcmdldHM6IHJlbmRlcldlaWdodGVkVGFyZ2V0cyh0aGlzLndlaWdodGVkVGFyZ2V0cyksXG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICB0aW1lb3V0OiByZW5kZXJUaW1lb3V0KHRoaXMudGltZW91dCksXG4gICAgICAgICAgICB9LFxuICAgICAgICB9O1xuICAgIH1cbn1cbmNsYXNzIEdycGNSb3V0ZVNwZWMgZXh0ZW5kcyBSb3V0ZVNwZWMge1xuICAgIC8qKlxuICAgICAqIFRoZSBwcmlvcml0eSBmb3IgdGhlIHJvdXRlLlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBwcmlvcml0eT86IG51bWJlcjtcbiAgICBwdWJsaWMgcmVhZG9ubHkgd2VpZ2h0ZWRUYXJnZXRzOiBXZWlnaHRlZFRhcmdldFtdO1xuICAgIHB1YmxpYyByZWFkb25seSBtYXRjaDogR3JwY1JvdXRlTWF0Y2g7XG4gICAgcHVibGljIHJlYWRvbmx5IHRpbWVvdXQ/OiBHcnBjVGltZW91dDtcbiAgICAvKipcbiAgICAgKiBUaGUgcmV0cnkgcG9saWN5LlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSByZXRyeVBvbGljeT86IEdycGNSZXRyeVBvbGljeTtcbiAgICBjb25zdHJ1Y3Rvcihwcm9wczogR3JwY1JvdXRlU3BlY09wdGlvbnMpIHtcbiAgICAgICAgc3VwZXIoKTtcbiAgICAgICAgdGhpcy53ZWlnaHRlZFRhcmdldHMgPSBwcm9wcy53ZWlnaHRlZFRhcmdldHM7XG4gICAgICAgIHRoaXMubWF0Y2ggPSBwcm9wcy5tYXRjaDtcbiAgICAgICAgdGhpcy50aW1lb3V0ID0gcHJvcHMudGltZW91dDtcbiAgICAgICAgdGhpcy5wcmlvcml0eSA9IHByb3BzLnByaW9yaXR5O1xuICAgICAgICBpZiAocHJvcHMucmV0cnlQb2xpY3kpIHtcbiAgICAgICAgICAgIGNvbnN0IGdycGNSZXRyeUV2ZW50cyA9IHByb3BzLnJldHJ5UG9saWN5LmdycGNSZXRyeUV2ZW50cyA/PyBbXTtcbiAgICAgICAgICAgIGNvbnN0IGh0dHBSZXRyeUV2ZW50cyA9IHByb3BzLnJldHJ5UG9saWN5Lmh0dHBSZXRyeUV2ZW50cyA/PyBbXTtcbiAgICAgICAgICAgIGNvbnN0IHRjcFJldHJ5RXZlbnRzID0gcHJvcHMucmV0cnlQb2xpY3kudGNwUmV0cnlFdmVudHMgPz8gW107XG4gICAgICAgICAgICBpZiAoZ3JwY1JldHJ5RXZlbnRzLmxlbmd0aCArIGh0dHBSZXRyeUV2ZW50cy5sZW5ndGggKyB0Y3BSZXRyeUV2ZW50cy5sZW5ndGggPT09IDApIHtcbiAgICAgICAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ1lvdSBtdXN0IHNwZWNpZnkgb25lIHZhbHVlIGZvciBhdCBsZWFzdCBvbmUgb2YgYGdycGNSZXRyeUV2ZW50c2AsIGBodHRwUmV0cnlFdmVudHNgIG9yIGB0Y3BSZXRyeUV2ZW50c2AnKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHRoaXMucmV0cnlQb2xpY3kgPSB7XG4gICAgICAgICAgICAgICAgLi4ucHJvcHMucmV0cnlQb2xpY3ksXG4gICAgICAgICAgICAgICAgZ3JwY1JldHJ5RXZlbnRzOiBncnBjUmV0cnlFdmVudHMubGVuZ3RoID4gMCA/IGdycGNSZXRyeUV2ZW50cyA6IHVuZGVmaW5lZCxcbiAgICAgICAgICAgICAgICBodHRwUmV0cnlFdmVudHM6IGh0dHBSZXRyeUV2ZW50cy5sZW5ndGggPiAwID8gaHR0cFJldHJ5RXZlbnRzIDogdW5kZWZpbmVkLFxuICAgICAgICAgICAgICAgIHRjcFJldHJ5RXZlbnRzOiB0Y3BSZXRyeUV2ZW50cy5sZW5ndGggPiAwID8gdGNwUmV0cnlFdmVudHMgOiB1bmRlZmluZWQsXG4gICAgICAgICAgICB9O1xuICAgICAgICB9XG4gICAgfVxuICAgIHB1YmxpYyBiaW5kKF9zY29wZTogQ29uc3RydWN0KTogUm91dGVTcGVjQ29uZmlnIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIHByaW9yaXR5OiB0aGlzLnByaW9yaXR5LFxuICAgICAgICAgICAgZ3JwY1JvdXRlU3BlYzoge1xuICAgICAgICAgICAgICAgIGFjdGlvbjoge1xuICAgICAgICAgICAgICAgICAgICB3ZWlnaHRlZFRhcmdldHM6IHJlbmRlcldlaWdodGVkVGFyZ2V0cyh0aGlzLndlaWdodGVkVGFyZ2V0cyksXG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICBtYXRjaDoge1xuICAgICAgICAgICAgICAgICAgICBzZXJ2aWNlTmFtZTogdGhpcy5tYXRjaC5zZXJ2aWNlTmFtZSxcbiAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgIHRpbWVvdXQ6IHJlbmRlclRpbWVvdXQodGhpcy50aW1lb3V0KSxcbiAgICAgICAgICAgICAgICByZXRyeVBvbGljeTogdGhpcy5yZXRyeVBvbGljeSA/IHJlbmRlckdycGNSZXRyeVBvbGljeSh0aGlzLnJldHJ5UG9saWN5KSA6IHVuZGVmaW5lZCxcbiAgICAgICAgICAgIH0sXG4gICAgICAgIH07XG4gICAgfVxufVxuLyoqXG4qIFV0aWxpdHkgbWV0aG9kIHRvIGFkZCB3ZWlnaHRlZCByb3V0ZSB0YXJnZXRzIHRvIGFuIGV4aXN0aW5nIHJvdXRlXG4qL1xuZnVuY3Rpb24gcmVuZGVyV2VpZ2h0ZWRUYXJnZXRzKHdlaWdodGVkVGFyZ2V0czogV2VpZ2h0ZWRUYXJnZXRbXSk6IENmblJvdXRlLldlaWdodGVkVGFyZ2V0UHJvcGVydHlbXSB7XG4gICAgY29uc3QgcmVuZGVyZWRUYXJnZXRzOiBDZm5Sb3V0ZS5XZWlnaHRlZFRhcmdldFByb3BlcnR5W10gPSBbXTtcbiAgICBmb3IgKGNvbnN0IHQgb2Ygd2VpZ2h0ZWRUYXJnZXRzKSB7XG4gICAgICAgIHJlbmRlcmVkVGFyZ2V0cy5wdXNoKHtcbiAgICAgICAgICAgIHZpcnR1YWxOb2RlOiB0LnZpcnR1YWxOb2RlLnZpcnR1YWxOb2RlTmFtZSxcbiAgICAgICAgICAgIHdlaWdodDogdC53ZWlnaHQgfHwgMSxcbiAgICAgICAgfSk7XG4gICAgfVxuICAgIHJldHVybiByZW5kZXJlZFRhcmdldHM7XG59XG4vKipcbiAqIFV0aWxpdHkgbWV0aG9kIHRvIGNvbnN0cnVjdCBhIHJvdXRlIHRpbWVvdXQgb2JqZWN0XG4gKi9cbmZ1bmN0aW9uIHJlbmRlclRpbWVvdXQodGltZW91dD86IEh0dHBUaW1lb3V0KTogQ2ZuUm91dGUuSHR0cFRpbWVvdXRQcm9wZXJ0eSB8IHVuZGVmaW5lZCB7XG4gICAgcmV0dXJuIHRpbWVvdXRcbiAgICAgICAgPyB7XG4gICAgICAgICAgICBpZGxlOiB0aW1lb3V0Py5pZGxlICE9PSB1bmRlZmluZWRcbiAgICAgICAgICAgICAgICA/IHtcbiAgICAgICAgICAgICAgICAgICAgdW5pdDogJ21zJyxcbiAgICAgICAgICAgICAgICAgICAgdmFsdWU6IHRpbWVvdXQ/LmlkbGUudG9NaWxsaXNlY29uZHMoKSxcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgOiB1bmRlZmluZWQsXG4gICAgICAgICAgICBwZXJSZXF1ZXN0OiB0aW1lb3V0Py5wZXJSZXF1ZXN0ICE9PSB1bmRlZmluZWRcbiAgICAgICAgICAgICAgICA/IHtcbiAgICAgICAgICAgICAgICAgICAgdW5pdDogJ21zJyxcbiAgICAgICAgICAgICAgICAgICAgdmFsdWU6IHRpbWVvdXQ/LnBlclJlcXVlc3QudG9NaWxsaXNlY29uZHMoKSxcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgOiB1bmRlZmluZWQsXG4gICAgICAgIH1cbiAgICAgICAgOiB1bmRlZmluZWQ7XG59XG5mdW5jdGlvbiByZW5kZXJIdHRwUmV0cnlQb2xpY3kocmV0cnlQb2xpY3k6IEh0dHBSZXRyeVBvbGljeSk6IENmblJvdXRlLkh0dHBSZXRyeVBvbGljeVByb3BlcnR5IHtcbiAgICByZXR1cm4ge1xuICAgICAgICBtYXhSZXRyaWVzOiByZXRyeVBvbGljeS5yZXRyeUF0dGVtcHRzLFxuICAgICAgICBwZXJSZXRyeVRpbWVvdXQ6IHtcbiAgICAgICAgICAgIHVuaXQ6ICdtcycsXG4gICAgICAgICAgICB2YWx1ZTogcmV0cnlQb2xpY3kucmV0cnlUaW1lb3V0LnRvTWlsbGlzZWNvbmRzKCksXG4gICAgICAgIH0sXG4gICAgICAgIGh0dHBSZXRyeUV2ZW50czogcmV0cnlQb2xpY3kuaHR0cFJldHJ5RXZlbnRzLFxuICAgICAgICB0Y3BSZXRyeUV2ZW50czogcmV0cnlQb2xpY3kudGNwUmV0cnlFdmVudHMsXG4gICAgfTtcbn1cbmZ1bmN0aW9uIHJlbmRlckdycGNSZXRyeVBvbGljeShyZXRyeVBvbGljeTogR3JwY1JldHJ5UG9saWN5KTogQ2ZuUm91dGUuR3JwY1JldHJ5UG9saWN5UHJvcGVydHkge1xuICAgIHJldHVybiB7XG4gICAgICAgIC4uLnJlbmRlckh0dHBSZXRyeVBvbGljeShyZXRyeVBvbGljeSksXG4gICAgICAgIGdycGNSZXRyeUV2ZW50czogcmV0cnlQb2xpY3kuZ3JwY1JldHJ5RXZlbnRzLFxuICAgIH07XG59XG4iXX0=