"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HealthCheck = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * (experimental) Contains static factory methods for creating health checks for different protocols.
 *
 * @experimental
 */
class HealthCheck {
    /**
     * (experimental) Construct a HTTP health check.
     *
     * @experimental
     */
    static http(options = {}) {
        return new HealthCheckImpl(shared_interfaces_1.Protocol.HTTP, options.healthyThreshold, options.unhealthyThreshold, options.interval, options.timeout, options.path);
    }
    /**
     * (experimental) Construct a HTTP2 health check.
     *
     * @experimental
     */
    static http2(options = {}) {
        return new HealthCheckImpl(shared_interfaces_1.Protocol.HTTP2, options.healthyThreshold, options.unhealthyThreshold, options.interval, options.timeout, options.path);
    }
    /**
     * (experimental) Construct a GRPC health check.
     *
     * @experimental
     */
    static grpc(options = {}) {
        return new HealthCheckImpl(shared_interfaces_1.Protocol.GRPC, options.healthyThreshold, options.unhealthyThreshold, options.interval, options.timeout);
    }
    /**
     * (experimental) Construct a TCP health check.
     *
     * @experimental
     */
    static tcp(options = {}) {
        return new HealthCheckImpl(shared_interfaces_1.Protocol.TCP, options.healthyThreshold, options.unhealthyThreshold, options.interval, options.timeout);
    }
}
exports.HealthCheck = HealthCheck;
_a = JSII_RTTI_SYMBOL_1;
HealthCheck[_a] = { fqn: "monocdk.aws_appmesh.HealthCheck", version: "1.106.1" };
class HealthCheckImpl extends HealthCheck {
    constructor(protocol, healthyThreshold = 2, unhealthyThreshold = 2, interval = cdk.Duration.seconds(5), timeout = cdk.Duration.seconds(2), path) {
        super();
        this.protocol = protocol;
        this.healthyThreshold = healthyThreshold;
        this.unhealthyThreshold = unhealthyThreshold;
        this.interval = interval;
        this.timeout = timeout;
        this.path = path;
        if (healthyThreshold < 2 || healthyThreshold > 10) {
            throw new Error('healthyThreshold must be between 2 and 10');
        }
        if (unhealthyThreshold < 2 || unhealthyThreshold > 10) {
            throw new Error('unhealthyThreshold must be between 2 and 10');
        }
        if (interval.toMilliseconds() < 5000 || interval.toMilliseconds() > 300000) {
            throw new Error('interval must be between 5 seconds and 300 seconds');
        }
        if (timeout.toMilliseconds() < 2000 || timeout.toMilliseconds() > 60000) {
            throw new Error('timeout must be between 2 seconds and 60 seconds');
        }
        // Default to / for HTTP Health Checks
        if (path === undefined && (protocol === shared_interfaces_1.Protocol.HTTP || protocol === shared_interfaces_1.Protocol.HTTP2)) {
            this.path = '/';
        }
    }
    bind(_scope, options) {
        return {
            virtualNodeHealthCheck: {
                protocol: this.protocol,
                healthyThreshold: this.healthyThreshold,
                unhealthyThreshold: this.unhealthyThreshold,
                intervalMillis: this.interval.toMilliseconds(),
                timeoutMillis: this.timeout.toMilliseconds(),
                path: this.path,
                port: options.defaultPort,
            },
            virtualGatewayHealthCheck: {
                protocol: this.protocol,
                healthyThreshold: this.healthyThreshold,
                unhealthyThreshold: this.unhealthyThreshold,
                intervalMillis: this.interval.toMilliseconds(),
                timeoutMillis: this.timeout.toMilliseconds(),
                path: this.path,
                port: options.defaultPort,
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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