import * as cdk from "../../core";
import { CfnVirtualGateway, CfnVirtualNode } from './appmesh.generated';
import { Construct } from "../../core";
/**
 * Properties used to define healthchecks.
 */
interface HealthCheckCommonOptions {
    /**
     * (experimental) The number of consecutive successful health checks that must occur before declaring listener healthy.
     *
     * @default 2
     * @experimental
     */
    readonly healthyThreshold?: number;
    /**
     * (experimental) The time period between each health check execution.
     *
     * @default Duration.seconds(5)
     * @experimental
     */
    readonly interval?: cdk.Duration;
    /**
     * (experimental) The amount of time to wait when receiving a response from the health check.
     *
     * @default Duration.seconds(2)
     * @experimental
     */
    readonly timeout?: cdk.Duration;
    /**
     * (experimental) The number of consecutive failed health checks that must occur before declaring a listener unhealthy.
     *
     * @default - 2
     * @experimental
     */
    readonly unhealthyThreshold?: number;
}
/**
 * (experimental) Properties used to define HTTP Based healthchecks.
 *
 * @experimental
 */
export interface HttpHealthCheckOptions extends HealthCheckCommonOptions {
    /**
     * (experimental) The destination path for the health check request.
     *
     * @default /
     * @experimental
     */
    readonly path?: string;
}
/**
 * (experimental) Properties used to define GRPC Based healthchecks.
 *
 * @experimental
 */
export interface GrpcHealthCheckOptions extends HealthCheckCommonOptions {
}
/**
 * (experimental) Properties used to define TCP Based healthchecks.
 *
 * @experimental
 */
export interface TcpHealthCheckOptions extends HealthCheckCommonOptions {
}
/**
 * (experimental) All Properties for Health Checks for mesh endpoints.
 *
 * @experimental
 */
export interface HealthCheckConfig {
    /**
     * (experimental) VirtualNode CFN configuration for Health Checks.
     *
     * @default - no health checks
     * @experimental
     */
    readonly virtualNodeHealthCheck?: CfnVirtualNode.HealthCheckProperty;
    /**
     * (experimental) VirtualGateway CFN configuration for Health Checks.
     *
     * @default - no health checks
     * @experimental
     */
    readonly virtualGatewayHealthCheck?: CfnVirtualGateway.VirtualGatewayHealthCheckPolicyProperty;
}
/**
 * (experimental) Options used for creating the Health Check object.
 *
 * @experimental
 */
export interface HealthCheckBindOptions {
    /**
     * (experimental) Port for Health Check interface.
     *
     * @default - no default port is provided
     * @experimental
     */
    readonly defaultPort?: number;
}
/**
 * (experimental) Contains static factory methods for creating health checks for different protocols.
 *
 * @experimental
 */
export declare abstract class HealthCheck {
    /**
     * (experimental) Construct a HTTP health check.
     *
     * @experimental
     */
    static http(options?: HttpHealthCheckOptions): HealthCheck;
    /**
     * (experimental) Construct a HTTP2 health check.
     *
     * @experimental
     */
    static http2(options?: HttpHealthCheckOptions): HealthCheck;
    /**
     * (experimental) Construct a GRPC health check.
     *
     * @experimental
     */
    static grpc(options?: GrpcHealthCheckOptions): HealthCheck;
    /**
     * (experimental) Construct a TCP health check.
     *
     * @experimental
     */
    static tcp(options?: TcpHealthCheckOptions): HealthCheck;
    /**
     * (experimental) Called when the AccessLog type is initialized.
     *
     * Can be used to enforce
     * mutual exclusivity with future properties
     *
     * @experimental
     */
    abstract bind(scope: Construct, options: HealthCheckBindOptions): HealthCheckConfig;
}
export {};
