import * as cdk from "../../core";
import { Construct } from 'constructs';
import { GatewayRouteSpec } from './gateway-route-spec';
import { IVirtualGateway } from './virtual-gateway';
/**
 * (experimental) Interface for which all GatewayRoute based classes MUST implement.
 *
 * @experimental
 */
export interface IGatewayRoute extends cdk.IResource {
    /**
     * (experimental) The name of the GatewayRoute.
     *
     * @experimental
     * @attribute true
     */
    readonly gatewayRouteName: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) for the GatewayRoute.
     *
     * @experimental
     * @attribute true
     */
    readonly gatewayRouteArn: string;
    /**
     * (experimental) The VirtualGateway the GatewayRoute belongs to.
     *
     * @experimental
     */
    readonly virtualGateway: IVirtualGateway;
}
/**
 * (experimental) Basic configuration properties for a GatewayRoute.
 *
 * @experimental
 */
export interface GatewayRouteBaseProps {
    /**
     * (experimental) The name of the GatewayRoute.
     *
     * @default - an automatically generated name
     * @experimental
     */
    readonly gatewayRouteName?: string;
    /**
     * (experimental) What protocol the route uses.
     *
     * @experimental
     */
    readonly routeSpec: GatewayRouteSpec;
}
/**
 * (experimental) Properties to define a new GatewayRoute.
 *
 * @experimental
 */
export interface GatewayRouteProps extends GatewayRouteBaseProps {
    /**
     * (experimental) The VirtualGateway this GatewayRoute is associated with.
     *
     * @experimental
     */
    readonly virtualGateway: IVirtualGateway;
}
/**
 * (experimental) GatewayRoute represents a new or existing gateway route attached to a VirtualGateway and Mesh.
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html
 * @experimental
 */
export declare class GatewayRoute extends cdk.Resource implements IGatewayRoute {
    /**
     * (experimental) Import an existing GatewayRoute given an ARN.
     *
     * @experimental
     */
    static fromGatewayRouteArn(scope: Construct, id: string, gatewayRouteArn: string): IGatewayRoute;
    /**
     * (experimental) Import an existing GatewayRoute given attributes.
     *
     * @experimental
     */
    static fromGatewayRouteAttributes(scope: Construct, id: string, attrs: GatewayRouteAttributes): IGatewayRoute;
    /**
     * (experimental) The name of the GatewayRoute.
     *
     * @experimental
     */
    readonly gatewayRouteName: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) for the GatewayRoute.
     *
     * @experimental
     */
    readonly gatewayRouteArn: string;
    /**
     * (experimental) The VirtualGateway this GatewayRoute is a part of.
     *
     * @experimental
     */
    readonly virtualGateway: IVirtualGateway;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: GatewayRouteProps);
}
/**
 * (experimental) Interface with properties necessary to import a reusable GatewayRoute.
 *
 * @experimental
 */
export interface GatewayRouteAttributes {
    /**
     * (experimental) The name of the GatewayRoute.
     *
     * @experimental
     */
    readonly gatewayRouteName: string;
    /**
     * (experimental) The VirtualGateway this GatewayRoute is associated with.
     *
     * @experimental
     */
    readonly virtualGateway: IVirtualGateway;
}
