"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GatewayRouteSpec = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * (experimental) Used to generate specs with different protocols for a GatewayRoute.
 *
 * @experimental
 */
class GatewayRouteSpec {
    /**
     * (experimental) Creates an HTTP Based GatewayRoute.
     *
     * @param options - no http gateway route.
     * @experimental
     */
    static http(options) {
        return new HttpGatewayRouteSpec(options, shared_interfaces_1.Protocol.HTTP);
    }
    /**
     * (experimental) Creates an HTTP2 Based GatewayRoute.
     *
     * @param options - no http2 gateway route.
     * @experimental
     */
    static http2(options) {
        return new HttpGatewayRouteSpec(options, shared_interfaces_1.Protocol.HTTP2);
    }
    /**
     * (experimental) Creates an GRPC Based GatewayRoute.
     *
     * @param options - no grpc gateway route.
     * @experimental
     */
    static grpc(options) {
        return new GrpcGatewayRouteSpec(options);
    }
}
exports.GatewayRouteSpec = GatewayRouteSpec;
_a = JSII_RTTI_SYMBOL_1;
GatewayRouteSpec[_a] = { fqn: "monocdk.aws_appmesh.GatewayRouteSpec", version: "1.106.1" };
class HttpGatewayRouteSpec extends GatewayRouteSpec {
    constructor(options, protocol) {
        super();
        this.routeTarget = options.routeTarget;
        this.routeType = protocol;
        this.match = options.match;
    }
    bind(_scope) {
        const prefixPath = this.match ? this.match.prefixPath : '/';
        if (prefixPath[0] != '/') {
            throw new Error(`Prefix Path must start with \'/\', got: ${prefixPath}`);
        }
        const httpConfig = {
            match: {
                prefix: prefixPath,
            },
            action: {
                target: {
                    virtualService: {
                        virtualServiceName: this.routeTarget.virtualServiceName,
                    },
                },
            },
        };
        return {
            httpSpecConfig: this.routeType === shared_interfaces_1.Protocol.HTTP ? httpConfig : undefined,
            http2SpecConfig: this.routeType === shared_interfaces_1.Protocol.HTTP2 ? httpConfig : undefined,
        };
    }
}
class GrpcGatewayRouteSpec extends GatewayRouteSpec {
    constructor(options) {
        super();
        this.match = options.match;
        this.routeTarget = options.routeTarget;
    }
    bind(_scope) {
        return {
            grpcSpecConfig: {
                action: {
                    target: {
                        virtualService: {
                            virtualServiceName: this.routeTarget.virtualServiceName,
                        },
                    },
                },
                match: {
                    serviceName: this.match.serviceName,
                },
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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