import { CfnGatewayRoute } from './appmesh.generated';
import { IVirtualService } from './virtual-service';
import { Construct } from "../../core";
/**
 * (experimental) The criterion for determining a request match for this GatewayRoute.
 *
 * @experimental
 */
export interface HttpGatewayRouteMatch {
    /**
     * (experimental) Specifies the path to match requests with.
     *
     * This parameter must always start with /, which by itself matches all requests to the virtual service name.
     * You can also match for path-based routing of requests. For example, if your virtual service name is my-service.local
     * and you want the route to match requests to my-service.local/metrics, your prefix should be /metrics.
     *
     * @experimental
     */
    readonly prefixPath: string;
}
/**
 * (experimental) The criterion for determining a request match for this GatewayRoute.
 *
 * @experimental
 */
export interface GrpcGatewayRouteMatch {
    /**
     * (experimental) The fully qualified domain name for the service to match from the request.
     *
     * @experimental
     */
    readonly serviceName: string;
}
/**
 * (experimental) Properties specific for HTTP Based GatewayRoutes.
 *
 * @experimental
 */
export interface HttpGatewayRouteSpecOptions {
    /**
     * (experimental) The criterion for determining a request match for this GatewayRoute.
     *
     * @default - matches on '/'
     * @experimental
     */
    readonly match?: HttpGatewayRouteMatch;
    /**
     * (experimental) The VirtualService this GatewayRoute directs traffic to.
     *
     * @experimental
     */
    readonly routeTarget: IVirtualService;
}
/**
 * (experimental) Properties specific for a GRPC GatewayRoute.
 *
 * @experimental
 */
export interface GrpcGatewayRouteSpecOptions {
    /**
     * (experimental) The criterion for determining a request match for this GatewayRoute.
     *
     * @experimental
     */
    readonly match: GrpcGatewayRouteMatch;
    /**
     * (experimental) The VirtualService this GatewayRoute directs traffic to.
     *
     * @experimental
     */
    readonly routeTarget: IVirtualService;
}
/**
 * (experimental) All Properties for GatewayRoute Specs.
 *
 * @experimental
 */
export interface GatewayRouteSpecConfig {
    /**
     * (experimental) The spec for an http gateway route.
     *
     * @default - no http spec
     * @experimental
     */
    readonly httpSpecConfig?: CfnGatewayRoute.HttpGatewayRouteProperty;
    /**
     * (experimental) The spec for an http2 gateway route.
     *
     * @default - no http2 spec
     * @experimental
     */
    readonly http2SpecConfig?: CfnGatewayRoute.HttpGatewayRouteProperty;
    /**
     * (experimental) The spec for a grpc gateway route.
     *
     * @default - no grpc spec
     * @experimental
     */
    readonly grpcSpecConfig?: CfnGatewayRoute.GrpcGatewayRouteProperty;
}
/**
 * (experimental) Used to generate specs with different protocols for a GatewayRoute.
 *
 * @experimental
 */
export declare abstract class GatewayRouteSpec {
    /**
     * (experimental) Creates an HTTP Based GatewayRoute.
     *
     * @param options - no http gateway route.
     * @experimental
     */
    static http(options: HttpGatewayRouteSpecOptions): GatewayRouteSpec;
    /**
     * (experimental) Creates an HTTP2 Based GatewayRoute.
     *
     * @param options - no http2 gateway route.
     * @experimental
     */
    static http2(options: HttpGatewayRouteSpecOptions): GatewayRouteSpec;
    /**
     * (experimental) Creates an GRPC Based GatewayRoute.
     *
     * @param options - no grpc gateway route.
     * @experimental
     */
    static grpc(options: GrpcGatewayRouteSpecOptions): GatewayRouteSpec;
    /**
     * (experimental) Called when the GatewayRouteSpec type is initialized.
     *
     * Can be used to enforce
     * mutual exclusivity with future properties
     *
     * @experimental
     */
    abstract bind(scope: Construct): GatewayRouteSpecConfig;
}
