"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientPolicy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
var CertificateType;
(function (CertificateType) {
    CertificateType["ACMPCA"] = "acm";
    CertificateType["FILE"] = "file";
})(CertificateType || (CertificateType = {}));
/**
 * (experimental) Defines the TLS validation context trust.
 *
 * @experimental
 */
class ClientPolicy {
    /**
     * (experimental) Tells envoy where to fetch the validation context from.
     *
     * @experimental
     */
    static fileTrust(props) {
        return new ClientPolicyImpl(props.ports, CertificateType.FILE, props.certificateChain, undefined);
    }
    /**
     * (experimental) TLS validation context trust for ACM Private Certificate Authority (CA).
     *
     * @experimental
     */
    static acmTrust(props) {
        return new ClientPolicyImpl(props.ports, CertificateType.ACMPCA, undefined, props.certificateAuthorities);
    }
}
exports.ClientPolicy = ClientPolicy;
_a = JSII_RTTI_SYMBOL_1;
ClientPolicy[_a] = { fqn: "monocdk.aws_appmesh.ClientPolicy", version: "1.106.1" };
class ClientPolicyImpl extends ClientPolicy {
    constructor(ports, certificateType, certificateChain, certificateAuthorityArns) {
        super();
        this.ports = ports;
        this.certificateType = certificateType;
        this.certificateChain = certificateChain;
        this.certificateAuthorityArns = certificateAuthorityArns;
    }
    bind(_scope) {
        var _b, _c;
        if (this.certificateType === CertificateType.ACMPCA && ((_b = this.certificateAuthorityArns) === null || _b === void 0 ? void 0 : _b.map(certificateArn => certificateArn.certificateAuthorityArn).length) === 0) {
            throw new Error('You must provide at least one Certificate Authority when creating an ACM Trust ClientPolicy');
        }
        else {
            return {
                clientPolicy: {
                    tls: {
                        ports: this.ports,
                        validation: {
                            trust: {
                                [this.certificateType]: this.certificateType === CertificateType.FILE
                                    ? {
                                        certificateChain: this.certificateChain,
                                    }
                                    : {
                                        certificateAuthorityArns: (_c = this.certificateAuthorityArns) === null || _c === void 0 ? void 0 : _c.map(certificateArn => certificateArn.certificateAuthorityArn),
                                    },
                            },
                        },
                    },
                },
            };
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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