import * as acmpca from "../../aws-acmpca";
import { CfnVirtualNode } from './appmesh.generated';
import { Construct } from "../../core";
/**
 * (experimental) Properties of TLS Client Policy.
 *
 * @experimental
 */
export interface ClientPolicyConfig {
    /**
     * (experimental) Represents single Client Policy property.
     *
     * @experimental
     */
    readonly clientPolicy: CfnVirtualNode.ClientPolicyProperty;
}
/**
 * (experimental) Represents the property needed to define a Client Policy.
 *
 * @experimental
 */
export interface ClientPolicyOptions {
    /**
     * (experimental) TLS is enforced on the ports specified here.
     *
     * If no ports are specified, TLS will be enforced on all the ports.
     *
     * @default - none
     * @experimental
     */
    readonly ports?: number[];
}
/**
 * (experimental) ACM Trust Properties.
 *
 * @experimental
 */
export interface AcmTrustOptions extends ClientPolicyOptions {
    /**
     * (experimental) Contains information for your private certificate authority.
     *
     * @experimental
     */
    readonly certificateAuthorities: acmpca.ICertificateAuthority[];
}
/**
 * (experimental) File Trust Properties.
 *
 * @experimental
 */
export interface FileTrustOptions extends ClientPolicyOptions {
    /**
     * (experimental) Path to the Certificate Chain file on the file system where the Envoy is deployed.
     *
     * @experimental
     */
    readonly certificateChain: string;
}
/**
 * (experimental) Defines the TLS validation context trust.
 *
 * @experimental
 */
export declare abstract class ClientPolicy {
    /**
     * (experimental) Tells envoy where to fetch the validation context from.
     *
     * @experimental
     */
    static fileTrust(props: FileTrustOptions): ClientPolicy;
    /**
     * (experimental) TLS validation context trust for ACM Private Certificate Authority (CA).
     *
     * @experimental
     */
    static acmTrust(props: AcmTrustOptions): ClientPolicy;
    /**
     * (experimental) Returns Trust context based on trust type.
     *
     * @experimental
     */
    abstract bind(scope: Construct): ClientPolicyConfig;
}
