import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::ApplicationInsights::Application`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 */
export interface CfnApplicationProps {
    /**
     * `AWS::ApplicationInsights::Application.ResourceGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-resourcegroupname
     */
    readonly resourceGroupName: string;
    /**
     * `AWS::ApplicationInsights::Application.AutoConfigurationEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-autoconfigurationenabled
     */
    readonly autoConfigurationEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::ApplicationInsights::Application.ComponentMonitoringSettings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-componentmonitoringsettings
     */
    readonly componentMonitoringSettings?: Array<CfnApplication.ComponentMonitoringSettingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ApplicationInsights::Application.CustomComponents`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-customcomponents
     */
    readonly customComponents?: Array<CfnApplication.CustomComponentProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ApplicationInsights::Application.CWEMonitorEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-cwemonitorenabled
     */
    readonly cweMonitorEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::ApplicationInsights::Application.LogPatternSets`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-logpatternsets
     */
    readonly logPatternSets?: Array<CfnApplication.LogPatternSetProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ApplicationInsights::Application.OpsCenterEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-opscenterenabled
     */
    readonly opsCenterEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::ApplicationInsights::Application.OpsItemSNSTopicArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-opsitemsnstopicarn
     */
    readonly opsItemSnsTopicArn?: string;
    /**
     * `AWS::ApplicationInsights::Application.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 */
export declare class CfnApplication extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApplicationInsights::Application";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApplication;
    /**
     * @external
     * @cloudformationAttribute ApplicationARN
     */
    readonly attrApplicationArn: string;
    /**
     * `AWS::ApplicationInsights::Application.ResourceGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-resourcegroupname
     */
    resourceGroupName: string;
    /**
     * `AWS::ApplicationInsights::Application.AutoConfigurationEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-autoconfigurationenabled
     */
    autoConfigurationEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ApplicationInsights::Application.ComponentMonitoringSettings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-componentmonitoringsettings
     */
    componentMonitoringSettings: Array<CfnApplication.ComponentMonitoringSettingProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ApplicationInsights::Application.CustomComponents`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-customcomponents
     */
    customComponents: Array<CfnApplication.CustomComponentProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ApplicationInsights::Application.CWEMonitorEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-cwemonitorenabled
     */
    cweMonitorEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ApplicationInsights::Application.LogPatternSets`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-logpatternsets
     */
    logPatternSets: Array<CfnApplication.LogPatternSetProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ApplicationInsights::Application.OpsCenterEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-opscenterenabled
     */
    opsCenterEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ApplicationInsights::Application.OpsItemSNSTopicArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-opsitemsnstopicarn
     */
    opsItemSnsTopicArn: string | undefined;
    /**
     * `AWS::ApplicationInsights::Application.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ApplicationInsights::Application`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarm.html
     */
    interface AlarmProperty {
        /**
         * `CfnApplication.AlarmProperty.AlarmName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarm.html#cfn-applicationinsights-application-alarm-alarmname
         */
        readonly alarmName: string;
        /**
         * `CfnApplication.AlarmProperty.Severity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarm.html#cfn-applicationinsights-application-alarm-severity
         */
        readonly severity?: string;
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarmmetric.html
     */
    interface AlarmMetricProperty {
        /**
         * `CfnApplication.AlarmMetricProperty.AlarmMetricName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarmmetric.html#cfn-applicationinsights-application-alarmmetric-alarmmetricname
         */
        readonly alarmMetricName: string;
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentconfiguration.html
     */
    interface ComponentConfigurationProperty {
        /**
         * `CfnApplication.ComponentConfigurationProperty.ConfigurationDetails`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentconfiguration.html#cfn-applicationinsights-application-componentconfiguration-configurationdetails
         */
        readonly configurationDetails?: CfnApplication.ConfigurationDetailsProperty | cdk.IResolvable;
        /**
         * `CfnApplication.ComponentConfigurationProperty.SubComponentTypeConfigurations`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentconfiguration.html#cfn-applicationinsights-application-componentconfiguration-subcomponenttypeconfigurations
         */
        readonly subComponentTypeConfigurations?: Array<CfnApplication.SubComponentTypeConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html
     */
    interface ComponentMonitoringSettingProperty {
        /**
         * `CfnApplication.ComponentMonitoringSettingProperty.ComponentARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-componentarn
         */
        readonly componentArn?: string;
        /**
         * `CfnApplication.ComponentMonitoringSettingProperty.ComponentConfigurationMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-componentconfigurationmode
         */
        readonly componentConfigurationMode?: string;
        /**
         * `CfnApplication.ComponentMonitoringSettingProperty.ComponentName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-componentname
         */
        readonly componentName?: string;
        /**
         * `CfnApplication.ComponentMonitoringSettingProperty.CustomComponentConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-customcomponentconfiguration
         */
        readonly customComponentConfiguration?: CfnApplication.ComponentConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnApplication.ComponentMonitoringSettingProperty.DefaultOverwriteComponentConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-defaultoverwritecomponentconfiguration
         */
        readonly defaultOverwriteComponentConfiguration?: CfnApplication.ComponentConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnApplication.ComponentMonitoringSettingProperty.Tier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-tier
         */
        readonly tier?: string;
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html
     */
    interface ConfigurationDetailsProperty {
        /**
         * `CfnApplication.ConfigurationDetailsProperty.AlarmMetrics`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-alarmmetrics
         */
        readonly alarmMetrics?: Array<CfnApplication.AlarmMetricProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplication.ConfigurationDetailsProperty.Alarms`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-alarms
         */
        readonly alarms?: Array<CfnApplication.AlarmProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplication.ConfigurationDetailsProperty.JMXPrometheusExporter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-jmxprometheusexporter
         */
        readonly jmxPrometheusExporter?: CfnApplication.JMXPrometheusExporterProperty | cdk.IResolvable;
        /**
         * `CfnApplication.ConfigurationDetailsProperty.Logs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-logs
         */
        readonly logs?: Array<CfnApplication.LogProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplication.ConfigurationDetailsProperty.WindowsEvents`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-windowsevents
         */
        readonly windowsEvents?: Array<CfnApplication.WindowsEventProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-customcomponent.html
     */
    interface CustomComponentProperty {
        /**
         * `CfnApplication.CustomComponentProperty.ComponentName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-customcomponent.html#cfn-applicationinsights-application-customcomponent-componentname
         */
        readonly componentName: string;
        /**
         * `CfnApplication.CustomComponentProperty.ResourceList`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-customcomponent.html#cfn-applicationinsights-application-customcomponent-resourcelist
         */
        readonly resourceList: string[];
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-jmxprometheusexporter.html
     */
    interface JMXPrometheusExporterProperty {
        /**
         * `CfnApplication.JMXPrometheusExporterProperty.HostPort`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-jmxprometheusexporter.html#cfn-applicationinsights-application-jmxprometheusexporter-hostport
         */
        readonly hostPort?: string;
        /**
         * `CfnApplication.JMXPrometheusExporterProperty.JMXURL`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-jmxprometheusexporter.html#cfn-applicationinsights-application-jmxprometheusexporter-jmxurl
         */
        readonly jmxurl?: string;
        /**
         * `CfnApplication.JMXPrometheusExporterProperty.PrometheusPort`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-jmxprometheusexporter.html#cfn-applicationinsights-application-jmxprometheusexporter-prometheusport
         */
        readonly prometheusPort?: string;
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html
     */
    interface LogProperty {
        /**
         * `CfnApplication.LogProperty.Encoding`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-encoding
         */
        readonly encoding?: string;
        /**
         * `CfnApplication.LogProperty.LogGroupName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-loggroupname
         */
        readonly logGroupName?: string;
        /**
         * `CfnApplication.LogProperty.LogPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-logpath
         */
        readonly logPath?: string;
        /**
         * `CfnApplication.LogProperty.LogType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-logtype
         */
        readonly logType: string;
        /**
         * `CfnApplication.LogProperty.PatternSet`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-patternset
         */
        readonly patternSet?: string;
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpattern.html
     */
    interface LogPatternProperty {
        /**
         * `CfnApplication.LogPatternProperty.Pattern`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpattern.html#cfn-applicationinsights-application-logpattern-pattern
         */
        readonly pattern: string;
        /**
         * `CfnApplication.LogPatternProperty.PatternName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpattern.html#cfn-applicationinsights-application-logpattern-patternname
         */
        readonly patternName: string;
        /**
         * `CfnApplication.LogPatternProperty.Rank`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpattern.html#cfn-applicationinsights-application-logpattern-rank
         */
        readonly rank: number;
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpatternset.html
     */
    interface LogPatternSetProperty {
        /**
         * `CfnApplication.LogPatternSetProperty.LogPatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpatternset.html#cfn-applicationinsights-application-logpatternset-logpatterns
         */
        readonly logPatterns: Array<CfnApplication.LogPatternProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplication.LogPatternSetProperty.PatternSetName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpatternset.html#cfn-applicationinsights-application-logpatternset-patternsetname
         */
        readonly patternSetName: string;
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponentconfigurationdetails.html
     */
    interface SubComponentConfigurationDetailsProperty {
        /**
         * `CfnApplication.SubComponentConfigurationDetailsProperty.AlarmMetrics`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponentconfigurationdetails.html#cfn-applicationinsights-application-subcomponentconfigurationdetails-alarmmetrics
         */
        readonly alarmMetrics?: Array<CfnApplication.AlarmMetricProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplication.SubComponentConfigurationDetailsProperty.Logs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponentconfigurationdetails.html#cfn-applicationinsights-application-subcomponentconfigurationdetails-logs
         */
        readonly logs?: Array<CfnApplication.LogProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplication.SubComponentConfigurationDetailsProperty.WindowsEvents`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponentconfigurationdetails.html#cfn-applicationinsights-application-subcomponentconfigurationdetails-windowsevents
         */
        readonly windowsEvents?: Array<CfnApplication.WindowsEventProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponenttypeconfiguration.html
     */
    interface SubComponentTypeConfigurationProperty {
        /**
         * `CfnApplication.SubComponentTypeConfigurationProperty.SubComponentConfigurationDetails`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponenttypeconfiguration.html#cfn-applicationinsights-application-subcomponenttypeconfiguration-subcomponentconfigurationdetails
         */
        readonly subComponentConfigurationDetails: CfnApplication.SubComponentConfigurationDetailsProperty | cdk.IResolvable;
        /**
         * `CfnApplication.SubComponentTypeConfigurationProperty.SubComponentType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponenttypeconfiguration.html#cfn-applicationinsights-application-subcomponenttypeconfiguration-subcomponenttype
         */
        readonly subComponentType: string;
    }
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`.
 *
 * @external
 * @cloudformationResource AWS::ApplicationInsights::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html
     */
    interface WindowsEventProperty {
        /**
         * `CfnApplication.WindowsEventProperty.EventLevels`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html#cfn-applicationinsights-application-windowsevent-eventlevels
         */
        readonly eventLevels: string[];
        /**
         * `CfnApplication.WindowsEventProperty.EventName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html#cfn-applicationinsights-application-windowsevent-eventname
         */
        readonly eventName: string;
        /**
         * `CfnApplication.WindowsEventProperty.LogGroupName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html#cfn-applicationinsights-application-windowsevent-loggroupname
         */
        readonly logGroupName: string;
        /**
         * `CfnApplication.WindowsEventProperty.PatternSet`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html#cfn-applicationinsights-application-windowsevent-patternset
         */
        readonly patternSet?: string;
    }
}
