import * as cloudwatch from "../../aws-cloudwatch";
import * as cdk from "../../core";
import { Construct } from 'constructs';
import { IScalableTarget } from './scalable-target';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) Base interface for target tracking props.
 *
 * Contains the attributes that are common to target tracking policies,
 * except the ones relating to the metric and to the scalable target.
 *
 * This interface is reused by more specific target tracking props objects
 * in other services.
 *
 * @experimental
 */
export interface BaseTargetTrackingProps {
    /**
     * (experimental) A name for the scaling policy.
     *
     * @default - Automatically generated name.
     * @experimental
     */
    readonly policyName?: string;
    /**
     * (experimental) Indicates whether scale in by the target tracking policy is disabled.
     *
     * If the value is true, scale in is disabled and the target tracking policy
     * won't remove capacity from the scalable resource. Otherwise, scale in is
     * enabled and the target tracking policy can remove capacity from the
     * scalable resource.
     *
     * @default false
     * @experimental
     */
    readonly disableScaleIn?: boolean;
    /**
     * (experimental) Period after a scale in activity completes before another scale in activity can start.
     *
     * @default Duration.seconds(300) for the following scalable targets: ECS services,
     * Spot Fleet requests, EMR clusters, AppStream 2.0 fleets, Aurora DB clusters,
     * Amazon SageMaker endpoint variants, Custom resources. For all other scalable
     * targets, the default value is Duration.seconds(0): DynamoDB tables, DynamoDB
     * global secondary indexes, Amazon Comprehend document classification endpoints,
     * Lambda provisioned concurrency
     * @experimental
     */
    readonly scaleInCooldown?: cdk.Duration;
    /**
     * (experimental) Period after a scale out activity completes before another scale out activity can start.
     *
     * @default Duration.seconds(300) for the following scalable targets: ECS services,
     * Spot Fleet requests, EMR clusters, AppStream 2.0 fleets, Aurora DB clusters,
     * Amazon SageMaker endpoint variants, Custom resources. For all other scalable
     * targets, the default value is Duration.seconds(0): DynamoDB tables, DynamoDB
     * global secondary indexes, Amazon Comprehend document classification endpoints,
     * Lambda provisioned concurrency
     * @experimental
     */
    readonly scaleOutCooldown?: cdk.Duration;
}
/**
 * (experimental) Properties for a Target Tracking policy that include the metric but exclude the target.
 *
 * @experimental
 */
export interface BasicTargetTrackingScalingPolicyProps extends BaseTargetTrackingProps {
    /**
     * (experimental) The target value for the metric.
     *
     * @experimental
     */
    readonly targetValue: number;
    /**
     * (experimental) A predefined metric for application autoscaling.
     *
     * The metric must track utilization. Scaling out will happen if the metric is higher than
     * the target value, scaling in will happen in the metric is lower than the target value.
     *
     * Exactly one of customMetric or predefinedMetric must be specified.
     *
     * @default - No predefined metrics.
     * @experimental
     */
    readonly predefinedMetric?: PredefinedMetric;
    /**
     * (experimental) Identify the resource associated with the metric type.
     *
     * Only used for predefined metric ALBRequestCountPerTarget.
     *
     * @default - No resource label.
     * @experimental
     * @example
     *
     * app/<load-balancer-name>/<load-balancer-id>/targetgroup/<target-group-name>/<target-group-id>
     */
    readonly resourceLabel?: string;
    /**
     * (experimental) A custom metric for application autoscaling.
     *
     * The metric must track utilization. Scaling out will happen if the metric is higher than
     * the target value, scaling in will happen in the metric is lower than the target value.
     *
     * Exactly one of customMetric or predefinedMetric must be specified.
     *
     * @default - No custom metric.
     * @experimental
     */
    readonly customMetric?: cloudwatch.IMetric;
}
/**
 * (experimental) Properties for a concrete TargetTrackingPolicy.
 *
 * Adds the scalingTarget.
 *
 * @experimental
 */
export interface TargetTrackingScalingPolicyProps extends BasicTargetTrackingScalingPolicyProps {
    /**
     * @experimental
     */
    readonly scalingTarget: IScalableTarget;
}
/**
 * @experimental
 */
export declare class TargetTrackingScalingPolicy extends CoreConstruct {
    /**
     * (experimental) ARN of the scaling policy.
     *
     * @experimental
     */
    readonly scalingPolicyArn: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: TargetTrackingScalingPolicyProps);
}
/**
 * (experimental) One of the predefined autoscaling metrics.
 *
 * @experimental
 */
export declare enum PredefinedMetric {
    /**
     * (experimental) DYNAMODB_READ_CAPACITY_UTILIZATIO.
     *
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     * @experimental
     */
    DYNAMODB_READ_CAPACITY_UTILIZATION = "DynamoDBReadCapacityUtilization",
    /**
     * (experimental) DYANMODB_WRITE_CAPACITY_UTILIZATION.
     *
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     * @experimental
     */
    DYANMODB_WRITE_CAPACITY_UTILIZATION = "DynamoDBWriteCapacityUtilization",
    /**
     * (experimental) ALB_REQUEST_COUNT_PER_TARGET.
     *
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     * @experimental
     */
    ALB_REQUEST_COUNT_PER_TARGET = "ALBRequestCountPerTarget",
    /**
     * (experimental) RDS_READER_AVERAGE_CPU_UTILIZATION.
     *
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     * @experimental
     */
    RDS_READER_AVERAGE_CPU_UTILIZATION = "RDSReaderAverageCPUUtilization",
    /**
     * (experimental) RDS_READER_AVERAGE_DATABASE_CONNECTIONS.
     *
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     * @experimental
     */
    RDS_READER_AVERAGE_DATABASE_CONNECTIONS = "RDSReaderAverageDatabaseConnections",
    /**
     * (experimental) EC2_SPOT_FLEET_REQUEST_AVERAGE_CPU_UTILIZATION.
     *
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     * @experimental
     */
    EC2_SPOT_FLEET_REQUEST_AVERAGE_CPU_UTILIZATION = "EC2SpotFleetRequestAverageCPUUtilization",
    /**
     * (experimental) EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_IN.
     *
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     * @experimental
     */
    EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_IN = "EC2SpotFleetRequestAverageNetworkIn",
    /**
     * (experimental) EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_OUT.
     *
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     * @experimental
     */
    EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_OUT = "EC2SpotFleetRequestAverageNetworkOut",
    /**
     * (experimental) SAGEMAKER_VARIANT_INVOCATIONS_PER_INSTANCE.
     *
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     * @experimental
     */
    SAGEMAKER_VARIANT_INVOCATIONS_PER_INSTANCE = "SageMakerVariantInvocationsPerInstance",
    /**
     * (experimental) ECS_SERVICE_AVERAGE_CPU_UTILIZATION.
     *
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     * @experimental
     */
    ECS_SERVICE_AVERAGE_CPU_UTILIZATION = "ECSServiceAverageCPUUtilization",
    /**
     * (experimental) ECS_SERVICE_AVERAGE_MEMORY_UTILIZATION.
     *
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     * @experimental
     */
    ECS_SERVICE_AVERAGE_MEMORY_UTILIZATION = "ECSServiceAverageMemoryUtilization",
    /**
     * (experimental) LAMBDA_PROVISIONED_CONCURRENCY_UTILIZATION.
     *
     * @see https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics.html#monitoring-metrics-concurrency
     * @experimental
     */
    LAMBDA_PROVISIONED_CONCURRENCY_UTILIZATION = "LambdaProvisionedConcurrencyUtilization",
    /**
     * (experimental) KAFKA_BROKER_STORAGE_UTILIZATION.
     *
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     * @experimental
     */
    KAFKA_BROKER_STORAGE_UTILIZATION = "KafkaBrokerStorageUtilization"
}
