"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketStage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
const base_1 = require("../common/base");
/**
 * (experimental) Represents a stage where an instance of the API is deployed.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Stage
 */
class WebSocketStage extends base_1.StageBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.stageName,
        });
        this.baseApi = props.webSocketApi;
        this.api = props.webSocketApi;
        this.stageName = this.physicalName;
        new apigatewayv2_generated_1.CfnStage(this, 'Resource', {
            apiId: props.webSocketApi.apiId,
            stageName: this.physicalName,
            autoDeploy: props.autoDeploy,
        });
        if (props.domainMapping) {
            this._addDomainMapping(props.domainMapping);
        }
    }
    /**
     * (experimental) Import an existing stage into this CDK app.
     *
     * @experimental
     */
    static fromWebSocketStageAttributes(scope, id, attrs) {
        class Import extends base_1.StageBase {
            constructor() {
                super(...arguments);
                this.baseApi = attrs.api;
                this.stageName = attrs.stageName;
                this.api = attrs.api;
            }
            get url() {
                throw new Error('url is not available for imported stages.');
            }
        }
        return new Import(scope, id);
    }
    /**
     * (experimental) The URL to this stage.
     *
     * @experimental
     */
    get url() {
        const s = core_1.Stack.of(this);
        const urlPath = this.stageName;
        return `wss://${this.api.apiId}.execute-api.${s.region}.${s.urlSuffix}/${urlPath}`;
    }
}
exports.WebSocketStage = WebSocketStage;
_a = JSII_RTTI_SYMBOL_1;
WebSocketStage[_a] = { fqn: "monocdk.aws_apigatewayv2.WebSocketStage", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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