"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketRoute = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * (experimental) Route class that creates the Route for API Gateway WebSocket API.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Route
 */
class WebSocketRoute extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.webSocketApi = props.webSocketApi;
        this.routeKey = props.routeKey;
        const config = props.integration.bind({
            route: this,
            scope: this,
        });
        const integration = props.webSocketApi._addIntegration(this, config);
        const route = new apigatewayv2_generated_1.CfnRoute(this, 'Resource', {
            apiId: props.webSocketApi.apiId,
            routeKey: props.routeKey,
            target: `integrations/${integration.integrationId}`,
        });
        this.routeId = route.ref;
    }
}
exports.WebSocketRoute = WebSocketRoute;
_a = JSII_RTTI_SYMBOL_1;
WebSocketRoute[_a] = { fqn: "monocdk.aws_apigatewayv2.WebSocketRoute", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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