"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketApi = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
const base_1 = require("../common/base");
const integration_1 = require("./integration");
const route_1 = require("./route");
/**
 * (experimental) Create a new API Gateway WebSocket API endpoint.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Api
 */
class WebSocketApi extends base_1.ApiBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        this.webSocketApiName = (_b = props === null || props === void 0 ? void 0 : props.apiName) !== null && _b !== void 0 ? _b : id;
        const resource = new apigatewayv2_generated_1.CfnApi(this, 'Resource', {
            name: this.webSocketApiName,
            protocolType: 'WEBSOCKET',
            description: props === null || props === void 0 ? void 0 : props.description,
            routeSelectionExpression: (_c = props === null || props === void 0 ? void 0 : props.routeSelectionExpression) !== null && _c !== void 0 ? _c : '$request.body.action',
        });
        this.apiId = resource.ref;
        this.apiEndpoint = resource.attrApiEndpoint;
        if (props === null || props === void 0 ? void 0 : props.connectRouteOptions) {
            this.addRoute('$connect', props.connectRouteOptions);
        }
        if (props === null || props === void 0 ? void 0 : props.disconnectRouteOptions) {
            this.addRoute('$disconnect', props.disconnectRouteOptions);
        }
        if (props === null || props === void 0 ? void 0 : props.defaultRouteOptions) {
            this.addRoute('$default', props.defaultRouteOptions);
        }
    }
    /**
     * @internal
     */
    _addIntegration(scope, config) {
        const { configHash, integration: existingIntegration } = this._integrationCache.getIntegration(scope, config);
        if (existingIntegration) {
            return existingIntegration;
        }
        const integration = new integration_1.WebSocketIntegration(scope, `WebSocketIntegration-${configHash}`, {
            webSocketApi: this,
            integrationType: config.type,
            integrationUri: config.uri,
        });
        this._integrationCache.saveIntegration(scope, config, integration);
        return integration;
    }
    /**
     * (experimental) Add a new route.
     *
     * @experimental
     */
    addRoute(routeKey, options) {
        return new route_1.WebSocketRoute(this, `${routeKey}-Route`, {
            webSocketApi: this,
            routeKey,
            ...options,
        });
    }
}
exports.WebSocketApi = WebSocketApi;
_a = JSII_RTTI_SYMBOL_1;
WebSocketApi[_a] = { fqn: "monocdk.aws_apigatewayv2.WebSocketApi", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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