"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationCache = void 0;
const crypto = require("crypto");
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
class IntegrationCache {
    constructor() {
        this.integrations = {};
    }
    getIntegration(scope, config) {
        const configHash = this.integrationConfigHash(scope, config);
        const integration = this.integrations[configHash];
        return { configHash, integration };
    }
    saveIntegration(scope, config, integration) {
        const configHash = this.integrationConfigHash(scope, config);
        this.integrations[configHash] = integration;
    }
    integrationConfigHash(scope, config) {
        const stringifiedConfig = JSON.stringify(core_1.Stack.of(scope).resolve(config));
        const configHash = crypto.createHash('md5').update(stringifiedConfig).digest('hex');
        return configHash;
    }
}
exports.IntegrationCache = IntegrationCache;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWdyYXRpb24tY2FjaGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnRlZ3JhdGlvbi1jYWNoZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxpQ0FBaUM7QUFDakMsd0NBQXNDLENBQUMsZ0RBQWdEO0FBTXZGLE1BQWEsZ0JBQWdCO0lBQTdCO1FBQ1ksaUJBQVksR0FBaUMsRUFBRSxDQUFDO0lBZTVELENBQUM7SUFkRyxjQUFjLENBQUMsS0FBZ0IsRUFBRSxNQUF5QjtRQUN0RCxNQUFNLFVBQVUsR0FBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxFQUFFLE1BQU0sQ0FBQyxDQUFDO1FBQzdELE1BQU0sV0FBVyxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDbEQsT0FBTyxFQUFFLFVBQVUsRUFBRSxXQUFXLEVBQUUsQ0FBQztJQUN2QyxDQUFDO0lBQ0QsZUFBZSxDQUFDLEtBQWdCLEVBQUUsTUFBeUIsRUFBRSxXQUF5QjtRQUNsRixNQUFNLFVBQVUsR0FBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxFQUFFLE1BQU0sQ0FBQyxDQUFDO1FBQzdELElBQUksQ0FBQyxZQUFZLENBQUMsVUFBVSxDQUFDLEdBQUcsV0FBVyxDQUFDO0lBQ2hELENBQUM7SUFDTyxxQkFBcUIsQ0FBQyxLQUFnQixFQUFFLE1BQXlCO1FBQ3JFLE1BQU0saUJBQWlCLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxZQUFLLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO1FBQzFFLE1BQU0sVUFBVSxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxDQUFDLGlCQUFpQixDQUFDLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ3BGLE9BQU8sVUFBVSxDQUFDO0lBQ3RCLENBQUM7Q0FDSjtBQWhCRCw0Q0FnQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjcnlwdG8gZnJvbSAnY3J5cHRvJztcbmltcG9ydCB7IFN0YWNrIH0gZnJvbSBcIi4uLy4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IElJbnRlZ3JhdGlvbiB9IGZyb20gJy4uL2NvbW1vbi9pbnRlZ3JhdGlvbic7XG5pbXBvcnQgeyBIdHRwUm91dGVJbnRlZ3JhdGlvbkNvbmZpZyB9IGZyb20gJy4uL2h0dHAnO1xuaW1wb3J0IHsgV2ViU29ja2V0Um91dGVJbnRlZ3JhdGlvbkNvbmZpZyB9IGZyb20gJy4uL3dlYnNvY2tldCc7XG50eXBlIEludGVncmF0aW9uQ29uZmlnID0gSHR0cFJvdXRlSW50ZWdyYXRpb25Db25maWcgfCBXZWJTb2NrZXRSb3V0ZUludGVncmF0aW9uQ29uZmlnO1xuZXhwb3J0IGNsYXNzIEludGVncmF0aW9uQ2FjaGUge1xuICAgIHByaXZhdGUgaW50ZWdyYXRpb25zOiBSZWNvcmQ8c3RyaW5nLCBJSW50ZWdyYXRpb24+ID0ge307XG4gICAgZ2V0SW50ZWdyYXRpb24oc2NvcGU6IENvbnN0cnVjdCwgY29uZmlnOiBJbnRlZ3JhdGlvbkNvbmZpZykge1xuICAgICAgICBjb25zdCBjb25maWdIYXNoID0gdGhpcy5pbnRlZ3JhdGlvbkNvbmZpZ0hhc2goc2NvcGUsIGNvbmZpZyk7XG4gICAgICAgIGNvbnN0IGludGVncmF0aW9uID0gdGhpcy5pbnRlZ3JhdGlvbnNbY29uZmlnSGFzaF07XG4gICAgICAgIHJldHVybiB7IGNvbmZpZ0hhc2gsIGludGVncmF0aW9uIH07XG4gICAgfVxuICAgIHNhdmVJbnRlZ3JhdGlvbihzY29wZTogQ29uc3RydWN0LCBjb25maWc6IEludGVncmF0aW9uQ29uZmlnLCBpbnRlZ3JhdGlvbjogSUludGVncmF0aW9uKSB7XG4gICAgICAgIGNvbnN0IGNvbmZpZ0hhc2ggPSB0aGlzLmludGVncmF0aW9uQ29uZmlnSGFzaChzY29wZSwgY29uZmlnKTtcbiAgICAgICAgdGhpcy5pbnRlZ3JhdGlvbnNbY29uZmlnSGFzaF0gPSBpbnRlZ3JhdGlvbjtcbiAgICB9XG4gICAgcHJpdmF0ZSBpbnRlZ3JhdGlvbkNvbmZpZ0hhc2goc2NvcGU6IENvbnN0cnVjdCwgY29uZmlnOiBJbnRlZ3JhdGlvbkNvbmZpZyk6IHN0cmluZyB7XG4gICAgICAgIGNvbnN0IHN0cmluZ2lmaWVkQ29uZmlnID0gSlNPTi5zdHJpbmdpZnkoU3RhY2sub2Yoc2NvcGUpLnJlc29sdmUoY29uZmlnKSk7XG4gICAgICAgIGNvbnN0IGNvbmZpZ0hhc2ggPSBjcnlwdG8uY3JlYXRlSGFzaCgnbWQ1JykudXBkYXRlKHN0cmluZ2lmaWVkQ29uZmlnKS5kaWdlc3QoJ2hleCcpO1xuICAgICAgICByZXR1cm4gY29uZmlnSGFzaDtcbiAgICB9XG59XG4iXX0=