"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpRoute = exports.HttpRouteKey = exports.HttpMethod = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const constructs_1 = require("constructs");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * (experimental) Supported HTTP methods.
 *
 * @experimental
 */
var HttpMethod;
(function (HttpMethod) {
    HttpMethod["ANY"] = "ANY";
    HttpMethod["DELETE"] = "DELETE";
    HttpMethod["GET"] = "GET";
    HttpMethod["HEAD"] = "HEAD";
    HttpMethod["OPTIONS"] = "OPTIONS";
    HttpMethod["PATCH"] = "PATCH";
    HttpMethod["POST"] = "POST";
    HttpMethod["PUT"] = "PUT";
})(HttpMethod = exports.HttpMethod || (exports.HttpMethod = {}));
/**
 * (experimental) HTTP route in APIGateway is a combination of the HTTP method and the path component.
 *
 * This class models that combination.
 *
 * @experimental
 */
class HttpRouteKey {
    constructor(key, path) {
        this.key = key;
        this.path = path;
    }
    /**
     * (experimental) Create a route key with the combination of the path and the method.
     *
     * @param method default is 'ANY'.
     * @experimental
     */
    static with(path, method) {
        if (path !== '/' && (!path.startsWith('/') || path.endsWith('/'))) {
            throw new Error('path must always start with a "/" and not end with a "/"');
        }
        return new HttpRouteKey(`${method !== null && method !== void 0 ? method : HttpMethod.ANY} ${path}`, path);
    }
}
exports.HttpRouteKey = HttpRouteKey;
_a = JSII_RTTI_SYMBOL_1;
HttpRouteKey[_a] = { fqn: "monocdk.aws_apigatewayv2.HttpRouteKey", version: "1.106.1" };
/**
 * (experimental) The catch-all route of the API, i.e., when no other routes match.
 *
 * @experimental
 */
HttpRouteKey.DEFAULT = new HttpRouteKey('$default');
/**
 * Supported Route Authorizer types
 */
var HttpRouteAuthorizationType;
(function (HttpRouteAuthorizationType) {
    /** JSON Web Tokens */
    HttpRouteAuthorizationType["JWT"] = "JWT";
    /** Lambda Authorizer */
    HttpRouteAuthorizationType["CUSTOM"] = "CUSTOM";
    /** No authorizer */
    HttpRouteAuthorizationType["NONE"] = "NONE";
})(HttpRouteAuthorizationType || (HttpRouteAuthorizationType = {}));
/**
 * (experimental) Route class that creates the Route for API Gateway HTTP API.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Route
 */
class HttpRoute extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _c;
        super(scope, id);
        this.httpApi = props.httpApi;
        this.path = props.routeKey.path;
        const config = props.integration.bind({
            route: this,
            scope: this,
        });
        const integration = props.httpApi._addIntegration(this, config);
        const authBindResult = props.authorizer ? props.authorizer.bind({
            route: this,
            scope: this.httpApi instanceof constructs_1.Construct ? this.httpApi : this,
        }) : undefined;
        if (authBindResult && !(authBindResult.authorizationType in HttpRouteAuthorizationType)) {
            throw new Error('authorizationType should either be JWT, CUSTOM, or NONE');
        }
        let authorizationScopes = authBindResult === null || authBindResult === void 0 ? void 0 : authBindResult.authorizationScopes;
        if (authBindResult && props.authorizationScopes) {
            authorizationScopes = Array.from(new Set([
                ...authorizationScopes !== null && authorizationScopes !== void 0 ? authorizationScopes : [],
                ...props.authorizationScopes,
            ]));
        }
        if ((authorizationScopes === null || authorizationScopes === void 0 ? void 0 : authorizationScopes.length) === 0) {
            authorizationScopes = undefined;
        }
        const routeProps = {
            apiId: props.httpApi.apiId,
            routeKey: props.routeKey.key,
            target: `integrations/${integration.integrationId}`,
            authorizerId: authBindResult === null || authBindResult === void 0 ? void 0 : authBindResult.authorizerId,
            authorizationType: (_c = authBindResult === null || authBindResult === void 0 ? void 0 : authBindResult.authorizationType) !== null && _c !== void 0 ? _c : 'NONE',
            authorizationScopes,
        };
        const route = new apigatewayv2_generated_1.CfnRoute(this, 'Resource', routeProps);
        this.routeId = route.ref;
    }
}
exports.HttpRoute = HttpRoute;
_b = JSII_RTTI_SYMBOL_1;
HttpRoute[_b] = { fqn: "monocdk.aws_apigatewayv2.HttpRoute", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicm91dGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJyb3V0ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLHdDQUF5QyxDQUFDLGdEQUFnRDtBQUMxRiwyQ0FBdUM7QUFDdkMsc0VBQW9FOzs7Ozs7QUFxQnBFLElBQVksVUFpQlg7QUFqQkQsV0FBWSxVQUFVO0lBRWxCLHlCQUFXLENBQUE7SUFFWCwrQkFBaUIsQ0FBQTtJQUVqQix5QkFBVyxDQUFBO0lBRVgsMkJBQWEsQ0FBQTtJQUViLGlDQUFtQixDQUFBO0lBRW5CLDZCQUFlLENBQUE7SUFFZiwyQkFBYSxDQUFBO0lBRWIseUJBQVcsQ0FBQTtBQUNmLENBQUMsRUFqQlcsVUFBVSxHQUFWLGtCQUFVLEtBQVYsa0JBQVUsUUFpQnJCOzs7Ozs7OztBQUtELE1BQWEsWUFBWTtJQXdCckIsWUFBb0IsR0FBVyxFQUFFLElBQWE7UUFDMUMsSUFBSSxDQUFDLEdBQUcsR0FBRyxHQUFHLENBQUM7UUFDZixJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQztJQUNyQixDQUFDOzs7Ozs7O0lBbEJNLE1BQU0sQ0FBQyxJQUFJLENBQUMsSUFBWSxFQUFFLE1BQW1CO1FBQ2hELElBQUksSUFBSSxLQUFLLEdBQUcsSUFBSSxDQUFDLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsSUFBSSxJQUFJLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxDQUFDLEVBQUU7WUFDL0QsTUFBTSxJQUFJLEtBQUssQ0FBQywwREFBMEQsQ0FBQyxDQUFDO1NBQy9FO1FBQ0QsT0FBTyxJQUFJLFlBQVksQ0FBQyxHQUFHLE1BQU0sYUFBTixNQUFNLGNBQU4sTUFBTSxHQUFJLFVBQVUsQ0FBQyxHQUFHLElBQUksSUFBSSxFQUFFLEVBQUUsSUFBSSxDQUFDLENBQUM7SUFDekUsQ0FBQzs7QUFkTCxvQ0E0QkM7Ozs7Ozs7O0FBeEIwQixvQkFBTyxHQUFHLElBQUksWUFBWSxDQUFDLFVBQVUsQ0FBQyxDQUFDO0FBNERsRTs7R0FFRztBQUNILElBQUssMEJBT0o7QUFQRCxXQUFLLDBCQUEwQjtJQUMzQixzQkFBc0I7SUFDdEIseUNBQVcsQ0FBQTtJQUNYLHdCQUF3QjtJQUN4QiwrQ0FBaUIsQ0FBQTtJQUNqQixvQkFBb0I7SUFDcEIsMkNBQWEsQ0FBQTtBQUNqQixDQUFDLEVBUEksMEJBQTBCLEtBQTFCLDBCQUEwQixRQU85Qjs7Ozs7OztBQUtELE1BQWEsU0FBVSxTQUFRLGVBQVE7Ozs7SUFJbkMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFxQjs7UUFDM0QsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNqQixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7UUFDN0IsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQztRQUNoQyxNQUFNLE1BQU0sR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQztZQUNsQyxLQUFLLEVBQUUsSUFBSTtZQUNYLEtBQUssRUFBRSxJQUFJO1NBQ2QsQ0FBQyxDQUFDO1FBQ0gsTUFBTSxXQUFXLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQyxlQUFlLENBQUMsSUFBSSxFQUFFLE1BQU0sQ0FBQyxDQUFDO1FBQ2hFLE1BQU0sY0FBYyxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO1lBQzVELEtBQUssRUFBRSxJQUFJO1lBQ1gsS0FBSyxFQUFFLElBQUksQ0FBQyxPQUFPLFlBQVksc0JBQVMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsSUFBSTtTQUNqRSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztRQUNmLElBQUksY0FBYyxJQUFJLENBQUMsQ0FBQyxjQUFjLENBQUMsaUJBQWlCLElBQUksMEJBQTBCLENBQUMsRUFBRTtZQUNyRixNQUFNLElBQUksS0FBSyxDQUFDLHlEQUF5RCxDQUFDLENBQUM7U0FDOUU7UUFDRCxJQUFJLG1CQUFtQixHQUFHLGNBQWMsYUFBZCxjQUFjLHVCQUFkLGNBQWMsQ0FBRSxtQkFBbUIsQ0FBQztRQUM5RCxJQUFJLGNBQWMsSUFBSSxLQUFLLENBQUMsbUJBQW1CLEVBQUU7WUFDN0MsbUJBQW1CLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLEdBQUcsQ0FBQztnQkFDckMsR0FBRyxtQkFBbUIsYUFBbkIsbUJBQW1CLGNBQW5CLG1CQUFtQixHQUFJLEVBQUU7Z0JBQzVCLEdBQUcsS0FBSyxDQUFDLG1CQUFtQjthQUMvQixDQUFDLENBQUMsQ0FBQztTQUNQO1FBQ0QsSUFBSSxDQUFBLG1CQUFtQixhQUFuQixtQkFBbUIsdUJBQW5CLG1CQUFtQixDQUFFLE1BQU0sTUFBSyxDQUFDLEVBQUU7WUFDbkMsbUJBQW1CLEdBQUcsU0FBUyxDQUFDO1NBQ25DO1FBQ0QsTUFBTSxVQUFVLEdBQWtCO1lBQzlCLEtBQUssRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLEtBQUs7WUFDMUIsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRztZQUM1QixNQUFNLEVBQUUsZ0JBQWdCLFdBQVcsQ0FBQyxhQUFhLEVBQUU7WUFDbkQsWUFBWSxFQUFFLGNBQWMsYUFBZCxjQUFjLHVCQUFkLGNBQWMsQ0FBRSxZQUFZO1lBQzFDLGlCQUFpQixRQUFFLGNBQWMsYUFBZCxjQUFjLHVCQUFkLGNBQWMsQ0FBRSxpQkFBaUIsbUNBQUksTUFBTTtZQUM5RCxtQkFBbUI7U0FDdEIsQ0FBQztRQUNGLE1BQU0sS0FBSyxHQUFHLElBQUksaUNBQVEsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFLFVBQVUsQ0FBQyxDQUFDO1FBQ3pELElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLEdBQUcsQ0FBQztJQUM3QixDQUFDOztBQXhDTCw4QkF5Q0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBSZXNvdXJjZSB9IGZyb20gXCIuLi8uLi8uLi9jb3JlXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9jb3JlJ1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBDZm5Sb3V0ZSwgQ2ZuUm91dGVQcm9wcyB9IGZyb20gJy4uL2FwaWdhdGV3YXl2Mi5nZW5lcmF0ZWQnO1xuaW1wb3J0IHsgSVJvdXRlIH0gZnJvbSAnLi4vY29tbW9uJztcbmltcG9ydCB7IElIdHRwQXBpIH0gZnJvbSAnLi9hcGknO1xuaW1wb3J0IHsgSUh0dHBSb3V0ZUF1dGhvcml6ZXIgfSBmcm9tICcuL2F1dGhvcml6ZXInO1xuaW1wb3J0IHsgSUh0dHBSb3V0ZUludGVncmF0aW9uIH0gZnJvbSAnLi9pbnRlZ3JhdGlvbic7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIElIdHRwUm91dGUgZXh0ZW5kcyBJUm91dGUge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgaHR0cEFwaTogSUh0dHBBcGk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBwYXRoPzogc3RyaW5nO1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgZW51bSBIdHRwTWV0aG9kIHtcbiAgICAgICAgICAgICAgICAgICBcbiAgICBBTlkgPSAnQU5ZJyxcbiAgICAgICAgICAgICAgICAgICAgICBcbiAgICBERUxFVEUgPSAnREVMRVRFJyxcbiAgICAgICAgICAgICAgICAgICBcbiAgICBHRVQgPSAnR0VUJyxcbiAgICAgICAgICAgICAgICAgICAgXG4gICAgSEVBRCA9ICdIRUFEJyxcbiAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgT1BUSU9OUyA9ICdPUFRJT05TJyxcbiAgICAgICAgICAgICAgICAgICAgIFxuICAgIFBBVENIID0gJ1BBVENIJyxcbiAgICAgICAgICAgICAgICAgICAgXG4gICAgUE9TVCA9ICdQT1NUJyxcbiAgICAgICAgICAgICAgICAgICBcbiAgICBQVVQgPSAnUFVUJ1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBIdHRwUm91dGVLZXkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBERUZBVUxUID0gbmV3IEh0dHBSb3V0ZUtleSgnJGRlZmF1bHQnKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyB3aXRoKHBhdGg6IHN0cmluZywgbWV0aG9kPzogSHR0cE1ldGhvZCkge1xuICAgICAgICBpZiAocGF0aCAhPT0gJy8nICYmICghcGF0aC5zdGFydHNXaXRoKCcvJykgfHwgcGF0aC5lbmRzV2l0aCgnLycpKSkge1xuICAgICAgICAgICAgdGhyb3cgbmV3IEVycm9yKCdwYXRoIG11c3QgYWx3YXlzIHN0YXJ0IHdpdGggYSBcIi9cIiBhbmQgbm90IGVuZCB3aXRoIGEgXCIvXCInKTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gbmV3IEh0dHBSb3V0ZUtleShgJHttZXRob2QgPz8gSHR0cE1ldGhvZC5BTll9ICR7cGF0aH1gLCBwYXRoKTtcbiAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyByZWFkb25seSBrZXk6IHN0cmluZztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyByZWFkb25seSBwYXRoPzogc3RyaW5nO1xuICAgIHByaXZhdGUgY29uc3RydWN0b3Ioa2V5OiBzdHJpbmcsIHBhdGg/OiBzdHJpbmcpIHtcbiAgICAgICAgdGhpcy5rZXkgPSBrZXk7XG4gICAgICAgIHRoaXMucGF0aCA9IHBhdGg7XG4gICAgfVxufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgQmF0Y2hIdHRwUm91dGVPcHRpb25zIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBpbnRlZ3JhdGlvbjogSUh0dHBSb3V0ZUludGVncmF0aW9uO1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSHR0cFJvdXRlUHJvcHMgZXh0ZW5kcyBCYXRjaEh0dHBSb3V0ZU9wdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBodHRwQXBpOiBJSHR0cEFwaTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSByb3V0ZUtleTogSHR0cFJvdXRlS2V5O1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBhdXRob3JpemVyPzogSUh0dHBSb3V0ZUF1dGhvcml6ZXI7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBhdXRob3JpemF0aW9uU2NvcGVzPzogc3RyaW5nW107XG59XG4vKipcbiAqIFN1cHBvcnRlZCBSb3V0ZSBBdXRob3JpemVyIHR5cGVzXG4gKi9cbmVudW0gSHR0cFJvdXRlQXV0aG9yaXphdGlvblR5cGUge1xuICAgIC8qKiBKU09OIFdlYiBUb2tlbnMgKi9cbiAgICBKV1QgPSAnSldUJyxcbiAgICAvKiogTGFtYmRhIEF1dGhvcml6ZXIgKi9cbiAgICBDVVNUT00gPSAnQ1VTVE9NJyxcbiAgICAvKiogTm8gYXV0aG9yaXplciAqL1xuICAgIE5PTkUgPSAnTk9ORSdcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEh0dHBSb3V0ZSBleHRlbmRzIFJlc291cmNlIGltcGxlbWVudHMgSUh0dHBSb3V0ZSB7XG4gICAgcHVibGljIHJlYWRvbmx5IHJvdXRlSWQ6IHN0cmluZztcbiAgICBwdWJsaWMgcmVhZG9ubHkgaHR0cEFwaTogSUh0dHBBcGk7XG4gICAgcHVibGljIHJlYWRvbmx5IHBhdGg/OiBzdHJpbmc7XG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEh0dHBSb3V0ZVByb3BzKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gICAgICAgIHRoaXMuaHR0cEFwaSA9IHByb3BzLmh0dHBBcGk7XG4gICAgICAgIHRoaXMucGF0aCA9IHByb3BzLnJvdXRlS2V5LnBhdGg7XG4gICAgICAgIGNvbnN0IGNvbmZpZyA9IHByb3BzLmludGVncmF0aW9uLmJpbmQoe1xuICAgICAgICAgICAgcm91dGU6IHRoaXMsXG4gICAgICAgICAgICBzY29wZTogdGhpcyxcbiAgICAgICAgfSk7XG4gICAgICAgIGNvbnN0IGludGVncmF0aW9uID0gcHJvcHMuaHR0cEFwaS5fYWRkSW50ZWdyYXRpb24odGhpcywgY29uZmlnKTtcbiAgICAgICAgY29uc3QgYXV0aEJpbmRSZXN1bHQgPSBwcm9wcy5hdXRob3JpemVyID8gcHJvcHMuYXV0aG9yaXplci5iaW5kKHtcbiAgICAgICAgICAgIHJvdXRlOiB0aGlzLFxuICAgICAgICAgICAgc2NvcGU6IHRoaXMuaHR0cEFwaSBpbnN0YW5jZW9mIENvbnN0cnVjdCA/IHRoaXMuaHR0cEFwaSA6IHRoaXMsXG4gICAgICAgIH0pIDogdW5kZWZpbmVkO1xuICAgICAgICBpZiAoYXV0aEJpbmRSZXN1bHQgJiYgIShhdXRoQmluZFJlc3VsdC5hdXRob3JpemF0aW9uVHlwZSBpbiBIdHRwUm91dGVBdXRob3JpemF0aW9uVHlwZSkpIHtcbiAgICAgICAgICAgIHRocm93IG5ldyBFcnJvcignYXV0aG9yaXphdGlvblR5cGUgc2hvdWxkIGVpdGhlciBiZSBKV1QsIENVU1RPTSwgb3IgTk9ORScpO1xuICAgICAgICB9XG4gICAgICAgIGxldCBhdXRob3JpemF0aW9uU2NvcGVzID0gYXV0aEJpbmRSZXN1bHQ/LmF1dGhvcml6YXRpb25TY29wZXM7XG4gICAgICAgIGlmIChhdXRoQmluZFJlc3VsdCAmJiBwcm9wcy5hdXRob3JpemF0aW9uU2NvcGVzKSB7XG4gICAgICAgICAgICBhdXRob3JpemF0aW9uU2NvcGVzID0gQXJyYXkuZnJvbShuZXcgU2V0KFtcbiAgICAgICAgICAgICAgICAuLi5hdXRob3JpemF0aW9uU2NvcGVzID8/IFtdLFxuICAgICAgICAgICAgICAgIC4uLnByb3BzLmF1dGhvcml6YXRpb25TY29wZXMsXG4gICAgICAgICAgICBdKSk7XG4gICAgICAgIH1cbiAgICAgICAgaWYgKGF1dGhvcml6YXRpb25TY29wZXM/Lmxlbmd0aCA9PT0gMCkge1xuICAgICAgICAgICAgYXV0aG9yaXphdGlvblNjb3BlcyA9IHVuZGVmaW5lZDtcbiAgICAgICAgfVxuICAgICAgICBjb25zdCByb3V0ZVByb3BzOiBDZm5Sb3V0ZVByb3BzID0ge1xuICAgICAgICAgICAgYXBpSWQ6IHByb3BzLmh0dHBBcGkuYXBpSWQsXG4gICAgICAgICAgICByb3V0ZUtleTogcHJvcHMucm91dGVLZXkua2V5LFxuICAgICAgICAgICAgdGFyZ2V0OiBgaW50ZWdyYXRpb25zLyR7aW50ZWdyYXRpb24uaW50ZWdyYXRpb25JZH1gLFxuICAgICAgICAgICAgYXV0aG9yaXplcklkOiBhdXRoQmluZFJlc3VsdD8uYXV0aG9yaXplcklkLFxuICAgICAgICAgICAgYXV0aG9yaXphdGlvblR5cGU6IGF1dGhCaW5kUmVzdWx0Py5hdXRob3JpemF0aW9uVHlwZSA/PyAnTk9ORScsXG4gICAgICAgICAgICBhdXRob3JpemF0aW9uU2NvcGVzLFxuICAgICAgICB9O1xuICAgICAgICBjb25zdCByb3V0ZSA9IG5ldyBDZm5Sb3V0ZSh0aGlzLCAnUmVzb3VyY2UnLCByb3V0ZVByb3BzKTtcbiAgICAgICAgdGhpcy5yb3V0ZUlkID0gcm91dGUucmVmO1xuICAgIH1cbn1cbiJdfQ==