"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpNoneAuthorizer = exports.HttpAuthorizer = exports.AuthorizerPayloadVersion = exports.HttpAuthorizerType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * (experimental) Supported Authorizer types.
 *
 * @experimental
 */
var HttpAuthorizerType;
(function (HttpAuthorizerType) {
    HttpAuthorizerType["JWT"] = "JWT";
    HttpAuthorizerType["LAMBDA"] = "REQUEST";
})(HttpAuthorizerType = exports.HttpAuthorizerType || (exports.HttpAuthorizerType = {}));
/**
 * (experimental) Payload format version for lambda authorizers.
 *
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html
 * @experimental
 */
var AuthorizerPayloadVersion;
(function (AuthorizerPayloadVersion) {
    AuthorizerPayloadVersion["VERSION_1_0"] = "1.0";
    AuthorizerPayloadVersion["VERSION_2_0"] = "2.0";
})(AuthorizerPayloadVersion = exports.AuthorizerPayloadVersion || (exports.AuthorizerPayloadVersion = {}));
/**
 * (experimental) An authorizer for Http Apis.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Authorizer
 */
class HttpAuthorizer extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _c, _d;
        super(scope, id);
        let authorizerPayloadFormatVersion = props.payloadFormatVersion;
        if (props.type === HttpAuthorizerType.JWT && (!props.jwtAudience || props.jwtAudience.length === 0 || !props.jwtIssuer)) {
            throw new Error('jwtAudience and jwtIssuer are mandatory for JWT authorizers');
        }
        if (props.type === HttpAuthorizerType.LAMBDA && !props.authorizerUri) {
            throw new Error('authorizerUri is mandatory for Lambda authorizers');
        }
        /**
         * This check is required because Cloudformation will fail stack creation is this property
         * is set for the JWT authorizer. AuthorizerPayloadFormatVersion can only be set for REQUEST authorizer
         */
        if (props.type === HttpAuthorizerType.LAMBDA && typeof authorizerPayloadFormatVersion === 'undefined') {
            authorizerPayloadFormatVersion = AuthorizerPayloadVersion.VERSION_2_0;
        }
        const resource = new apigatewayv2_generated_1.CfnAuthorizer(this, 'Resource', {
            name: (_c = props.authorizerName) !== null && _c !== void 0 ? _c : id,
            apiId: props.httpApi.apiId,
            authorizerType: props.type,
            identitySource: props.identitySource,
            jwtConfiguration: undefinedIfNoKeys({
                audience: props.jwtAudience,
                issuer: props.jwtIssuer,
            }),
            enableSimpleResponses: props.enableSimpleResponses,
            authorizerPayloadFormatVersion,
            authorizerUri: props.authorizerUri,
            authorizerResultTtlInSeconds: (_d = props.resultsCacheTtl) === null || _d === void 0 ? void 0 : _d.toSeconds(),
        });
        this.authorizerId = resource.ref;
    }
    /**
     * (experimental) Import an existing HTTP Authorizer into this CDK app.
     *
     * @experimental
     */
    static fromHttpAuthorizerAttributes(scope, id, attrs) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.authorizerId = attrs.authorizerId;
                this.authorizerType = attrs.authorizerType;
            }
            bind() {
                return {
                    authorizerId: attrs.authorizerId,
                    authorizationType: attrs.authorizerType,
                };
            }
        }
        return new Import(scope, id);
    }
}
exports.HttpAuthorizer = HttpAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpAuthorizer[_a] = { fqn: "monocdk.aws_apigatewayv2.HttpAuthorizer", version: "1.106.1" };
function undefinedIfNoKeys(obj) {
    const allUndefined = Object.values(obj).every(val => val === undefined);
    return allUndefined ? undefined : obj;
}
/**
 * (experimental) Explicitly configure no authorizers on specific HTTP API routes.
 *
 * @experimental
 */
class HttpNoneAuthorizer {
    /**
     * (experimental) Bind this authorizer to a specified Http route.
     *
     * @experimental
     */
    bind(_) {
        return {
            authorizationType: 'NONE',
        };
    }
}
exports.HttpNoneAuthorizer = HttpNoneAuthorizer;
_b = JSII_RTTI_SYMBOL_1;
HttpNoneAuthorizer[_b] = { fqn: "monocdk.aws_apigatewayv2.HttpNoneAuthorizer", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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