"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StageBase = exports.ApiBase = void 0;
const cloudwatch = require("../../../aws-cloudwatch"); // Automatically re-written from '@aws-cdk/aws-cloudwatch'
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const integration_cache_1 = require("../private/integration-cache");
const api_mapping_1 = require("./api-mapping");
/**
 * Base class representing an API
 * @internal
 */
class ApiBase extends core_1.Resource {
    constructor() {
        super(...arguments);
        /**
         * @internal
         */
        this._integrationCache = new integration_cache_1.IntegrationCache();
    }
    /**
     * (experimental) Return the given named metric for this Api Gateway.
     *
     * @experimental
     */
    metric(metricName, props) {
        return new cloudwatch.Metric({
            namespace: 'AWS/ApiGateway',
            metricName,
            dimensions: { ApiId: this.apiId },
            ...props,
        }).attachTo(this);
    }
}
exports.ApiBase = ApiBase;
/**
 * Base class representing a Stage
 * @internal
 */
class StageBase extends core_1.Resource {
    /**
     * @internal
     */
    _addDomainMapping(domainMapping) {
        new api_mapping_1.ApiMapping(this, `${domainMapping.domainName}${domainMapping.mappingKey}`, {
            api: this.baseApi,
            domainName: domainMapping.domainName,
            stage: this,
            apiMappingKey: domainMapping.mappingKey,
        });
        // ensure the dependency
        this.node.addDependency(domainMapping.domainName);
    }
    /**
     * (experimental) Return the given named metric for this HTTP Api Gateway Stage.
     *
     * @experimental
     */
    metric(metricName, props) {
        return this.baseApi.metric(metricName, props).with({
            dimensions: { ApiId: this.baseApi.apiId, Stage: this.stageName },
        }).attachTo(this);
    }
}
exports.StageBase = StageBase;
//# sourceMappingURL=data:application/json;base64,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