import * as cloudwatch from "../../../aws-cloudwatch";
import { Resource } from "../../../core";
import { IntegrationCache } from '../private/integration-cache';
import { IApi } from './api';
import { DomainMappingOptions, IStage } from './stage';
/**
 * Base class representing an API
 * @internal
 */
export declare abstract class ApiBase extends Resource implements IApi {
    abstract readonly apiId: string;
    abstract readonly apiEndpoint: string;
    /**
     * @internal
     */
    protected _integrationCache: IntegrationCache;
    /**
     * (experimental) Return the given named metric for this Api Gateway.
     *
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
}
/**
 * Base class representing a Stage
 * @internal
 */
export declare abstract class StageBase extends Resource implements IStage {
    abstract readonly stageName: string;
    protected abstract readonly baseApi: IApi;
    /**
     * The URL to this stage.
     */
    abstract get url(): string;
    /**
     * @internal
     */
    protected _addDomainMapping(domainMapping: DomainMappingOptions): void;
    /**
     * (experimental) Return the given named metric for this HTTP Api Gateway Stage.
     *
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
}
