"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaWebSocketIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("../../../aws-apigatewayv2"); // Automatically re-written from '@aws-cdk/aws-apigatewayv2'
const aws_iam_1 = require("../../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Lambda WebSocket Integration.
 *
 * @experimental
 */
class LambdaWebSocketIntegration {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(options) {
        const route = options.route;
        this.props.handler.addPermission(`${core_1.Names.nodeUniqueId(route.node)}-Permission`, {
            scope: options.scope,
            principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
            sourceArn: core_1.Stack.of(route).formatArn({
                service: 'execute-api',
                resource: route.webSocketApi.apiId,
                resourceName: `*/*${route.routeKey}`,
            }),
        });
        const integrationUri = core_1.Stack.of(route).formatArn({
            service: 'apigateway',
            account: 'lambda',
            resource: 'path/2015-03-31/functions',
            resourceName: `${this.props.handler.functionArn}/invocations`,
        });
        return {
            type: aws_apigatewayv2_1.WebSocketIntegrationType.AWS_PROXY,
            uri: integrationUri,
        };
    }
}
exports.LambdaWebSocketIntegration = LambdaWebSocketIntegration;
_a = JSII_RTTI_SYMBOL_1;
LambdaWebSocketIntegration[_a] = { fqn: "monocdk.aws_apigatewayv2_integrations.LambdaWebSocketIntegration", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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