"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpNlbIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("../../../aws-elasticloadbalancingv2"); // Automatically re-written from '@aws-cdk/aws-elasticloadbalancingv2'
const integration_1 = require("./private/integration");
/**
 * (experimental) The Network Load Balancer integration resource for HTTP API.
 *
 * @experimental
 */
class HttpNlbIntegration extends integration_1.HttpPrivateIntegration {
    /**
     * @experimental
     */
    constructor(props) {
        super();
        this.props = props;
    }
    /**
     * (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(options) {
        var _b, _c;
        let vpc = (_b = this.props.vpcLink) === null || _b === void 0 ? void 0 : _b.vpc;
        if (!vpc && (this.props.listener instanceof elbv2.NetworkListener)) {
            vpc = this.props.listener.loadBalancer.vpc;
        }
        if (!vpc) {
            throw new Error('The vpcLink property must be specified when using an imported Network Listener.');
        }
        const vpcLink = this._configureVpcLink(options, {
            vpcLink: this.props.vpcLink,
            vpc,
        });
        return {
            method: (_c = this.props.method) !== null && _c !== void 0 ? _c : this.httpMethod,
            payloadFormatVersion: this.payloadFormatVersion,
            type: this.integrationType,
            connectionType: this.connectionType,
            connectionId: vpcLink.vpcLinkId,
            uri: this.props.listener.listenerArn,
        };
    }
}
exports.HttpNlbIntegration = HttpNlbIntegration;
_a = JSII_RTTI_SYMBOL_1;
HttpNlbIntegration[_a] = { fqn: "monocdk.aws_apigatewayv2_integrations.HttpNlbIntegration", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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