"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpJwtAuthorizer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("../../../aws-apigatewayv2"); // Automatically re-written from '@aws-cdk/aws-apigatewayv2'
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Authorize Http Api routes on whether the requester is registered as part of an AWS Cognito user pool.
 *
 * @experimental
 */
class HttpJwtAuthorizer {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) Bind this authorizer to a specified Http route.
     *
     * @experimental
     */
    bind(options) {
        var _b;
        if (!this.authorizer) {
            const id = this.props.authorizerName && !core_1.Token.isUnresolved(this.props.authorizerName) ?
                this.props.authorizerName : 'JwtAuthorizer';
            this.authorizer = new aws_apigatewayv2_1.HttpAuthorizer(options.scope, id, {
                httpApi: options.route.httpApi,
                identitySource: (_b = this.props.identitySource) !== null && _b !== void 0 ? _b : ['$request.header.Authorization'],
                type: aws_apigatewayv2_1.HttpAuthorizerType.JWT,
                authorizerName: this.props.authorizerName,
                jwtAudience: this.props.jwtAudience,
                jwtIssuer: this.props.jwtIssuer,
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'JWT',
        };
    }
}
exports.HttpJwtAuthorizer = HttpJwtAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpJwtAuthorizer[_a] = { fqn: "monocdk.aws_apigatewayv2_authorizers.HttpJwtAuthorizer", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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