import { HttpRouteAuthorizerBindOptions, HttpRouteAuthorizerConfig, IHttpRouteAuthorizer } from "../../../aws-apigatewayv2";
/**
 * (experimental) Properties to initialize HttpJwtAuthorizer.
 *
 * @experimental
 */
export interface HttpJwtAuthorizerProps {
    /**
     * (experimental) The name of the authorizer.
     *
     * @default 'JwtAuthorizer'
     * @experimental
     */
    readonly authorizerName?: string;
    /**
     * (experimental) The identity source for which authorization is requested.
     *
     * @default ['$request.header.Authorization']
     * @experimental
     */
    readonly identitySource?: string[];
    /**
     * (experimental) A list of the intended recipients of the JWT.
     *
     * A valid JWT must provide an aud that matches at least one entry in this list.
     *
     * @experimental
     */
    readonly jwtAudience: string[];
    /**
     * (experimental) The base domain of the identity provider that issues JWT.
     *
     * @experimental
     */
    readonly jwtIssuer: string;
}
/**
 * (experimental) Authorize Http Api routes on whether the requester is registered as part of an AWS Cognito user pool.
 *
 * @experimental
 */
export declare class HttpJwtAuthorizer implements IHttpRouteAuthorizer {
    private readonly props;
    private authorizer?;
    /**
     * @experimental
     */
    constructor(props: HttpJwtAuthorizerProps);
    /**
     * (experimental) Bind this authorizer to a specified Http route.
     *
     * @experimental
     */
    bind(options: HttpRouteAuthorizerBindOptions): HttpRouteAuthorizerConfig;
}
