import { Resource } from "../../core";
import { Construct } from 'constructs';
import { IApiKey } from './api-key';
import { Method } from './method';
import { IRestApi } from './restapi';
import { Stage } from './stage';
/**
 * (experimental) Container for defining throttling parameters to API stages or methods.
 *
 * @experimental
 * @link https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html
 */
export interface ThrottleSettings {
    /**
     * (experimental) The API request steady-state rate limit (average requests per second over an extended period of time).
     *
     * @default none
     * @experimental
     */
    readonly rateLimit?: number;
    /**
     * (experimental) The maximum API request rate limit over a time ranging from one to a few seconds.
     *
     * @default none
     * @experimental
     */
    readonly burstLimit?: number;
}
/**
 * (experimental) Time period for which quota settings apply.
 *
 * @experimental
 */
export declare enum Period {
    /**
     * @experimental
     */
    DAY = "DAY",
    /**
     * @experimental
     */
    WEEK = "WEEK",
    /**
     * @experimental
     */
    MONTH = "MONTH"
}
/**
 * (experimental) Specifies the maximum number of requests that clients can make to API Gateway APIs.
 *
 * @experimental
 */
export interface QuotaSettings {
    /**
     * (experimental) The maximum number of requests that users can make within the specified time period.
     *
     * @default none
     * @experimental
     */
    readonly limit?: number;
    /**
     * (experimental) For the initial time period, the number of requests to subtract from the specified limit.
     *
     * @default none
     * @experimental
     */
    readonly offset?: number;
    /**
     * (experimental) The time period for which the maximum limit of requests applies.
     *
     * @default none
     * @experimental
     */
    readonly period?: Period;
}
/**
 * (experimental) Represents per-method throttling for a resource.
 *
 * @experimental
 */
export interface ThrottlingPerMethod {
    /**
     * (experimental) [disable-awslint:ref-via-interface] The method for which you specify the throttling settings.
     *
     * @default none
     * @experimental
     */
    readonly method: Method;
    /**
     * (experimental) Specifies the overall request rate (average requests per second) and burst capacity.
     *
     * @default none
     * @experimental
     */
    readonly throttle: ThrottleSettings;
}
/**
 * (experimental) Represents the API stages that a usage plan applies to.
 *
 * @experimental
 */
export interface UsagePlanPerApiStage {
    /**
     * @default none
     * @experimental
     */
    readonly api?: IRestApi;
    /**
     * (experimental) [disable-awslint:ref-via-interface].
     *
     * @default none
     * @experimental
     */
    readonly stage?: Stage;
    /**
     * @default none
     * @experimental
     */
    readonly throttle?: ThrottlingPerMethod[];
}
/**
 * @experimental
 */
export interface UsagePlanProps {
    /**
     * (experimental) API Stages to be associated with the usage plan.
     *
     * @default none
     * @experimental
     */
    readonly apiStages?: UsagePlanPerApiStage[];
    /**
     * (experimental) Represents usage plan purpose.
     *
     * @default none
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) Number of requests clients can make in a given time period.
     *
     * @default none
     * @experimental
     */
    readonly quota?: QuotaSettings;
    /**
     * (experimental) Overall throttle settings for the API.
     *
     * @default none
     * @experimental
     */
    readonly throttle?: ThrottleSettings;
    /**
     * (experimental) Name for this usage plan.
     *
     * @default none
     * @experimental
     */
    readonly name?: string;
    /**
     * (deprecated) ApiKey to be associated with the usage plan.
     *
     * @default none
     * @deprecated use `addApiKey()`
     */
    readonly apiKey?: IApiKey;
}
/**
 * (experimental) Options to the UsagePlan.addApiKey() method.
 *
 * @experimental
 */
export interface AddApiKeyOptions {
    /**
     * (experimental) Override the CloudFormation logical id of the AWS::ApiGateway::UsagePlanKey resource.
     *
     * @default - autogenerated by the CDK
     * @experimental
     */
    readonly overrideLogicalId?: string;
}
/**
 * @experimental
 */
export declare class UsagePlan extends Resource {
    /**
     * @experimental
     * @attribute true
     */
    readonly usagePlanId: string;
    private readonly apiStages;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: UsagePlanProps);
    /**
     * (experimental) Adds an ApiKey.
     *
     * @param apiKey the api key to associate with this usage plan.
     * @param options options that control the behaviour of this method.
     * @experimental
     */
    addApiKey(apiKey: IApiKey, options?: AddApiKeyOptions): void;
    /**
     * (experimental) Adds an apiStage.
     *
     * @experimental
     */
    addApiStage(apiStage: UsagePlanPerApiStage): void;
    /**
     *
     * @param props
     */
    private renderApiStages;
    private createStage;
    private renderQuota;
    private renderThrottle;
    private renderThrottlePerMethod;
}
